/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.baseAdapter.utils;

import android.support.annotation.LayoutRes;
import android.util.SparseIntArray;
import java.util.List;

public abstract class MultiTypeDelegate<T> {
    private static final int DEFAULT_VIEW_TYPE = -255;
    private SparseIntArray layouts;
    private boolean autoMode;
    private boolean selfMode;

    public MultiTypeDelegate(SparseIntArray layouts) {
        this.layouts = layouts;
    }

    public MultiTypeDelegate() {
    }

    public final int getDefItemViewType(List<T> data, int position) {
        T item = data.get(position);
        return item != null ? this.getItemType(item) : -255;
    }

    protected abstract int getItemType(T var1);

    public final int getLayoutId(int viewType) {
        return this.layouts.get(viewType, -404);
    }

    private void addItemType(int type, @LayoutRes int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseIntArray();
        }
        this.layouts.put(type, layoutResId);
    }

    public MultiTypeDelegate registerItemTypeAutoIncrease(int ... layoutResIds) {
        this.autoMode = true;
        this.checkMode(this.selfMode);
        for (int i = 0; i < layoutResIds.length; ++i) {
            this.addItemType(i, layoutResIds[i]);
        }
        return this;
    }

    public MultiTypeDelegate registerItemType(int type, @LayoutRes int layoutResId) {
        this.selfMode = true;
        this.checkMode(this.autoMode);
        this.addItemType(type, layoutResId);
        return this;
    }

    private void checkMode(boolean mode) {
        if (mode) {
            throw new IllegalArgumentException("Don't mess two register mode");
        }
    }
}

