/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.bottomnavigationbar;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.bottomnavigationbar.BottomNavigationEntity;

class BottomNavigationItemView
extends LinearLayout {
    private BottomNavigationEntity mBottomNavigationEntity;
    private int mTextSelectedColor;
    private int mTextUnSelectedColor;
    private ImageView mItemIcon;
    private TextView mItemText;
    private TextView mItemBadge;
    private boolean isAnim;
    private float scaleRatio;
    private int mLayoutId;
    private static final float SCALE_MAX = 1.1f;
    private ValueAnimator valueAnimator;

    protected BottomNavigationItemView(Context context) {
        this(context, null);
    }

    protected BottomNavigationItemView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected BottomNavigationItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setOrientation(1);
        this.setGravity(17);
    }

    protected void setScaleRatio(float scaleRatio) {
        this.scaleRatio = Math.abs(scaleRatio);
    }

    public float getScaleRatio() {
        return this.scaleRatio;
    }

    protected void setAnim(boolean anim) {
        this.isAnim = anim;
    }

    protected void setLayoutId(int layoutId) {
        this.mLayoutId = layoutId;
        LayoutInflater.from((Context)this.getContext()).inflate(this.mLayoutId, (ViewGroup)this, true);
        this.mItemIcon = (ImageView)this.findViewById(R.id.bnb_item_icon);
        this.mItemText = (TextView)this.findViewById(R.id.bnb_item_text);
        this.mItemBadge = (TextView)this.findViewById(R.id.bnb_item_badge);
    }

    public boolean isAnim() {
        return this.isAnim;
    }

    protected void setBottomNavigationEntity(BottomNavigationEntity bottomNavigationEntity) {
        this.mBottomNavigationEntity = bottomNavigationEntity;
        this.setDefaultState();
    }

    protected void setTextSelectedColor(int textSelectedColor) {
        this.mTextSelectedColor = textSelectedColor;
    }

    protected void setTextUnSelectedColor(int textUnSelectedColor) {
        this.mTextUnSelectedColor = textUnSelectedColor;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.rendingItemText(selected);
        this.rendingItemIcon(selected);
        if (this.isAnim) {
            if (selected) {
                this.scale(1.0f, this.scaleRatio > 1.1f ? this.scaleRatio : 1.1f);
            } else {
                this.scale(this.scaleRatio > 1.1f ? this.scaleRatio : 1.1f, 1.0f);
            }
        }
    }

    protected void setDefaultState() {
        this.rendingItemText(false);
        this.rendingItemIcon(false);
        this.rendingItemBadge();
    }

    protected void refresh() {
        this.rendingItemBadge();
    }

    private void rendingItemText(boolean select) {
        if (this.mItemText == null || this.mBottomNavigationEntity == null) {
            return;
        }
        String text = this.mBottomNavigationEntity.getText();
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mItemText.setVisibility(8);
        } else {
            this.mItemText.setText((CharSequence)text);
            this.mItemText.setVisibility(0);
            if (select) {
                this.mItemText.setTextColor(this.mTextSelectedColor);
            } else {
                this.mItemText.setTextColor(this.mTextUnSelectedColor);
            }
        }
    }

    private void rendingItemIcon(boolean select) {
        if (this.mItemIcon == null || this.mBottomNavigationEntity == null) {
            return;
        }
        if (select) {
            this.mItemIcon.setImageResource(this.mBottomNavigationEntity.getSelectedIcon());
        } else {
            this.mItemIcon.setImageResource(this.mBottomNavigationEntity.getUnSelectIcon());
        }
    }

    @SuppressLint(value={"SetTextI18n"})
    private void rendingItemBadge() {
        if (this.mItemBadge == null || this.mBottomNavigationEntity == null) {
            return;
        }
        int num = this.mBottomNavigationEntity.getBadgeNum();
        if (num > 0) {
            if (num < 99) {
                this.mItemBadge.setText((CharSequence)String.valueOf(num));
            } else {
                this.mItemBadge.setText((CharSequence)"99+");
            }
            this.mItemBadge.setVisibility(0);
        } else {
            this.mItemBadge.setVisibility(4);
        }
    }

    private void scale(float from, float to) {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        this.valueAnimator.setDuration(200L);
        this.valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float value = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                BottomNavigationItemView.this.setScaleX(value);
                BottomNavigationItemView.this.setScaleY(value);
            }
        });
        this.valueAnimator.start();
    }

    protected void onDetachedFromWindow() {
        if (null != this.valueAnimator) {
            this.valueAnimator.cancel();
        }
        super.onDetachedFromWindow();
    }
}

