/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.adapter;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.aliyunplayerbase.util.Formatter;
import com.aliyun.svideo.common.utils.image.ImageLoaderImpl;
import com.aliyun.svideo.common.utils.image.ImageLoaderOptions;
import com.aliyun.vodplayer.R;
import java.util.ArrayList;
import java.util.List;

public class AliyunPlayerDownloadListAdapter
extends RecyclerView.Adapter<PlayerDownloadListViewHolder> {
    private boolean mIsEditing = false;
    private List<AliyunDownloadMediaInfo> mMediaInfos = new ArrayList<AliyunDownloadMediaInfo>();
    private Context mContext;
    private OnItemClickListener mOnItemClickListener;
    private OnItemChildClickListener mOnItemChildClickListener;

    public AliyunPlayerDownloadListAdapter(Context context) {
        this.mContext = context;
    }

    public PlayerDownloadListViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View inflater = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.alivc_player_download_cache_list_item, parent, false);
        return new PlayerDownloadListViewHolder(inflater);
    }

    public void onBindViewHolder(final PlayerDownloadListViewHolder holder, int position) {
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AliyunPlayerDownloadListAdapter.this.mOnItemClickListener != null) {
                    AliyunPlayerDownloadListAdapter.this.mOnItemClickListener.onItemClick(AliyunPlayerDownloadListAdapter.this, holder.itemView, holder.getAdapterPosition());
                }
            }
        });
        holder.ivPreView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AliyunPlayerDownloadListAdapter.this.mOnItemChildClickListener != null) {
                    AliyunPlayerDownloadListAdapter.this.mOnItemChildClickListener.onItemChildClick(AliyunPlayerDownloadListAdapter.this, v, holder.getAdapterPosition());
                }
            }
        });
        holder.mFlFont.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AliyunPlayerDownloadListAdapter.this.mOnItemChildClickListener != null) {
                    AliyunPlayerDownloadListAdapter.this.mOnItemChildClickListener.onItemChildClick(AliyunPlayerDownloadListAdapter.this, v, holder.getAdapterPosition());
                }
            }
        });
        AliyunDownloadMediaInfo downloadMediaInfo = this.mMediaInfos.get(position);
        if (downloadMediaInfo.getProgress() == 100) {
            downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Complete);
        }
        holder.tvSize.setText((CharSequence)Formatter.getFileSizeDescription((long)downloadMediaInfo.getSize()));
        String coverUrl = downloadMediaInfo.getCoverUrl();
        new ImageLoaderImpl().loadImage(this.mContext, coverUrl, new ImageLoaderOptions.Builder().crossFade().error(R.mipmap.ic_launcher).build()).into(holder.ivPreView);
        switch (downloadMediaInfo.getStatus().ordinal()) {
            case 1: {
                holder.progressBar.setVisibility(0);
                holder.tvSize.setVisibility(8);
                holder.progressBar.setProgress(downloadMediaInfo.getProgress());
                holder.ivDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_download_video));
                holder.ivPreView.setVisibility(8);
                holder.ivDownload.setVisibility(0);
                holder.cacheLinearLayout.setVisibility(0);
                holder.tvTitle.setVisibility(4);
                holder.mTvDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.alivc_player_cache_wait));
                break;
            }
            case 2: {
                holder.progressBar.setVisibility(0);
                holder.tvSize.setVisibility(8);
                holder.progressBar.setProgress(downloadMediaInfo.getProgress());
                holder.ivDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_download_video));
                holder.ivPreView.setVisibility(8);
                holder.ivDownload.setVisibility(0);
                holder.cacheLinearLayout.setVisibility(0);
                holder.tvTitle.setVisibility(4);
                holder.mTvDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.alivc_player_cache_wait));
                break;
            }
            case 3: {
                holder.progressBar.setVisibility(0);
                holder.tvSize.setVisibility(8);
                holder.progressBar.setProgress(downloadMediaInfo.getProgress());
                holder.ivDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_download_video));
                holder.ivPreView.setVisibility(8);
                holder.ivDownload.setVisibility(0);
                holder.cacheLinearLayout.setVisibility(0);
                holder.tvTitle.setVisibility(4);
                holder.mTvDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.alivc_player_cache_ing));
                break;
            }
            case 4: {
                holder.progressBar.setVisibility(0);
                holder.tvSize.setVisibility(8);
                holder.progressBar.setProgress(downloadMediaInfo.getProgress());
                holder.ivDownload.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_download_video));
                holder.ivPreView.setVisibility(8);
                holder.ivDownload.setVisibility(0);
                holder.cacheLinearLayout.setVisibility(0);
                holder.tvTitle.setVisibility(4);
                holder.mTvDownload.setText(R.string.alivc_player_cache_stop);
                break;
            }
            case 5: {
                holder.progressBar.setVisibility(8);
                holder.tvSize.setVisibility(0);
                holder.ivPreView.setVisibility(0);
                holder.ivDownload.setVisibility(8);
                holder.cacheLinearLayout.setVisibility(8);
                holder.tvTitle.setVisibility(0);
                break;
            }
            case 6: {
                holder.progressBar.setVisibility(0);
                holder.ivPreView.setVisibility(8);
                holder.ivDownload.setVisibility(0);
                holder.cacheLinearLayout.setVisibility(0);
                holder.tvTitle.setVisibility(4);
                holder.tvSubTitle.setVisibility(0);
                holder.tvSize.setVisibility(8);
                holder.mTvDownload.setText((CharSequence)this.mContext.getResources().getString(R.string.alivc_player_cache_fail));
                break;
            }
            case 8: {
                break;
            }
        }
        if (TextUtils.isEmpty((CharSequence)downloadMediaInfo.getTvId())) {
            holder.tvSize.setText((CharSequence)Formatter.getFileSizeDescription((long)downloadMediaInfo.getSize()));
            holder.tvTitle.setText((CharSequence)downloadMediaInfo.getTitle());
            holder.tvSubTitle.setText((CharSequence)downloadMediaInfo.getTitle());
            if (downloadMediaInfo.getWatched() == 0) {
                // empty if block
            }
            new ImageLoaderImpl().loadImage(this.mContext, downloadMediaInfo.getCoverUrl(), new ImageLoaderOptions.Builder().crossFade().error(R.mipmap.ic_launcher).build()).into(holder.ivPreView);
        } else {
            String tvName;
            holder.progressBar.setVisibility(8);
            holder.ivPreView.setVisibility(0);
            holder.ivDownload.setVisibility(8);
            holder.cacheLinearLayout.setVisibility(8);
            holder.tvTitle.setVisibility(0);
            holder.tvSize.setText((CharSequence)Formatter.getFileSizeDescription((long)downloadMediaInfo.getSize()));
            if (downloadMediaInfo.getWatchNumber() == 0) {
                // empty if block
            }
            if (TextUtils.isEmpty((CharSequence)(tvName = downloadMediaInfo.getTvName()))) {
                tvName = downloadMediaInfo.getTitle();
            }
            holder.tvTitle.setText((CharSequence)tvName);
            new ImageLoaderImpl().loadImage(this.mContext, downloadMediaInfo.getTvCoverUrl(), new ImageLoaderOptions.Builder().crossFade().error(R.mipmap.ic_launcher).build()).into(holder.ivPreView);
        }
        if (this.mIsEditing) {
            holder.ivSelector.setVisibility(0);
        } else {
            holder.ivSelector.setVisibility(8);
        }
        if (downloadMediaInfo.isSelected()) {
            holder.ivSelector.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_cachevideo_selected));
        } else {
            holder.ivSelector.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.alivc_player_cachevideo_un_selected));
        }
    }

    public int getItemCount() {
        return this.mMediaInfos == null ? 0 : this.mMediaInfos.size();
    }

    public void updateData(AliyunDownloadMediaInfo mediaInfo) {
        int index = this.mMediaInfos.indexOf(mediaInfo);
        if (index >= 0 && index < this.mMediaInfos.size()) {
            if (mediaInfo.getProgress() == 100) {
                this.mMediaInfos.get(index).setStatus(AliyunDownloadMediaInfo.Status.Complete);
            } else {
                this.mMediaInfos.get(index).setStatus(mediaInfo.getStatus());
            }
            this.mMediaInfos.get(index).setProgress(mediaInfo.getProgress());
            this.notifyItemChanged(index, mediaInfo);
        }
    }

    public void deleteData(AliyunDownloadMediaInfo info) {
        int index = this.mMediaInfos.indexOf(info);
        if (index >= 0 && index < this.mMediaInfos.size()) {
            this.mMediaInfos.remove(index);
            this.notifyDataSetChanged();
        }
    }

    public void setData(List<AliyunDownloadMediaInfo> mediaInfo) {
        if (this.mMediaInfos != null) {
            this.mMediaInfos.clear();
            this.mMediaInfos.addAll(mediaInfo);
        }
        this.notifyDataSetChanged();
    }

    public List<AliyunDownloadMediaInfo> getDatas() {
        return this.mMediaInfos;
    }

    public void setEditing(boolean isEditing) {
        this.mIsEditing = isEditing;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemChildClickListener(OnItemChildClickListener listener) {
        this.mOnItemChildClickListener = listener;
    }

    public static interface OnItemChildClickListener {
        public void onItemChildClick(AliyunPlayerDownloadListAdapter var1, View var2, int var3);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AliyunPlayerDownloadListAdapter var1, View var2, int var3);
    }

    public static class PlayerDownloadListViewHolder
    extends RecyclerView.ViewHolder {
        public TextView tvSize;
        public TextView tvTitle;
        public ProgressBar progressBar;
        public ImageView ivPreView;
        public ImageView ivSelector;
        public ImageView ivDownload;
        public LinearLayout cacheLinearLayout;
        public TextView tvSubTitle;
        public FrameLayout mFlFont;
        public TextView mTvDownload;

        public PlayerDownloadListViewHolder(View itemView) {
            super(itemView);
            this.tvSize = (TextView)itemView.findViewById(R.id.alivc_tv_size);
            this.tvTitle = (TextView)itemView.findViewById(R.id.alivc_tv_title);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.alivc_progress_bar_healthy);
            this.ivPreView = (ImageView)itemView.findViewById(R.id.alivc_iv_preview);
            this.ivSelector = (ImageView)itemView.findViewById(R.id.alivc_iv_selector);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.alivc_iv_download);
            this.cacheLinearLayout = (LinearLayout)itemView.findViewById(R.id.alivc_ll_cache);
            this.tvSubTitle = (TextView)itemView.findViewById(R.id.alivc_tv_sub_title);
            this.mFlFont = (FrameLayout)itemView.findViewById(R.id.alivc_fl_font);
            this.mTvDownload = (TextView)itemView.findViewById(R.id.alivc_iv_loading);
        }
    }
}

