/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetWatchdogUtils {
    private Context mContext;
    private NetChangeListener mNetChangeListener;
    private IntentFilter mNetIntentFilter = new IntentFilter();
    private boolean isReconnect;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return;
            }
            NetworkInfo wifiNetworkInfo = cm.getNetworkInfo(1);
            NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
            NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
            NetworkInfo.State wifiState = NetworkInfo.State.UNKNOWN;
            NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
            if (wifiNetworkInfo != null) {
                wifiState = wifiNetworkInfo.getState();
            }
            if (mobileNetworkInfo != null) {
                mobileState = mobileNetworkInfo.getState();
            }
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                if (NetWatchdogUtils.this.mNetChangeListener != null) {
                    NetWatchdogUtils.this.mNetChangeListener.onReNetConnected(NetWatchdogUtils.this.isReconnect);
                    NetWatchdogUtils.this.isReconnect = false;
                }
            } else if (activeNetworkInfo == null && NetWatchdogUtils.this.mNetChangeListener != null) {
                NetWatchdogUtils.this.isReconnect = true;
                NetWatchdogUtils.this.mNetChangeListener.onNetUnConnected();
            }
            if (NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED == mobileState) {
                if (NetWatchdogUtils.this.mNetChangeListener != null) {
                    NetWatchdogUtils.this.mNetChangeListener.onWifiTo4G();
                }
            } else if (NetworkInfo.State.CONNECTED == wifiState && NetworkInfo.State.CONNECTED != mobileState) {
                if (NetWatchdogUtils.this.mNetChangeListener != null) {
                    NetWatchdogUtils.this.mNetChangeListener.on4GToWifi();
                }
            } else if (NetworkInfo.State.CONNECTED != wifiState && NetWatchdogUtils.this.mNetChangeListener != null) {
                NetWatchdogUtils.this.mNetChangeListener.onNetUnConnected();
            }
        }
    };

    public NetWatchdogUtils(Context context) {
        this.mContext = context.getApplicationContext();
        this.mNetIntentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
    }

    public void setNetChangeListener(NetChangeListener l) {
        this.mNetChangeListener = l;
    }

    public void startWatch() {
        try {
            this.mContext.registerReceiver(this.mReceiver, this.mNetIntentFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopWatch() {
        try {
            this.mContext.unregisterReceiver(this.mReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasNet(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo wifiNetworkInfo = cm.getNetworkInfo(1);
        NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
        NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
        NetworkInfo.State wifiState = NetworkInfo.State.UNKNOWN;
        NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
        if (wifiNetworkInfo != null) {
            wifiState = wifiNetworkInfo.getState();
        }
        if (mobileNetworkInfo != null) {
            mobileState = mobileNetworkInfo.getState();
        }
        if (NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED != mobileState) {
            return false;
        }
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    public static boolean is4GConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (cm == null) {
            return false;
        }
        NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
        NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
        if (mobileNetworkInfo != null) {
            mobileState = mobileNetworkInfo.getState();
        }
        return NetworkInfo.State.CONNECTED == mobileState;
    }

    public static interface NetChangeListener {
        public void onWifiTo4G();

        public void on4GToWifi();

        public void onReNetConnected(boolean var1);

        public void onNetUnConnected();
    }
}

