/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.content.Context;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NotchScreenUtil {
    private static final String TAG = NotchScreenUtil.class.getName();
    private static final int FLAG_NOTCH_SUPPORT_HW = 65536;
    private static final int FLAG_NOTCH_SUPPORT_VIVO = 32;

    public static boolean checkNotchScreen(Context context) {
        if (NotchScreenUtil.checkHuaWei(context)) {
            return true;
        }
        if (NotchScreenUtil.checkVivo(context)) {
            return true;
        }
        if (NotchScreenUtil.checkMiUI(context)) {
            return true;
        }
        return NotchScreenUtil.checkOppo(context);
    }

    private static boolean checkOppo(Context context) {
        try {
            return context.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"checkOppo notchScreen exception");
            return false;
        }
    }

    private static boolean checkMiUI(Context context) {
        int result = 0;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> systemProperties = classLoader.loadClass("android.os.SystemProperties");
            Class[] paramTypes = new Class[]{String.class, Integer.TYPE};
            Method getInt = systemProperties.getMethod("getInt", paramTypes);
            Object[] params = new Object[]{"ro.miui.notch", 0};
            result = (Integer)getInt.invoke(systemProperties, params);
            return result == 1;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean checkHuaWei(Context context) {
        boolean ret = false;
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> hwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = hwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            ret = (Boolean)get.invoke(hwNotchSizeUtil, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"hasNotchInScreen ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hasNotchInScreen NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"hasNotchInScreen Exception");
        }
        return ret;
    }

    private static boolean checkVivo(Context context) {
        boolean ret;
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> ftFeature = cl.loadClass("android.util.FtFeature");
            Method isFeatureSupport = ftFeature.getMethod("isFeatureSupport", new Class[0]);
            ret = (Boolean)isFeatureSupport.invoke(ftFeature, 32);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = false;
        }
        return ret;
    }

    public static int[] getNotchSize(Context context) {
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> hwnotchsizeutil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = hwnotchsizeutil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(hwnotchsizeutil, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"test", (String)"getNotchSize ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)"test", (String)"getNotchSize NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)"test", (String)"getNotchSize Exception");
        }
        return ret;
    }

    public static void setFullScreenWindowLayoutInDisplayCutout(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"hw add notch screen flag api error");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hw add notch screen flag api error");
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"hw add notch screen flag api error");
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"hw add notch screen flag api error");
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"hw add notch screen flag api error");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"other Exception");
        }
    }

    public static void setNotFullScreenWindowLayoutInDisplayCutout(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("clearHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
            Log.e((String)TAG, (String)"............clear");
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"hw clear notch screen flag api error");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"hw clear notch screen flag api error");
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"hw clear notch screen flag api error");
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"hw clear notch screen flag api error");
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"hw clear notch screen flag api error");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"other Exception");
        }
    }
}

