/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.utils.ToastUtils;

public class PermissionUtils {
    private static final String TAG = PermissionUtils.class.getName();
    public static final String[] PERMISSION_MANIFEST = new String[]{"android.permission.CAMERA", "android.permission.BLUETOOTH", "android.permission.RECORD_AUDIO", "android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
    public static final String[] PERMISSION_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] PERMISSION_CAMERA = new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final int[] NO_PERMISSION_TIP = new int[]{R.string.alivc_common_no_camera_permission, R.string.alivc_common_no_record_bluetooth_permission, R.string.alivc_common_no_record_audio_permission, R.string.alivc_common_no_read_phone_state_permission, R.string.alivc_common_no_write_external_storage_permission, R.string.alivc_common_no_read_external_storage_permission};

    public static boolean checkPermissionsGroup(Context context, String[] permissions) {
        for (String permission2 : permissions) {
            if (PermissionUtils.checkPermission(context, permission2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermission(Context context, String permission2) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    public static void requestPermissions(Activity activity, String[] permissions, int requestCode) {
        if (!PermissionUtils.checkPermissionsGroup((Context)activity, permissions)) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)requestCode);
        }
    }

    @RequiresApi(api=19)
    public static boolean checkXiaomi(Context context, String[] opstrArrays) {
        AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
        String packageName = context.getPackageName();
        for (String opstr : opstrArrays) {
            int locationOp = appOpsManager.checkOp(opstr, Binder.getCallingUid(), packageName);
            if (locationOp != 1) continue;
            return false;
        }
        return true;
    }

    public static void showNoPermissionTip(Context context, String tip) {
        ToastUtils.show(context, tip, 1);
    }
}

