/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.widget.Toast;
import java.lang.reflect.Field;

public class ToastUtils {
    private static Toast mToast;
    private static Field mFieldTN;
    private static Field mFieldTNHandler;

    @SuppressLint(value={"ShowToast"})
    private static Toast initToast(Context context) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context.getApplicationContext(), (CharSequence)"", (int)0);
            if (Build.VERSION.SDK_INT == 25) {
                ToastUtils.hook(mToast);
            }
        }
        return mToast;
    }

    public static void showInCenter(Context context, String content) {
        Toast toast = ToastUtils.initToast(context);
        toast.setText((CharSequence)content);
        toast.setDuration(0);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    public static void show(Context context, String message) {
        ToastUtils.show(context, message, 0);
    }

    public static void show(Context context, int stringId) {
        ToastUtils.show(context, stringId, 0);
    }

    public static void show(Context context, String message, int duration) {
        Toast toast = ToastUtils.initToast(context);
        toast.setDuration(duration);
        toast.setText((CharSequence)message);
        mToast.show();
    }

    public static void show(Context context, int stringId, int duration) {
        Toast toast = ToastUtils.initToast(context);
        toast.setDuration(duration);
        toast.setText(stringId);
        mToast.show();
    }

    public static void show(Context context, String message, int gravity, int duration) {
        Toast toast = ToastUtils.initToast(context);
        toast.setDuration(duration);
        toast.setText((CharSequence)message);
        toast.setGravity(gravity, 0, 0);
        mToast.show();
    }

    private static void hook(Toast toast) {
        try {
            Object tn = mFieldTN.get(toast);
            Handler preHandler = (Handler)mFieldTNHandler.get(tn);
            mFieldTNHandler.set(tn, (Object)new FiexHandler(preHandler));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Build.VERSION.SDK_INT == 25) {
            try {
                mFieldTN = Toast.class.getDeclaredField("mTN");
                mFieldTN.setAccessible(true);
                mFieldTNHandler = mFieldTN.getType().getDeclaredField("mHandler");
                mFieldTNHandler.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class FiexHandler
    extends Handler {
        private Handler impl;

        FiexHandler(Handler impl) {
            this.impl = impl;
        }

        public void dispatchMessage(Message msg) {
            try {
                super.dispatchMessage(msg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void handleMessage(Message msg) {
            this.impl.handleMessage(msg);
        }
    }
}

