/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.aliyun.svideo.common.R;

public class AlivcCustomAlertDialog
extends Dialog {
    private ImageView ivDialogIcon;
    private TextView tvDialogMessage;
    private TextView tvCancel;
    private TextView tvConfirm;
    private OnDialogClickListener mDialogClickListener;

    public AlivcCustomAlertDialog(@NonNull Context context) {
        this(context, R.style.TipDialog);
    }

    public AlivcCustomAlertDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    protected AlivcCustomAlertDialog(@NonNull Context context, boolean cancelable, @Nullable DialogInterface.OnCancelListener cancelListener) {
        super(context, cancelable, cancelListener);
    }

    private void initView() {
        this.ivDialogIcon = (ImageView)this.findViewById(R.id.iv_dialog_icon);
        this.tvDialogMessage = (TextView)this.findViewById(R.id.tv_dialog_message);
        this.tvCancel = (TextView)this.findViewById(R.id.tv_cancel);
        this.tvConfirm = (TextView)this.findViewById(R.id.tv_confirm);
        this.tvConfirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlivcCustomAlertDialog.this.dismiss();
                if (AlivcCustomAlertDialog.this.mDialogClickListener != null) {
                    AlivcCustomAlertDialog.this.mDialogClickListener.onConfirm();
                }
            }
        });
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlivcCustomAlertDialog.this.dismiss();
                if (AlivcCustomAlertDialog.this.mDialogClickListener != null) {
                    AlivcCustomAlertDialog.this.mDialogClickListener.onCancel();
                }
            }
        });
    }

    private void setDialogType(CustomDialogType customDialogType) {
        if (customDialogType == CustomDialogType.Confirm) {
            this.tvCancel.setVisibility(8);
        } else {
            this.tvCancel.setVisibility(0);
        }
    }

    public static enum CustomDialogType {
        Alert,
        Confirm;

    }

    public static class Builder {
        private Context mContext;
        private int iconId = R.mipmap.icon_delete_tips;
        private String message;
        private String confirm;
        private String cancel;
        private OnDialogClickListener dialogClickListener;
        private boolean noIcon = false;
        private CustomDialogType customDialogType = CustomDialogType.Alert;

        public Builder(Context mContext) {
            this.mContext = mContext;
        }

        public AlivcCustomAlertDialog create() {
            AlivcCustomAlertDialog dialog = new AlivcCustomAlertDialog(this.mContext);
            dialog.setContentView(R.layout.alivc_common_dialog_alert_custom);
            dialog.initView();
            this.message = this.mContext.getResources().getString(R.string.alivc_common_note);
            this.confirm = this.mContext.getResources().getString(R.string.alivc_common_confirm);
            this.cancel = this.mContext.getResources().getString(R.string.alivc_common_cancel);
            dialog.tvDialogMessage.setText((CharSequence)this.message);
            dialog.tvCancel.setText((CharSequence)this.cancel);
            dialog.tvConfirm.setText((CharSequence)this.confirm);
            dialog.mDialogClickListener = this.dialogClickListener;
            dialog.setDialogType(this.customDialogType);
            ViewGroup contentWrap = (ViewGroup)dialog.findViewById(R.id.contentWrap);
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)contentWrap.getLayoutParams();
            params.width = this.mContext.getResources().getDimensionPixelSize(R.dimen.alivc_common_alert_dialog_w);
            if (this.noIcon) {
                dialog.ivDialogIcon.setVisibility(8);
                params.height = this.mContext.getResources().getDimensionPixelSize(R.dimen.alivc_common_alert_dialog_h_no_icon);
            } else {
                dialog.ivDialogIcon.setVisibility(0);
                dialog.ivDialogIcon.setImageResource(this.iconId);
                params.height = this.mContext.getResources().getDimensionPixelSize(R.dimen.alivc_common_alert_dialog_h);
            }
            contentWrap.setLayoutParams((ViewGroup.LayoutParams)params);
            return dialog;
        }

        public Builder setIconId(int id2) {
            this.iconId = id2;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setNoIcon(boolean noIcon) {
            this.noIcon = noIcon;
            return this;
        }

        public Builder setDialogClickListener(String confirm, String cancel, OnDialogClickListener clickListener) {
            if (!TextUtils.isEmpty((CharSequence)confirm)) {
                this.confirm = confirm;
            }
            if (!TextUtils.isEmpty((CharSequence)cancel)) {
                this.cancel = cancel;
            }
            this.dialogClickListener = clickListener;
            return this;
        }

        public Builder setCustomDialogType(CustomDialogType customDialogType) {
            this.customDialogType = customDialogType;
            return this;
        }
    }

    public static interface OnDialogClickListener {
        public void onConfirm();

        public void onCancel();
    }
}

