/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.aliyun.svideo.common.R;

public class CustomProgressDialog
extends Dialog {
    private Context context;
    private TextView mTitle;
    private TextView mMessage;
    private TextView mProgress;
    private ProgressBar mProgressBar;
    private String mStringTitle;
    private String mStringMessage;
    private int mCurrentProgress;
    private int mMaxProgress;

    public CustomProgressDialog(Context context, String title, String message) {
        super(context, R.style.CustomDialogStyle);
        this.context = context;
        this.mStringTitle = title;
        this.mStringMessage = message;
    }

    public CustomProgressDialog(Context context) {
        this(context, "", "");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View view = inflater.inflate(R.layout.alivc_common_dialog_progress, null, false);
        this.mTitle = (TextView)view.findViewById(R.id.tv_dialog_title);
        this.mMessage = (TextView)view.findViewById(R.id.tv_dialog_message);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.pb_dialog_progress);
        this.mProgress = (TextView)view.findViewById(R.id.tv_dialog_progress);
        if (this.mStringTitle != null) {
            this.mTitle.setText((CharSequence)this.mStringTitle);
        }
        if (this.mStringMessage != null) {
            this.mMessage.setText((CharSequence)this.mStringMessage);
        }
        if (this.mCurrentProgress != 0) {
            this.mProgressBar.setProgress(this.mCurrentProgress);
        }
        if (this.mMaxProgress != 0) {
            this.mProgressBar.setMax(this.mMaxProgress);
        } else {
            this.mProgressBar.setMax(100);
        }
        this.setProgress(this.mCurrentProgress);
        this.setContentView(view);
        Window dialogWindow = this.getWindow();
        WindowManager.LayoutParams lp = dialogWindow.getAttributes();
        DisplayMetrics d = this.context.getResources().getDisplayMetrics();
        lp.width = d.widthPixels;
        lp.height = d.heightPixels;
        lp.gravity = 49;
        dialogWindow.setAttributes(lp);
    }

    public void setTitle(String stringTitle) {
        this.mStringTitle = stringTitle;
        if (this.mTitle != null) {
            this.mTitle.setText((CharSequence)this.mStringTitle);
        }
    }

    public void setMessage(String stringMessage) {
        this.mStringMessage = stringMessage;
        if (this.mMessage != null) {
            this.mMessage.setText((CharSequence)this.mStringMessage);
        }
    }

    public void setProgress(int progress) {
        this.mCurrentProgress = progress;
        if (this.mProgressBar != null) {
            this.mProgressBar.setProgress(progress);
            this.mProgress.setText((CharSequence)(this.mCurrentProgress * 100 / this.mMaxProgress + "%"));
        }
    }

    public void setMaxProgress(int progress) {
        this.mMaxProgress = progress;
        if (this.mProgressBar != null) {
            this.mProgressBar.setMax(progress);
        }
    }

    public void show() {
        super.show();
    }

    public void dismiss() {
        super.dismiss();
    }
}

