/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.utils.FileUtils;
import com.aliyun.svideo.common.utils.PermissionUtils;

public class SdcardUtils {
    private static final String TAG = SdcardUtils.class.getSimpleName();

    public static void checkAvailableSize(Context context, int tagSize) {
        boolean isHasPermission = PermissionUtils.checkPermissionsGroup(context, PermissionUtils.PERMISSION_STORAGE);
        if (isHasPermission) {
            long availableSize = FileUtils.getSdcardAvailableSize() / 1024L / 1024L;
            Log.e((String)TAG, (String)("log_common_SdcardUtils_availableSize : " + availableSize));
            if (availableSize < (long)tagSize) {
                SdcardUtils.showAlertDialog(context);
            }
        }
    }

    private static void showAlertDialog(Context context) {
        AlertDialog.Builder alertDialog = new AlertDialog.Builder(context);
        alertDialog.setTitle((CharSequence)context.getResources().getString(R.string.alivc_common_note));
        alertDialog.setMessage((CharSequence)context.getResources().getString(R.string.alivc_common_device_memory_not_enough));
        alertDialog.setPositiveButton((CharSequence)context.getResources().getString(R.string.alivc_common_confirm), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        alertDialog.setCancelable(false);
        alertDialog.show();
    }
}

