/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.base;

import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.base.BaseDialogFragment;
import com.aliyun.svideo.common.baseAdapter.BaseQuickAdapter;
import com.aliyun.svideo.common.baseAdapter.BaseViewHolder;
import java.util.ArrayList;
import java.util.List;

public class AlivcListSelectorDialogFragment
extends BaseDialogFragment {
    public static final String TAG = AlivcListSelectorDialogFragment.class.getSimpleName();
    public FragmentManager mFragmentManager;
    public int mWidth;
    public int mHeight;
    public float mDimAmount = 0.2f;
    public int mGravity = 80;
    public String mTag = TAG;
    public List<String> mLists;
    public boolean mIsCancelableOutside = true;
    public int mDialogAnimationRes = 0;
    private SelectorQuickAdapter mSelectorQuickAdapter;
    private int mItemSelectedColor;
    private int mItemUnSelectedColor;
    public String mPosition;
    public TextView mTvCancel;
    public DialogInterface.OnKeyListener mKeyListener;
    private OnListItemSelectedListener mOnListItemSelectedListener;
    private DialogInterface.OnDismissListener onDismissListener;

    public void setPosition(String position) {
        this.mPosition = position;
    }

    public void setOnListSelectedListener(OnListItemSelectedListener onListItemSelectedListener) {
        this.mOnListItemSelectedListener = onListItemSelectedListener;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(dialog);
        }
    }

    @Override
    protected int getLayoutRes() {
        return R.layout.alivc_common_dialogfragment_selector;
    }

    @Override
    protected void bindView(View view) {
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.alivc_common_dialog_recyclerview);
        this.mTvCancel = (TextView)view.findViewById(R.id.alivc_tv_cancel);
        this.mTvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AlivcListSelectorDialogFragment.this.dismiss();
            }
        });
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.getActivity(), 1, false);
        this.mSelectorQuickAdapter = new SelectorQuickAdapter(R.layout.alivc_common_dialog_rv_selector_item, null);
        recyclerView.setAdapter((RecyclerView.Adapter)this.mSelectorQuickAdapter);
        DividerItemDecoration itemDecoration = new DividerItemDecoration((Context)this.getActivity(), 1);
        itemDecoration.setDrawable(ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.alivc_common_rv_divider_gray_vertical));
        recyclerView.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.initData();
    }

    private void initData() {
        if (this.mLists != null) {
            this.mSelectorQuickAdapter.setNewData(this.mLists);
            this.mSelectorQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                    if (AlivcListSelectorDialogFragment.this.mOnListItemSelectedListener != null) {
                        AlivcListSelectorDialogFragment.this.mOnListItemSelectedListener.onClick(adapter.getData().get(position).toString());
                        AlivcListSelectorDialogFragment.this.dismiss();
                    }
                }
            });
        }
        if (this.mPosition != null) {
            this.mSelectorQuickAdapter.setSelectedPosition(this.mPosition);
        }
    }

    public AlivcListSelectorDialogFragment show() {
        Log.d((String)"Dialog", (String)"show");
        try {
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.remove((Fragment)this);
            ft.add((Fragment)this, this.tag);
            ft.commitAllowingStateLoss();
        }
        catch (Exception e) {
            Log.e((String)"Dialog", (String)e.toString());
        }
        return this;
    }

    @Override
    protected DialogInterface.OnKeyListener getOnKeyListener() {
        return this.mKeyListener;
    }

    @Override
    public int getGravity() {
        return this.mGravity;
    }

    @Override
    public int getDialogHeight() {
        return this.mHeight;
    }

    @Override
    public int getDialogWidth() {
        return this.mWidth;
    }

    @Override
    public float getDimAmount() {
        return this.mDimAmount;
    }

    @Override
    public String getFragmentTag() {
        return this.mTag;
    }

    @Override
    protected boolean isCancelableOutside() {
        return this.mIsCancelableOutside;
    }

    @Override
    protected int getDialogAnimationRes() {
        return this.mDialogAnimationRes;
    }

    public class SelectorQuickAdapter
    extends BaseQuickAdapter<String, BaseViewHolder> {
        private String mPosition;

        public void setSelectedPosition(String position) {
            this.mPosition = position;
        }

        public SelectorQuickAdapter(@Nullable int layoutResId, List<String> data) {
            super(layoutResId, data);
        }

        @Override
        protected void convert(BaseViewHolder helper, String item) {
            TextView tvName = (TextView)helper.getView(R.id.alivc_tv_name);
            tvName.setText((CharSequence)item);
            if (this.mPosition != null && this.mPosition.equals(item)) {
                tvName.setTextColor(AlivcListSelectorDialogFragment.this.mItemSelectedColor);
            } else {
                tvName.setTextColor(AlivcListSelectorDialogFragment.this.mItemUnSelectedColor);
            }
        }
    }

    public static class Builder {
        private AlivcListSelectorDialogFragment params = new AlivcListSelectorDialogFragment();

        public Builder(FragmentManager fragmentManager) {
            this.params.mFragmentManager = fragmentManager;
        }

        public Builder setWidth(int widthPx) {
            this.params.mWidth = widthPx;
            return this;
        }

        public Builder setHeight(int heightPx) {
            this.params.mHeight = heightPx;
            return this;
        }

        public Builder setScreenWidthAspect(Context context, float widthAspect) {
            this.params.mWidth = (int)((float)BaseDialogFragment.getScreenWidth(context) * widthAspect);
            return this;
        }

        public Builder setScreenHeightAspect(Context context, float heightAspect) {
            this.params.mHeight = (int)((float)BaseDialogFragment.getScreenHeight(context) * heightAspect);
            return this;
        }

        public Builder setGravity(int gravity) {
            this.params.mGravity = gravity;
            return this;
        }

        public Builder setCancelableOutside(boolean cancel) {
            this.params.mIsCancelableOutside = cancel;
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener dismissListener) {
            this.params.onDismissListener = dismissListener;
            return this;
        }

        public Builder setDimAmount(float dim) {
            this.params.mDimAmount = dim;
            return this;
        }

        public Builder setTag(String tag) {
            this.params.mTag = tag;
            return this;
        }

        public Builder setOnListItemSelectedListener(OnListItemSelectedListener listener) {
            this.params.mOnListItemSelectedListener = listener;
            return this;
        }

        public Builder setDialogAnimationRes(int animationRes) {
            this.params.mDialogAnimationRes = animationRes;
            return this;
        }

        public Builder setNewData(ArrayList<String> lists) {
            this.params.mLists = lists;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener keyListener) {
            this.params.mKeyListener = keyListener;
            return this;
        }

        public Builder setItemColor(int selectedColor) {
            this.params.mItemSelectedColor = selectedColor;
            return this;
        }

        public Builder setUnItemColor(int selectedUnColor) {
            this.params.mItemUnSelectedColor = selectedUnColor;
            return this;
        }

        public AlivcListSelectorDialogFragment create() {
            return this.params;
        }
    }

    public static interface OnListItemSelectedListener {
        public void onClick(String var1);
    }
}

