/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import com.aliyun.svideo.common.R;

public class SwitchButton
extends View {
    private static final int STATE_SWITCH_ON = 4;
    private static final int STATE_SWITCH_ON2 = 3;
    private static final int STATE_SWITCH_OFF2 = 2;
    private static final int STATE_SWITCH_OFF = 1;
    private final AccelerateInterpolator interpolator = new AccelerateInterpolator(2.0f);
    private final Paint paint = new Paint();
    private final Path sPath = new Path();
    private final Path bPath = new Path();
    private final RectF bRectF = new RectF();
    private float sAnim;
    private float bAnim;
    private RadialGradient shadowGradient;
    protected float ratioAspect = 0.68f;
    protected float animationSpeed = 0.1f;
    private int state;
    private int lastState;
    private boolean isCanVisibleDrawing = false;
    private View.OnClickListener mOnClickListener;
    protected int colorPrimary;
    protected int colorPrimaryDark;
    protected int colorOff;
    protected int colorOffDark;
    protected int colorShadow;
    protected boolean hasShadow;
    protected boolean isOpened;
    private float sRight;
    private float sCenterX;
    private float sCenterY;
    private float sScale;
    private float bOffset;
    private float bRadius;
    private float bStrokeWidth;
    private float bWidth;
    private float bLeft;
    private float bRight;
    private float bOnLeftX;
    private float bOn2LeftX;
    private float bOff2LeftX;
    private float bOffLeftX;
    private float shadowReservedHeight;
    private OnStateChangedListener listener = new OnStateChangedListener(){

        @Override
        public void toggleToOn(SwitchButton view) {
            SwitchButton.this.toggleSwitch(true);
        }

        @Override
        public void toggleToOff(SwitchButton view) {
            SwitchButton.this.toggleSwitch(false);
        }
    };

    public SwitchButton(Context context) {
        this(context, null);
    }

    @TargetApi(value=11)
    public SwitchButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
        int DEFAULT_COLOR_PRIMARY = -11806877;
        int DEFAULT_COLOR_PRIMARY_DARK = -12925358;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        this.colorPrimary = a.getColor(R.styleable.SwitchButton_primaryColor, -11806877);
        this.colorPrimaryDark = a.getColor(R.styleable.SwitchButton_primaryColorDark, -12925358);
        this.colorOff = a.getColor(R.styleable.SwitchButton_offColor, -1842205);
        this.colorOffDark = a.getColor(R.styleable.SwitchButton_offColorDark, -4210753);
        this.colorShadow = a.getColor(R.styleable.SwitchButton_shadowColor, -13421773);
        this.ratioAspect = a.getFloat(R.styleable.SwitchButton_ratioAspect, 0.68f);
        this.hasShadow = a.getBoolean(R.styleable.SwitchButton_hasShadow, true);
        this.isOpened = a.getBoolean(R.styleable.SwitchButton_isOpened, false);
        this.lastState = this.state = this.isOpened ? 4 : 1;
        a.recycle();
        if (this.colorPrimary == -11806877 && this.colorPrimaryDark == -12925358) {
            try {
                if (Build.VERSION.SDK_INT >= 21) {
                    TypedValue primaryColorTypedValue = new TypedValue();
                    context.getTheme().resolveAttribute(16843827, primaryColorTypedValue, true);
                    if (primaryColorTypedValue.data > 0) {
                        this.colorPrimary = primaryColorTypedValue.data;
                    }
                    TypedValue primaryColorDarkTypedValue = new TypedValue();
                    context.getTheme().resolveAttribute(16843828, primaryColorDarkTypedValue, true);
                    if (primaryColorDarkTypedValue.data > 0) {
                        this.colorPrimaryDark = primaryColorDarkTypedValue.data;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark) {
        this.setColor(newColorPrimary, newColorPrimaryDark, this.colorOff, this.colorOffDark);
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark, int newColorOff, int newColorOffDark) {
        this.setColor(newColorPrimary, newColorPrimaryDark, newColorOff, newColorOffDark, this.colorShadow);
    }

    public void setColor(int newColorPrimary, int newColorPrimaryDark, int newColorOff, int newColorOffDark, int newColorShadow) {
        this.colorPrimary = newColorPrimary;
        this.colorPrimaryDark = newColorPrimaryDark;
        this.colorOff = newColorOff;
        this.colorOffDark = newColorOffDark;
        this.colorShadow = newColorShadow;
        this.invalidate();
    }

    public void setShadow(boolean shadow) {
        this.hasShadow = shadow;
        this.invalidate();
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public void setOpened(boolean isOpened) {
        int wishState;
        int n = wishState = isOpened ? 4 : 1;
        if (wishState == this.state) {
            return;
        }
        this.refreshState(wishState);
    }

    public void toggleSwitch(boolean isOpened) {
        int wishState;
        int n = wishState = isOpened ? 4 : 1;
        if (wishState == this.state) {
            return;
        }
        if (wishState == 4 && (this.state == 1 || this.state == 2) || wishState == 1 && (this.state == 4 || this.state == 3)) {
            this.sAnim = 1.0f;
        }
        this.bAnim = 1.0f;
        this.refreshState(wishState);
    }

    private void refreshState(int newState) {
        if (!this.isOpened && newState == 4) {
            this.isOpened = true;
        } else if (this.isOpened && newState == 1) {
            this.isOpened = false;
        }
        this.lastState = this.state;
        this.state = newState;
        this.postInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int resultHeight;
        int resultWidth;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthMode == 0x40000000) {
            resultWidth = widthSize;
        } else {
            resultWidth = (int)(56.0f * this.getResources().getDisplayMetrics().density + 0.5f) + this.getPaddingLeft() + this.getPaddingRight();
            if (widthMode == Integer.MIN_VALUE) {
                resultWidth = Math.min(resultWidth, widthSize);
            }
        }
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (heightMode == 0x40000000) {
            resultHeight = heightSize;
        } else {
            resultHeight = (int)((float)resultWidth * this.ratioAspect) + this.getPaddingTop() + this.getPaddingBottom();
            if (heightMode == Integer.MIN_VALUE) {
                resultHeight = Math.min(resultHeight, heightSize);
            }
        }
        this.setMeasuredDimension(resultWidth, resultHeight);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        boolean bl = this.isCanVisibleDrawing = w > this.getPaddingLeft() + this.getPaddingRight() && h > this.getPaddingTop() + this.getPaddingBottom();
        if (this.isCanVisibleDrawing) {
            int actuallyDrawingAreaBottom;
            int actuallyDrawingAreaTop;
            int actuallyDrawingAreaRight;
            int actuallyDrawingAreaLeft;
            int actuallyDrawingAreaHeight;
            int actuallyDrawingAreaWidth = w - this.getPaddingLeft() - this.getPaddingRight();
            if ((float)actuallyDrawingAreaWidth * this.ratioAspect < (float)(actuallyDrawingAreaHeight = h - this.getPaddingTop() - this.getPaddingBottom())) {
                actuallyDrawingAreaLeft = this.getPaddingLeft();
                actuallyDrawingAreaRight = w - this.getPaddingRight();
                int heightExtraSize = (int)((float)actuallyDrawingAreaHeight - (float)actuallyDrawingAreaWidth * this.ratioAspect);
                actuallyDrawingAreaTop = this.getPaddingTop() + heightExtraSize / 2;
                actuallyDrawingAreaBottom = this.getHeight() - this.getPaddingBottom() - heightExtraSize / 2;
            } else {
                int widthExtraSize = (int)((float)actuallyDrawingAreaWidth - (float)actuallyDrawingAreaHeight / this.ratioAspect);
                actuallyDrawingAreaLeft = this.getPaddingLeft() + widthExtraSize / 2;
                actuallyDrawingAreaRight = this.getWidth() - this.getPaddingRight() - widthExtraSize / 2;
                actuallyDrawingAreaTop = this.getPaddingTop();
                actuallyDrawingAreaBottom = this.getHeight() - this.getPaddingBottom();
            }
            this.shadowReservedHeight = (int)((float)(actuallyDrawingAreaBottom - actuallyDrawingAreaTop) * 0.07f);
            float sLeft = actuallyDrawingAreaLeft;
            float sTop = (float)actuallyDrawingAreaTop + this.shadowReservedHeight;
            this.sRight = actuallyDrawingAreaRight;
            float sBottom = (float)actuallyDrawingAreaBottom - this.shadowReservedHeight;
            float sHeight = sBottom - sTop;
            this.sCenterX = (this.sRight + sLeft) / 2.0f;
            this.sCenterY = (sBottom + sTop) / 2.0f;
            this.bLeft = sLeft;
            this.bWidth = sBottom - sTop;
            this.bRight = sLeft + this.bWidth;
            float halfHeightOfS = this.bWidth / 2.0f;
            this.bRadius = halfHeightOfS * 0.95f;
            this.bOffset = this.bRadius * 0.2f;
            this.bStrokeWidth = (halfHeightOfS - this.bRadius) * 2.0f;
            this.bOnLeftX = this.sRight - this.bWidth;
            this.bOn2LeftX = this.bOnLeftX - this.bOffset;
            this.bOffLeftX = sLeft;
            this.bOff2LeftX = this.bOffLeftX + this.bOffset;
            this.sScale = 1.0f - this.bStrokeWidth / sHeight;
            this.sPath.reset();
            RectF sRectF = new RectF();
            sRectF.top = sTop;
            sRectF.bottom = sBottom;
            sRectF.left = sLeft;
            sRectF.right = sLeft + sHeight;
            this.sPath.arcTo(sRectF, 90.0f, 180.0f);
            sRectF.left = this.sRight - sHeight;
            sRectF.right = this.sRight;
            this.sPath.arcTo(sRectF, 270.0f, 180.0f);
            this.sPath.close();
            this.bRectF.left = this.bLeft;
            this.bRectF.right = this.bRight;
            this.bRectF.top = sTop + this.bStrokeWidth / 2.0f;
            this.bRectF.bottom = sBottom - this.bStrokeWidth / 2.0f;
            float bCenterX = (this.bRight + this.bLeft) / 2.0f;
            float bCenterY = (sBottom + sTop) / 2.0f;
            int red = this.colorShadow >> 16 & 0xFF;
            int green = this.colorShadow >> 8 & 0xFF;
            int blue = this.colorShadow & 0xFF;
            this.shadowGradient = new RadialGradient(bCenterX, bCenterY, this.bRadius, Color.argb((int)200, (int)red, (int)green, (int)blue), Color.argb((int)25, (int)red, (int)green, (int)blue), Shader.TileMode.CLAMP);
        }
    }

    private void calcBPath(float percent) {
        this.bPath.reset();
        this.bRectF.left = this.bLeft + this.bStrokeWidth / 2.0f;
        this.bRectF.right = this.bRight - this.bStrokeWidth / 2.0f;
        this.bPath.arcTo(this.bRectF, 90.0f, 180.0f);
        this.bRectF.left = this.bLeft + percent * this.bOffset + this.bStrokeWidth / 2.0f;
        this.bRectF.right = this.bRight + percent * this.bOffset - this.bStrokeWidth / 2.0f;
        this.bPath.arcTo(this.bRectF, 270.0f, 180.0f);
        this.bPath.close();
    }

    private float calcBTranslate(float percent) {
        float result = 0.0f;
        switch (this.state - this.lastState) {
            case 1: {
                if (this.state == 2) {
                    result = this.bOffLeftX;
                    break;
                }
                if (this.state != 4) break;
                result = this.bOnLeftX - (this.bOnLeftX - this.bOn2LeftX) * percent;
                break;
            }
            case 2: {
                if (this.state == 4) {
                    result = this.bOnLeftX - (this.bOnLeftX - this.bOffLeftX) * percent;
                    break;
                }
                if (this.state != 3) break;
                result = this.bOn2LeftX - (this.bOn2LeftX - this.bOffLeftX) * percent;
                break;
            }
            case 3: {
                result = this.bOnLeftX - (this.bOnLeftX - this.bOffLeftX) * percent;
                break;
            }
            case -1: {
                if (this.state == 3) {
                    result = this.bOn2LeftX + (this.bOnLeftX - this.bOn2LeftX) * percent;
                    break;
                }
                if (this.state != 1) break;
                result = this.bOffLeftX;
                break;
            }
            case -2: {
                if (this.state == 1) {
                    result = this.bOffLeftX + (this.bOn2LeftX - this.bOffLeftX) * percent;
                    break;
                }
                if (this.state != 2) break;
                result = this.bOff2LeftX + (this.bOnLeftX - this.bOff2LeftX) * percent;
                break;
            }
            case -3: {
                result = this.bOffLeftX + (this.bOnLeftX - this.bOffLeftX) * percent;
                break;
            }
            default: {
                if (this.state == 1) {
                    result = this.bOffLeftX;
                    break;
                }
                if (this.state != 4) break;
                result = this.bOnLeftX;
            }
        }
        return result - this.bOffLeftX;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isCanVisibleDrawing) {
            return;
        }
        this.paint.setAntiAlias(true);
        boolean isOn = this.state == 4 || this.state == 3;
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(isOn ? this.colorPrimary : this.colorOff);
        canvas.drawPath(this.sPath, this.paint);
        this.sAnim = this.sAnim - this.animationSpeed > 0.0f ? this.sAnim - this.animationSpeed : 0.0f;
        this.bAnim = this.bAnim - this.animationSpeed > 0.0f ? this.bAnim - this.animationSpeed : 0.0f;
        float dsAnim = this.interpolator.getInterpolation(this.sAnim);
        float dbAnim = this.interpolator.getInterpolation(this.bAnim);
        float scale = this.sScale * (isOn ? dsAnim : 1.0f - dsAnim);
        float scaleOffset = (this.sRight - this.sCenterX - this.bRadius) * (isOn ? 1.0f - dsAnim : dsAnim);
        canvas.save();
        canvas.scale(scale, scale, this.sCenterX + scaleOffset, this.sCenterY);
        this.paint.setColor(-1);
        canvas.drawPath(this.sPath, this.paint);
        canvas.restore();
        canvas.save();
        canvas.translate(this.calcBTranslate(dbAnim), this.shadowReservedHeight);
        boolean isState2 = this.state == 3 || this.state == 2;
        this.calcBPath(isState2 ? 1.0f - dbAnim : dbAnim);
        if (this.hasShadow) {
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setShader((Shader)this.shadowGradient);
            canvas.drawPath(this.bPath, this.paint);
            this.paint.setShader(null);
        }
        canvas.translate(0.0f, -this.shadowReservedHeight);
        canvas.scale(0.98f, 0.98f, this.bWidth / 2.0f, this.bWidth / 2.0f);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(-1);
        canvas.drawPath(this.bPath, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.bStrokeWidth * 0.5f);
        this.paint.setColor(isOn ? this.colorPrimaryDark : this.colorOffDark);
        canvas.drawPath(this.bPath, this.paint);
        canvas.restore();
        this.paint.reset();
        if (this.sAnim > 0.0f || this.bAnim > 0.0f) {
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if ((this.state == 4 || this.state == 1) && this.sAnim * this.bAnim == 0.0f) {
            switch (event.getAction()) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.lastState = this.state;
                    this.bAnim = 1.0f;
                    if (this.state == 1) {
                        this.refreshState(2);
                        this.listener.toggleToOn(this);
                    } else if (this.state == 4) {
                        this.refreshState(3);
                        this.listener.toggleToOff(this);
                    }
                    if (this.mOnClickListener == null) break;
                    this.mOnClickListener.onClick((View)this);
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mOnClickListener = l;
    }

    public void setOnStateChangedListener(OnStateChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("empty listener");
        }
        this.listener = listener;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.isOpened = this.isOpened;
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.isOpened = ss.isOpened;
        this.state = this.isOpened ? 4 : 1;
        this.invalidate();
    }

    private static final class SavedState
    extends View.BaseSavedState {
        private boolean isOpened;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.isOpened = 1 == in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isOpened ? 1 : 0);
        }

        public int describeContents() {
            return 0;
        }
    }

    public static interface OnStateChangedListener {
        public void toggleToOn(SwitchButton var1);

        public void toggleToOff(SwitchButton var1);
    }
}

