/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.dot;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.aliyun.player.alivcplayerexpand.R;

public class DotView
extends RelativeLayout {
    private String mTime;
    private String mDotMsg;
    private RelativeLayout mDotViewRoot;
    private OnDotViewClickListener mOnDotViewClickListener;

    public DotView(Context context) {
        super(context);
        this.init();
    }

    public DotView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public DotView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_player_dot_view_layout, (ViewGroup)this, true);
        this.initView();
        this.initListener();
    }

    private void initListener() {
        this.mDotViewRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DotView.this.mOnDotViewClickListener != null) {
                    DotView.this.mOnDotViewClickListener.onDotViewClick();
                }
            }
        });
    }

    public void setOnDotViewClickListener(OnDotViewClickListener listener) {
        this.mOnDotViewClickListener = listener;
    }

    private void initView() {
        this.mDotViewRoot = (RelativeLayout)this.findViewById(R.id.dot_view_root);
    }

    public int getRootWidth() {
        return this.mDotViewRoot.getMeasuredWidth();
    }

    public void setDotTime(String time) {
        this.mTime = time;
    }

    public void setDotMsg(String content) {
        this.mDotMsg = content;
    }

    public String getDotTime() {
        return this.mTime;
    }

    public String getDotMsg() {
        return this.mDotMsg;
    }

    public static interface OnDotViewClickListener {
        public void onDotViewClick();
    }
}

