/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.quality;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.theme.ITheme;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.alivcplayerexpand.view.quality.QualityItem;
import com.aliyun.player.nativeclass.TrackInfo;
import java.util.LinkedList;
import java.util.List;

public class QualityView
extends FrameLayout
implements ITheme {
    private ListView mListView;
    private BaseAdapter mAdapter;
    private List<TrackInfo> mQualityItems;
    private String currentQuality;
    private OnQualityClickListener mOnQualityClickListener;
    private boolean isMtsSource = false;
    private int themeColorResId = R.color.alivc_blue;

    public QualityView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public QualityView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QualityView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_view_quality, (ViewGroup)this, true);
        this.mListView = (ListView)this.findViewById(R.id.quality_view);
        this.mListView.setChoiceMode(1);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setHorizontalScrollBarEnabled(false);
        this.mAdapter = new QualityAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                QualityView.this.hide();
                if (QualityView.this.mOnQualityClickListener != null && QualityView.this.mQualityItems != null) {
                    QualityView.this.mOnQualityClickListener.onQualityClick((TrackInfo)QualityView.this.mQualityItems.get(position));
                }
            }
        });
        this.hide();
    }

    @Override
    public void setTheme(Theme theme) {
        this.themeColorResId = theme == Theme.Blue ? R.color.alivc_blue : (theme == Theme.Green ? R.color.alivc_green : (theme == Theme.Orange ? R.color.alivc_orange : (theme == Theme.Red ? R.color.alivc_red : R.color.alivc_blue)));
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setOnQualityClickListener(OnQualityClickListener l) {
        this.mOnQualityClickListener = l;
    }

    public void setQuality(List<TrackInfo> qualities, String currentQuality) {
        this.mQualityItems = this.sortQuality(qualities);
        this.currentQuality = currentQuality;
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setIsMtsSource(boolean isMts) {
        this.isMtsSource = isMts;
    }

    private List<TrackInfo> sortQuality(List<TrackInfo> qualities) {
        if (this.isMtsSource) {
            return qualities;
        }
        TrackInfo ld = null;
        TrackInfo sd = null;
        TrackInfo hd = null;
        TrackInfo fd = null;
        TrackInfo k2 = null;
        TrackInfo k4 = null;
        TrackInfo od = null;
        TrackInfo sq = null;
        TrackInfo hq = null;
        for (TrackInfo quality : qualities) {
            if ("FD".equals(quality.getVodDefinition())) {
                fd = quality;
                continue;
            }
            if ("LD".equals(quality.getVodDefinition())) {
                ld = quality;
                continue;
            }
            if ("SD".equals(quality.getVodDefinition())) {
                sd = quality;
                continue;
            }
            if ("HD".equals(quality.getVodDefinition())) {
                hd = quality;
                continue;
            }
            if ("2K".equals(quality.getVodDefinition())) {
                k2 = quality;
                continue;
            }
            if ("4K".equals(quality.getVodDefinition())) {
                k4 = quality;
                continue;
            }
            if ("OD".equals(quality.getVodDefinition())) {
                od = quality;
                continue;
            }
            if ("SQ".equals(quality.getVodDefinition())) {
                sq = quality;
                continue;
            }
            if (!"HQ".equals(quality.getVodDefinition())) continue;
            hq = quality;
        }
        LinkedList<TrackInfo> sortedQuality = new LinkedList<TrackInfo>();
        if (sq != null) {
            sortedQuality.add(sq);
        }
        if (hq != null) {
            sortedQuality.add(hq);
        }
        if (fd != null) {
            sortedQuality.add(fd);
        }
        if (ld != null) {
            sortedQuality.add(ld);
        }
        if (sd != null) {
            sortedQuality.add(sd);
        }
        if (hd != null) {
            sortedQuality.add(hd);
        }
        if (k2 != null) {
            sortedQuality.add(k2);
        }
        if (k4 != null) {
            sortedQuality.add(k4);
        }
        if (od != null) {
            sortedQuality.add(od);
        }
        return sortedQuality;
    }

    public void showAtTop(View anchor) {
        FrameLayout.LayoutParams listViewParam = (FrameLayout.LayoutParams)this.mListView.getLayoutParams();
        listViewParam.width = anchor.getWidth();
        listViewParam.height = this.getResources().getDimensionPixelSize(R.dimen.alivc_player_rate_item_height) * this.mQualityItems.size();
        int[] location = new int[2];
        anchor.getLocationInWindow(location);
        listViewParam.leftMargin = location[0];
        listViewParam.topMargin = this.getHeight() - listViewParam.height - anchor.getHeight() - 20;
        this.mListView.setLayoutParams((ViewGroup.LayoutParams)listViewParam);
        this.mListView.setVisibility(0);
    }

    public void hide() {
        if (this.mListView != null && this.mListView.getVisibility() == 0) {
            this.mListView.setVisibility(8);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mListView.getVisibility() == 0) {
            this.hide();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private class QualityAdapter
    extends BaseAdapter {
        private QualityAdapter() {
        }

        public int getCount() {
            if (QualityView.this.mQualityItems != null) {
                return QualityView.this.mQualityItems.size();
            }
            return 0;
        }

        public Object getItem(int position) {
            return QualityView.this.mQualityItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView view = (TextView)LayoutInflater.from((Context)QualityView.this.getContext()).inflate(R.layout.ratetype_item, null);
            if (QualityView.this.mQualityItems != null) {
                TrackInfo trackInfo = (TrackInfo)QualityView.this.mQualityItems.get(position);
                String quality = trackInfo.getVodDefinition();
                view.setText((CharSequence)QualityItem.getItem(QualityView.this.getContext(), quality, QualityView.this.isMtsSource).getName());
                if (quality.equals(QualityView.this.currentQuality)) {
                    view.setTextColor(ContextCompat.getColor((Context)QualityView.this.getContext(), (int)QualityView.this.themeColorResId));
                } else {
                    view.setTextColor(ContextCompat.getColor((Context)QualityView.this.getContext(), (int)R.color.alivc_common_font_white_light));
                }
            }
            return view;
        }
    }

    public static interface OnQualityClickListener {
        public void onQualityClick(TrackInfo var1);
    }
}

