/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.view.tipsview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.aliyunplayerbase.R;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;

public class ReplayView
extends RelativeLayout {
    private TextView mReplayBtn;
    private OnReplayClickListener mOnReplayClickListener = null;
    private OnTipsViewBackClickListener mOnTipsViewBackClickListener = null;
    private ImageView mBackImageView;

    public ReplayView(Context context) {
        super(context);
        this.init();
    }

    public ReplayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ReplayView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.alivc_dialog_replay, (ViewGroup)this);
        this.mReplayBtn = (TextView)view.findViewById(R.id.replay);
        this.mBackImageView = (ImageView)view.findViewById(R.id.iv_back);
        this.mReplayBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ReplayView.this.mOnReplayClickListener != null) {
                    ReplayView.this.mOnReplayClickListener.onReplay();
                }
            }
        });
        this.mBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ReplayView.this.mOnTipsViewBackClickListener != null) {
                    ReplayView.this.mOnTipsViewBackClickListener.onBackClick();
                }
            }
        });
    }

    public void setOnReplayClickListener(OnReplayClickListener l) {
        this.mOnReplayClickListener = l;
    }

    public void setOnBackClickListener(OnTipsViewBackClickListener listener) {
        this.mOnTipsViewBackClickListener = listener;
    }

    public static interface OnReplayClickListener {
        public void onReplay();
    }
}

