/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.player;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.aliyun.player.AVPBase;
import com.aliyun.player.IPlayer;
import com.aliyun.player.nativeclass.JniSaasPlayer;
import com.aliyun.player.nativeclass.NativePlayerBase;
import com.aliyun.player.source.LiveShift;
import com.aliyun.player.source.UrlSource;
import com.aliyun.sdk.liveshift.LiveTimeUpdater;
import com.aliyun.sdk.player.AliLiveShiftPlayer;
import java.lang.ref.WeakReference;

public class ApsaraLiveShiftPlayer
extends AVPBase
implements AliLiveShiftPlayer {
    public static final int SeekLive = 10;
    private int status;
    private int statusWhenSeek;
    private long liveSeekToTime = -1L;
    private long liveSeekOffset = -1L;
    private LiveShift liveShiftSource = null;
    private LiveTimeUpdater liveTimeUpdater = null;
    private InnerTimeShiftUpdaterListener timeShiftUpdaterListener = null;
    private AliLiveShiftPlayer.OnSeekLiveCompletionListener mOutSeekLiveCompletionListener = null;
    private IPlayer.OnPreparedListener mOnPreparedListener = null;
    private IPlayer.OnStateChangedListener mOnStateChangedListener = null;
    private IPlayer.OnStateChangedListener innerOnStateChangedListener = new InnerStateChangedListener(this);
    private IPlayer.OnLoadingStatusListener mOnLoadingStatusListener = null;
    private IPlayer.OnLoadingStatusListener innerOnLoadingStatusListener = new InnerOnLoadingStatusListener(this);
    private AliLiveShiftPlayer.OnTimeShiftUpdaterListener mOutTimeShiftUpdaterListener = null;

    public ApsaraLiveShiftPlayer(Context context) {
        super(context, (String)null);
        this.timeShiftUpdaterListener = new InnerTimeShiftUpdaterListener(this);
    }

    public ApsaraLiveShiftPlayer(Context context, String traceID) {
        super(context, traceID);
        this.timeShiftUpdaterListener = new InnerTimeShiftUpdaterListener(this);
    }

    protected NativePlayerBase createAlivcMediaPlayer(Context context) {
        return new JniSaasPlayer(context);
    }

    @Override
    public void setDataSource(LiveShift liveShift) {
        this.liveShiftSource = liveShift;
        UrlSource urlSource = new UrlSource();
        urlSource.setUri(liveShift.getUrl());
        NativePlayerBase corePlayer = this.getCorePlayer();
        if (corePlayer instanceof JniSaasPlayer) {
            ((JniSaasPlayer)corePlayer).setDataSource(urlSource);
        }
    }

    @Override
    public long getCurrentLiveTime() {
        if (this.liveTimeUpdater != null) {
            return this.liveTimeUpdater.getLiveTime();
        }
        return 0L;
    }

    @Override
    public long getCurrentTime() {
        if (this.liveTimeUpdater != null) {
            return this.liveTimeUpdater.getPlayTime();
        }
        return 0L;
    }

    @Override
    public void seekToLiveTime(long liveTime) {
        if (this.status == 10) {
            return;
        }
        if (this.liveShiftSource == null) {
            return;
        }
        this.statusWhenSeek = this.status;
        this.status = 10;
        this.liveSeekToTime = liveTime;
        this.liveSeekOffset = this.getCurrentLiveTime() - this.liveSeekToTime;
        if (this.liveSeekOffset < 0L) {
            this.liveSeekOffset = 0L;
            this.liveSeekToTime = this.getCurrentLiveTime();
        }
        String finalPlayUrl = this.liveShiftSource.getUrl();
        if (this.liveSeekToTime > 0L && this.liveSeekOffset > 0L) {
            String queryStr = Uri.parse((String)finalPlayUrl).getQuery();
            finalPlayUrl = finalPlayUrl.endsWith("?") || finalPlayUrl.endsWith("&") ? finalPlayUrl + "lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on" : (TextUtils.isEmpty((CharSequence)queryStr) ? finalPlayUrl + "?lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on" : finalPlayUrl + "&lhs_offset_unix_s_0=" + this.liveSeekOffset + "&lhs_start=1&aliyunols=on");
        }
        UrlSource urlSource = new UrlSource();
        urlSource.setUri(finalPlayUrl);
        NativePlayerBase corePlayer = this.getCorePlayer();
        if (corePlayer instanceof JniSaasPlayer) {
            this.stopInner();
            ((JniSaasPlayer)corePlayer).setDataSource(urlSource);
            corePlayer.prepare();
        }
    }

    @Override
    public void setOnTimeShiftUpdaterListener(AliLiveShiftPlayer.OnTimeShiftUpdaterListener l) {
        this.mOutTimeShiftUpdaterListener = l;
    }

    @Override
    public void setOnSeekLiveCompletionListener(AliLiveShiftPlayer.OnSeekLiveCompletionListener l) {
        this.mOutSeekLiveCompletionListener = l;
    }

    private void onPrepared() {
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.stopUpdater();
        } else {
            this.liveTimeUpdater = new LiveTimeUpdater(this.mContext, this.liveShiftSource);
            this.liveTimeUpdater.setUpdaterListener(this.timeShiftUpdaterListener);
        }
        this.liveTimeUpdater.setStartPlayTime(this.liveSeekToTime);
        this.liveTimeUpdater.startUpdater();
        if (this.status == 10) {
            this.status = 2;
            if (this.statusWhenSeek == 3) {
                this.start();
            } else {
                this.liveTimeUpdater.pauseUpdater();
            }
            if (this.mOutSeekLiveCompletionListener != null) {
                this.mOutSeekLiveCompletionListener.onSeekLiveCompletion(this.liveSeekToTime);
            }
            this.liveSeekToTime = -1L;
        } else {
            this.status = 2;
            if (this.mOnPreparedListener != null) {
                this.mOnPreparedListener.onPrepared();
            }
        }
    }

    private void onStateChanged(int newState) {
        if (newState != 2) {
            this.status = newState;
        }
        if (this.mOnStateChangedListener != null) {
            this.mOnStateChangedListener.onStateChanged(newState);
        }
    }

    public void setOnStateChangedListener(IPlayer.OnStateChangedListener l) {
        this.mOnStateChangedListener = l;
        super.setOnStateChangedListener(this.innerOnStateChangedListener);
    }

    private void onLoadingBegin() {
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.pauseUpdater();
        }
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingBegin();
        }
    }

    private void onLoadingProgress(int percent, float netSpeed) {
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingProgress(percent, netSpeed);
        }
    }

    private void onLoadingEnd() {
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.resumeUpdater();
        }
        if (this.mOnLoadingStatusListener != null) {
            this.mOnLoadingStatusListener.onLoadingEnd();
        }
    }

    public void setOnLoadingStatusListener(IPlayer.OnLoadingStatusListener l) {
        this.mOnLoadingStatusListener = l;
        super.setOnLoadingStatusListener(this.innerOnLoadingStatusListener);
    }

    public void setOnPreparedListener(IPlayer.OnPreparedListener listener) {
        this.mOnPreparedListener = listener;
        super.setOnPreparedListener((IPlayer.OnPreparedListener)new InnerPreparedListener(this));
    }

    public void start() {
        super.start();
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.resumeUpdater();
        }
    }

    public void pause() {
        super.pause();
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.pauseUpdater();
        }
    }

    public void stop() {
        super.stop();
        if (this.liveTimeUpdater != null) {
            this.liveTimeUpdater.stopUpdater();
        }
    }

    private void onUpdater(long currentTime, long shiftStartTime, long shiftEndTime) {
        if (this.mOutTimeShiftUpdaterListener != null) {
            this.mOutTimeShiftUpdaterListener.onUpdater(currentTime, shiftStartTime, shiftEndTime);
        }
    }

    private static class InnerTimeShiftUpdaterListener
    implements AliLiveShiftPlayer.OnTimeShiftUpdaterListener {
        private WeakReference<ApsaraLiveShiftPlayer> playerReference;

        public InnerTimeShiftUpdaterListener(ApsaraLiveShiftPlayer shiftPlayer) {
            this.playerReference = new WeakReference<ApsaraLiveShiftPlayer>(shiftPlayer);
        }

        @Override
        public void onUpdater(long currentTime, long shiftStartTime, long shiftEndTime) {
            ApsaraLiveShiftPlayer playerProxy = (ApsaraLiveShiftPlayer)this.playerReference.get();
            if (playerProxy != null) {
                playerProxy.onUpdater(currentTime, shiftStartTime, shiftEndTime);
            }
        }
    }

    private static class InnerOnLoadingStatusListener
    implements IPlayer.OnLoadingStatusListener {
        private WeakReference<ApsaraLiveShiftPlayer> playerWR;

        InnerOnLoadingStatusListener(ApsaraLiveShiftPlayer apsaraLiveShiftPlayer) {
            this.playerWR = new WeakReference<ApsaraLiveShiftPlayer>(apsaraLiveShiftPlayer);
        }

        public void onLoadingBegin() {
            ApsaraLiveShiftPlayer player = (ApsaraLiveShiftPlayer)this.playerWR.get();
            if (player != null) {
                player.onLoadingBegin();
            }
        }

        public void onLoadingProgress(int percent, float netSpeed) {
            ApsaraLiveShiftPlayer player = (ApsaraLiveShiftPlayer)this.playerWR.get();
            if (player != null) {
                player.onLoadingProgress(percent, netSpeed);
            }
        }

        public void onLoadingEnd() {
            ApsaraLiveShiftPlayer player = (ApsaraLiveShiftPlayer)this.playerWR.get();
            if (player != null) {
                player.onLoadingEnd();
            }
        }
    }

    private static class InnerStateChangedListener
    implements IPlayer.OnStateChangedListener {
        private WeakReference<ApsaraLiveShiftPlayer> playerWR;

        InnerStateChangedListener(ApsaraLiveShiftPlayer apsaraLiveShiftPlayer) {
            this.playerWR = new WeakReference<ApsaraLiveShiftPlayer>(apsaraLiveShiftPlayer);
        }

        public void onStateChanged(int newState) {
            ApsaraLiveShiftPlayer player = (ApsaraLiveShiftPlayer)this.playerWR.get();
            if (player != null) {
                player.onStateChanged(newState);
            }
        }
    }

    private static class InnerPreparedListener
    implements IPlayer.OnPreparedListener {
        private WeakReference<ApsaraLiveShiftPlayer> playerWR;

        InnerPreparedListener(ApsaraLiveShiftPlayer player) {
            this.playerWR = new WeakReference<ApsaraLiveShiftPlayer>(player);
        }

        public void onPrepared() {
            ApsaraLiveShiftPlayer player = (ApsaraLiveShiftPlayer)this.playerWR.get();
            if (player != null) {
                player.onPrepared();
            }
        }
    }
}

