/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.liveshift.request;

import android.content.Context;
import android.text.TextUtils;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.player.source.LiveShift;
import com.aliyun.sdk.liveshift.bean.TimeLineContent;
import com.aliyun.sdk.utils.BaseRequest;
import com.aliyun.sdk.utils.HttpClientHelper;
import com.aliyun.sdk.utils.JsonUtil;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class GetTimeShiftRequest
extends BaseRequest {
    private static final String TAG = "GetTimeShiftRequest";
    private LiveShift mLiveShiftSource;
    private WeakReference<Context> mContextWeak;
    private HttpClientHelper httpClientHelper = null;

    public GetTimeShiftRequest(Context context, LiveShift localSource, BaseRequest.OnRequestListener l) {
        super(context, l);
        this.mContextWeak = new WeakReference<Context>(context);
        this.mLiveShiftSource = localSource;
    }

    @Override
    public void runInBackground() {
        String requestUrl = this.mLiveShiftSource.getTimeLineUrl();
        if (this.wantStop) {
            this.sendFailResult(-1, "", "");
            return;
        }
        String responseStr = null;
        try {
            this.httpClientHelper = new HttpClientHelper(requestUrl);
            responseStr = this.httpClientHelper.doGet();
            if (TextUtils.isEmpty((CharSequence)responseStr)) {
                this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_REQUEST_ERROR.getValue(), "request fail", "");
                return;
            }
            JSONObject responseJson = new JSONObject(responseStr);
            int retCode = JsonUtil.getInt(responseJson, "retCode");
            if (retCode != 0) {
                this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_REQUEST_ERROR.getValue(), "request fail", "");
            } else {
                TimeLineContent timeLineContent = TimeLineContent.getInfoFromJson(responseJson.getJSONObject("content"));
                this.sendSuccessResult(timeLineContent, "");
            }
        }
        catch (JSONException e) {
            this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_DATA_PARSER_ERROR.getValue(), "response not json", "");
        }
        catch (Exception e) {
            this.sendFailResult(ErrorCode.ERROR_SERVER_LIVESHIFT_UNKNOWN.getValue(), "unknow error", "");
        }
    }

    @Override
    public void stopInner() {
        if (this.httpClientHelper != null) {
            this.httpClientHelper.stop();
        }
    }
}

