/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Common {
    private static Common instance;
    private static final int SUCCESS = 1;
    private static final int FAILED = 0;
    private Context context;
    private FileOperateCallback callback;
    private volatile boolean isSuccess;
    private String errorStr;
    private ThreadPoolExecutor threadPoolExecutor;
    private String srcPath;
    private String sdPath;
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (Common.this.callback != null) {
                if (msg.what == 1) {
                    Common.this.callback.onSuccess();
                }
                if (msg.what == 0) {
                    Common.this.callback.onFailed(msg.obj.toString());
                }
            }
            Common.this.threadPoolExecutor.remove(Common.this.runnable);
            Common.this.context = null;
            instance = null;
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            Common.this.copyAssetsToDst(Common.this.context, Common.this.srcPath, Common.this.sdPath);
            if (Common.this.isSuccess) {
                Common.this.handler.obtainMessage(1).sendToTarget();
            } else {
                Common.this.handler.obtainMessage(0, (Object)Common.this.errorStr).sendToTarget();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Common getInstance(Context context) {
        if (instance != null) return instance;
        Class<Common> clazz = Common.class;
        synchronized (Common.class) {
            if (instance != null) return instance;
            instance = new Common(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private Common(Context context) {
        this.context = context;
    }

    public Common copyAssetsToSD(String srcPath, String sdPath) {
        this.srcPath = srcPath;
        this.sdPath = sdPath;
        this.threadPoolExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        this.threadPoolExecutor.execute(Executors.defaultThreadFactory().newThread(this.runnable));
        return this;
    }

    public void setFileOperateCallback(FileOperateCallback callback) {
        this.callback = callback;
    }

    private void copyAssetsToDst(Context context, String srcPath, String dstPath) {
        try {
            String[] fileNames = context.getAssets().list(srcPath);
            if (fileNames.length > 0) {
                File file = new File(dstPath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                for (String fileName : fileNames) {
                    if (!"".equals(srcPath)) {
                        this.copyAssetsToDst(context, srcPath + File.separator + fileName, dstPath + File.separator + fileName);
                        continue;
                    }
                    this.copyAssetsToDst(context, fileName, dstPath + File.separator + fileName);
                }
            } else {
                int byteCount;
                File outFile = new File(dstPath);
                InputStream is = context.getAssets().open(srcPath);
                FileOutputStream fos = new FileOutputStream(outFile);
                byte[] buffer = new byte[1024];
                while ((byteCount = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, byteCount);
                }
                fos.flush();
                is.close();
                fos.close();
            }
            this.isSuccess = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorStr = e.getMessage();
            this.isSuccess = false;
        }
    }

    public void onDestroy() {
        if (this.threadPoolExecutor != null && this.runnable != null) {
            this.threadPoolExecutor.remove(this.runnable);
        }
        if (this.handler != null) {
            this.handler.removeMessages(1);
            this.handler.removeMessages(0);
            this.handler = null;
        }
        instance = null;
        this.callback = null;
        this.context = null;
    }

    public static interface FileOperateCallback {
        public void onSuccess();

        public void onFailed(String var1);
    }
}

