/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.gesturedialog;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;

public class BaseGestureDialog
extends PopupWindow {
    TextView mTextView;
    ImageView mImageView;
    private int mDialogWidthAndHeight;
    private AliyunScreenMode mCurrentScreenMode = AliyunScreenMode.Small;

    public BaseGestureDialog(Context context) {
        LayoutInflater mInflater = (LayoutInflater)context.getApplicationContext().getSystemService("layout_inflater");
        View view = mInflater.inflate(R.layout.alivc_dialog_gesture, null);
        view.measure(0, 0);
        this.setContentView(view);
        this.mTextView = (TextView)view.findViewById(R.id.gesture_text);
        this.mImageView = (ImageView)view.findViewById(R.id.gesture_image);
        this.mDialogWidthAndHeight = context.getResources().getDimensionPixelSize(R.dimen.alivc_player_gesture_dialog_size);
        this.setWidth(this.mDialogWidthAndHeight);
        this.setHeight(this.mDialogWidthAndHeight);
    }

    public void show(View parent) {
        int[] location = new int[2];
        parent.getLocationOnScreen(location);
        int x = location[0] + (parent.getRight() - parent.getLeft() - this.mDialogWidthAndHeight) / 2;
        int y = location[1] + (parent.getBottom() - parent.getTop() - this.mDialogWidthAndHeight) / 2;
        if (this.mCurrentScreenMode == AliyunScreenMode.Small) {
            this.showAtLocation(parent, 51, x, y);
        } else {
            this.showAtLocation(parent, 17, 0, 0);
        }
    }

    public void setScreenMode(AliyunScreenMode currentScreenMode) {
        this.mCurrentScreenMode = currentScreenMode;
    }
}

