/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.more;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.SeekBar;
import android.widget.TextView;
import com.aliyun.player.IPlayer;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.view.more.AliyunShowMoreValue;

public class ShowMoreView
extends LinearLayout
implements View.OnClickListener,
RadioGroup.OnCheckedChangeListener {
    private Context context;
    private SeekBar seekLight;
    private SeekBar seekVoice;
    private TextView tvDonwload;
    private TextView tvCastScreen;
    private TextView tvBarrage;
    private RadioGroup rgSpeed;
    private AliyunShowMoreValue moreValue;
    private OnDownloadButtonClickListener mOnDownloadButtonClickListener;
    private OnSpeedCheckedChangedListener mOnSpeedCheckedChangedListener;
    private OnLoopCheckedChangedListener mOnLoopCheckedChangedListener;
    private OnLightSeekChangeListener mOnLightSeekChangeListener;
    private OnVoiceSeekChangeListener mOnVoiceSeekChangeListener;
    private OnScreenCastButtonClickListener mOnScreenCastButtonClickListener;
    private OnScaleModeCheckedChangedListener mOnScaleModeCheckedChangedListener;
    private OnBarrageButtonClickListener mOnBarrageButtonClickListener;
    private RadioGroup scaleModelRadioGroup;
    private RadioGroup loopPlayRadioGroup;

    public ShowMoreView(Context context, AliyunShowMoreValue moreValue) {
        super(context);
        this.context = context;
        this.moreValue = moreValue;
        this.init();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.alivc_dialog_more, (ViewGroup)this, true);
        this.findAllViews(view);
    }

    private void findAllViews(View view) {
        this.seekLight = (SeekBar)view.findViewById(R.id.seek_light);
        this.seekVoice = (SeekBar)view.findViewById(R.id.seek_voice);
        this.tvDonwload = (TextView)view.findViewById(R.id.tv_download);
        this.tvCastScreen = (TextView)view.findViewById(R.id.tv_cast_screen);
        this.tvBarrage = (TextView)view.findViewById(R.id.tv_barrage);
        this.rgSpeed = (RadioGroup)this.findViewById(R.id.alivc_rg_speed);
        this.loopPlayRadioGroup = (RadioGroup)view.findViewById(R.id.alivc_rg_loop);
        this.scaleModelRadioGroup = (RadioGroup)view.findViewById(R.id.alivc_rg_scale_model);
        this.configViews();
        this.addListener();
    }

    private void configViews() {
        if (this.moreValue == null) {
            return;
        }
        this.seekLight.setProgress(this.moreValue.getScreenBrightness());
        this.seekVoice.setProgress(this.moreValue.getVolume());
        int currentRbIndex = 0;
        float curentSpeed = this.moreValue.getSpeed();
        if (curentSpeed == 0.0f) {
            currentRbIndex = 0;
        } else if (curentSpeed == 0.5f) {
            currentRbIndex = 1;
        } else if (curentSpeed == 1.5f) {
            currentRbIndex = 2;
        } else if (curentSpeed == 2.0f) {
            currentRbIndex = 3;
        }
        this.rgSpeed.check(this.rgSpeed.getChildAt(currentRbIndex).getId());
        IPlayer.ScaleMode currentScaleMode = this.moreValue.getScaleMode();
        int currentScaleModeIndex = currentScaleMode == IPlayer.ScaleMode.SCALE_ASPECT_FIT ? 0 : (currentScaleMode == IPlayer.ScaleMode.SCALE_ASPECT_FILL ? 1 : (currentScaleMode == IPlayer.ScaleMode.SCALE_TO_FILL ? 2 : 0));
        this.scaleModelRadioGroup.check(this.scaleModelRadioGroup.getChildAt(currentScaleModeIndex).getId());
        this.loopPlayRadioGroup.check(this.loopPlayRadioGroup.getChildAt(this.moreValue.isLoop() ? 0 : 1).getId());
    }

    private void addListener() {
        this.tvDonwload.setOnClickListener((View.OnClickListener)this);
        this.tvCastScreen.setOnClickListener((View.OnClickListener)this);
        this.tvBarrage.setOnClickListener((View.OnClickListener)this);
        this.rgSpeed.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.loopPlayRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.scaleModelRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.seekLight.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (ShowMoreView.this.mOnLightSeekChangeListener != null) {
                    ShowMoreView.this.mOnLightSeekChangeListener.onStart(seekBar);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (ShowMoreView.this.mOnLightSeekChangeListener != null) {
                    ShowMoreView.this.mOnLightSeekChangeListener.onProgress(seekBar, progress, fromUser);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (ShowMoreView.this.mOnLightSeekChangeListener != null) {
                    ShowMoreView.this.mOnLightSeekChangeListener.onStop(seekBar);
                }
            }
        });
        this.seekVoice.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (ShowMoreView.this.mOnVoiceSeekChangeListener != null) {
                    ShowMoreView.this.mOnVoiceSeekChangeListener.onStart(seekBar);
                }
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (ShowMoreView.this.mOnVoiceSeekChangeListener != null) {
                    ShowMoreView.this.mOnVoiceSeekChangeListener.onProgress(seekBar, progress, fromUser);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (ShowMoreView.this.mOnVoiceSeekChangeListener != null) {
                    ShowMoreView.this.mOnVoiceSeekChangeListener.onStop(seekBar);
                }
            }
        });
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.tv_download) {
            if (this.mOnDownloadButtonClickListener != null) {
                this.mOnDownloadButtonClickListener.onDownloadClick();
            }
        } else if (id2 == R.id.tv_cast_screen) {
            if (this.mOnScreenCastButtonClickListener != null) {
                this.mOnScreenCastButtonClickListener.onScreenCastClick();
            }
        } else if (id2 == R.id.tv_barrage && this.mOnBarrageButtonClickListener != null) {
            this.mOnBarrageButtonClickListener.onBarrageClick();
        }
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (this.mOnSpeedCheckedChangedListener != null && group == this.rgSpeed) {
            this.mOnSpeedCheckedChangedListener.onSpeedChanged(group, checkedId);
        }
        if (this.mOnScaleModeCheckedChangedListener != null && group == this.scaleModelRadioGroup) {
            this.mOnScaleModeCheckedChangedListener.onScaleModeChanged(group, checkedId);
        }
        if (this.mOnLoopCheckedChangedListener != null && group == this.loopPlayRadioGroup) {
            this.mOnLoopCheckedChangedListener.onLoopChanged(group, checkedId);
        }
    }

    public void setOnDownloadButtonClickListener(OnDownloadButtonClickListener listener) {
        this.mOnDownloadButtonClickListener = listener;
    }

    public void setOnScreenCastButtonClickListener(OnScreenCastButtonClickListener listener) {
        this.mOnScreenCastButtonClickListener = listener;
    }

    public void setOnBarrageButtonClickListener(OnBarrageButtonClickListener listener) {
        this.mOnBarrageButtonClickListener = listener;
    }

    public void setOnLoopCheckedChangedListener(OnLoopCheckedChangedListener listener) {
        this.mOnLoopCheckedChangedListener = listener;
    }

    public void setOnSpeedCheckedChangedListener(OnSpeedCheckedChangedListener listener) {
        this.mOnSpeedCheckedChangedListener = listener;
    }

    public void setOnScaleModeCheckedChangedListener(OnScaleModeCheckedChangedListener listener) {
        this.mOnScaleModeCheckedChangedListener = listener;
    }

    public void setOnLightSeekChangeListener(OnLightSeekChangeListener listener) {
        this.mOnLightSeekChangeListener = listener;
    }

    public void setOnVoiceSeekChangeListener(OnVoiceSeekChangeListener listener) {
        this.mOnVoiceSeekChangeListener = listener;
    }

    public void setVoiceVolume(float volume) {
        if (this.seekVoice != null) {
            this.seekVoice.setProgress((int)(volume * 100.0f));
        }
    }

    public void setBrightness(int value) {
        if (this.seekLight != null) {
            this.seekLight.setProgress(value);
        }
    }

    public static interface OnVoiceSeekChangeListener {
        public void onStart(SeekBar var1);

        public void onProgress(SeekBar var1, int var2, boolean var3);

        public void onStop(SeekBar var1);
    }

    public static interface OnLightSeekChangeListener {
        public void onStart(SeekBar var1);

        public void onProgress(SeekBar var1, int var2, boolean var3);

        public void onStop(SeekBar var1);
    }

    public static interface OnScaleModeCheckedChangedListener {
        public void onScaleModeChanged(RadioGroup var1, int var2);
    }

    public static interface OnSpeedCheckedChangedListener {
        public void onSpeedChanged(RadioGroup var1, int var2);
    }

    public static interface OnLoopCheckedChangedListener {
        public void onLoopChanged(RadioGroup var1, int var2);
    }

    public static interface OnBarrageButtonClickListener {
        public void onBarrageClick();
    }

    public static interface OnScreenCastButtonClickListener {
        public void onScreenCastClick();
    }

    public static interface OnDownloadButtonClickListener {
        public void onDownloadClick();
    }
}

