/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.more;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.view.quality.QualityItem;
import com.aliyun.player.nativeclass.TrackInfo;
import java.util.List;
import java.util.Locale;

public class TrackInfoView
extends LinearLayout
implements RadioGroup.OnCheckedChangeListener {
    private Context mContext;
    private RadioGroup mTrackInfoRadioGroup;
    private OnAudioChangedListener mOnAudioChangedListener;
    private OnBitrateChangedListener mOnBitrateChangedListener;
    private OnSubtitleChangedListener mOnSubtitleChangedListener;
    private OnDefinitionChangedListrener mOnDefinitionChangedListener;

    public TrackInfoView(Context context) {
        super(context);
        this.mContext = context;
        this.init();
    }

    public TrackInfoView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.init();
    }

    public TrackInfoView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.alivc_dialog_trackinfo, (ViewGroup)this, true);
        this.findAllViews(view);
        this.initListener();
    }

    private void findAllViews(View view) {
        this.mTrackInfoRadioGroup = (RadioGroup)view.findViewById(R.id.radio_group_track_info);
    }

    private void initListener() {
        this.mTrackInfoRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
    }

    public void setTrackInfoLists(List<TrackInfo> trackInfoLists) {
        if (this.mTrackInfoRadioGroup != null && trackInfoLists != null) {
            for (int i = 0; i < trackInfoLists.size(); ++i) {
                TrackInfo trackInfo = trackInfoLists.get(i);
                RadioButton radioButton = this.createRadioButton();
                radioButton.setTag((Object)trackInfo);
                if (trackInfo.getType() == TrackInfo.Type.TYPE_AUDIO) {
                    radioButton.setText((CharSequence)trackInfo.getAudioLang());
                } else if (trackInfo.getType() == TrackInfo.Type.TYPE_SUBTITLE) {
                    radioButton.setText((CharSequence)trackInfo.getSubtitleLang());
                } else if (trackInfo.getType() == TrackInfo.Type.TYPE_VOD) {
                    QualityItem item = QualityItem.getItem(this.getContext(), trackInfo.getVodDefinition(), false);
                    radioButton.setText((CharSequence)item.getName());
                } else if (i == 0) {
                    radioButton.setText((CharSequence)"\u81ea\u52a8\u7801\u7387");
                    radioButton.setId(R.id.auto_bitrate);
                } else {
                    radioButton.setText((CharSequence)String.format(Locale.getDefault(), "%d", trackInfo.getVideoBitrate()));
                }
                this.mTrackInfoRadioGroup.addView((View)radioButton);
            }
        }
    }

    private RadioButton createRadioButton() {
        RadioButton radioButton = new RadioButton(this.mContext);
        radioButton.setPadding(50, 50, 50, 50);
        radioButton.setGravity(17);
        radioButton.setButtonDrawable(null);
        radioButton.setTextColor(this.getResources().getColorStateList(R.color.radio_track_info_color_selector));
        return radioButton;
    }

    public void setCurrentTrackInfo(TrackInfo trackInfo) {
        if (this.mTrackInfoRadioGroup != null && this.mTrackInfoRadioGroup.getChildCount() > 0) {
            int childCount = this.mTrackInfoRadioGroup.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                RadioButton radioButtaon = (RadioButton)this.mTrackInfoRadioGroup.getChildAt(i);
                if (radioButtaon == null) continue;
                TrackInfo radioButtonTag = (TrackInfo)radioButtaon.getTag();
                if (trackInfo == null || radioButtonTag == null || trackInfo.getIndex() != radioButtonTag.getIndex() || trackInfo.getType() == TrackInfo.Type.TYPE_VIDEO && i == 0) continue;
                this.mTrackInfoRadioGroup.check(radioButtaon.getId());
                break;
            }
        }
    }

    public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
        RadioButton mRadioButton = (RadioButton)radioGroup.findViewById(checkedId);
        Object radioButtonTag = mRadioButton.getTag();
        if (radioButtonTag instanceof TrackInfo) {
            TrackInfo mTrackInfo = (TrackInfo)mRadioButton.getTag();
            if (mTrackInfo != null) {
                TrackInfo.Type type = mTrackInfo.getType();
                if (type == TrackInfo.Type.TYPE_AUDIO) {
                    if (this.mOnAudioChangedListener != null) {
                        this.mOnAudioChangedListener.onAudioChanged(mTrackInfo);
                    }
                } else if (type == TrackInfo.Type.TYPE_SUBTITLE) {
                    if (this.mOnSubtitleChangedListener != null) {
                        this.mOnSubtitleChangedListener.onSubtitleChanged(mTrackInfo);
                    }
                } else if (type == TrackInfo.Type.TYPE_VIDEO) {
                    if (this.mOnBitrateChangedListener != null) {
                        this.mOnBitrateChangedListener.onBitrateChanged(mTrackInfo, checkedId);
                    }
                } else if (this.mOnDefinitionChangedListener != null) {
                    this.mOnDefinitionChangedListener.onDefinitionChanged(mTrackInfo);
                }
            } else if (this.mOnBitrateChangedListener != null) {
                this.mOnBitrateChangedListener.onBitrateChanged(mTrackInfo, checkedId);
            }
        } else if (radioButtonTag instanceof String && this.mOnSubtitleChangedListener != null) {
            this.mOnSubtitleChangedListener.onSubtitleCancel();
        }
    }

    public void setOnAudioChangedListener(OnAudioChangedListener listener) {
        this.mOnAudioChangedListener = listener;
    }

    public void setOnBitrateChangedListener(OnBitrateChangedListener listener) {
        this.mOnBitrateChangedListener = listener;
    }

    public void setOnSubtitleChangedListener(OnSubtitleChangedListener listener) {
        this.mOnSubtitleChangedListener = listener;
    }

    public void setOnDefinitionChangedListener(OnDefinitionChangedListrener listener) {
        this.mOnDefinitionChangedListener = listener;
    }

    public static interface OnDefinitionChangedListrener {
        public void onDefinitionChanged(TrackInfo var1);
    }

    public static interface OnSubtitleChangedListener {
        public void onSubtitleChanged(TrackInfo var1);

        public void onSubtitleCancel();
    }

    public static interface OnBitrateChangedListener {
        public void onBitrateChanged(TrackInfo var1, int var2);
    }

    public static interface OnAudioChangedListener {
        public void onAudioChanged(TrackInfo var1);
    }
}

