/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.sectionlist;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.aliyun.player.alivcplayerexpand.view.sectionlist.Section;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class SectionedRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int VIEW_TYPE_HEADER = 0;
    public static final int VIEW_TYPE_FOOTER = 1;
    public static final int VIEW_TYPE_ITEM_LOADED = 2;
    public static final int VIEW_TYPE_LOADING = 3;
    public static final int VIEW_TYPE_FAILED = 4;
    public static final int VIEW_TYPE_EMPTY = 5;
    private final Map<String, Section> sections = new LinkedHashMap<String, Section>();
    private final Map<String, Integer> sectionViewTypeNumbers = new LinkedHashMap<String, Integer>();
    private int viewTypeCount = 0;
    private static final int VIEW_TYPE_QTY = 6;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder = null;
        block8: for (Map.Entry<String, Integer> entry : this.sectionViewTypeNumbers.entrySet()) {
            if (viewType < entry.getValue() || viewType >= entry.getValue() + 6) continue;
            Section section = this.sections.get(entry.getKey());
            int sectionViewType = viewType - entry.getValue();
            switch (sectionViewType) {
                case 0: {
                    viewHolder = this.getHeaderViewHolder(parent, section);
                    continue block8;
                }
                case 1: {
                    viewHolder = this.getFooterViewHolder(parent, section);
                    continue block8;
                }
                case 2: {
                    viewHolder = this.getItemViewHolder(parent, section);
                    continue block8;
                }
                case 3: {
                    viewHolder = this.getLoadingViewHolder(parent, section);
                    continue block8;
                }
                case 4: {
                    viewHolder = this.getFailedViewHolder(parent, section);
                    continue block8;
                }
                case 5: {
                    viewHolder = this.getEmptyViewHolder(parent, section);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid viewType");
        }
        return viewHolder;
    }

    @VisibleForTesting
    View inflate(@LayoutRes int layoutResourceId, ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResourceId, parent, false);
    }

    private RecyclerView.ViewHolder getItemViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isItemViewWillBeProvided()) {
            view = section.getItemView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getItemView() returned null");
            }
        } else {
            Integer resId = section.getItemResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'item' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getItemViewHolder(view);
    }

    private RecyclerView.ViewHolder getHeaderViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isHeaderViewWillBeProvided()) {
            view = section.getHeaderView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getHeaderView() returned null");
            }
        } else {
            Integer resId = section.getHeaderResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'header' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getHeaderViewHolder(view);
    }

    private RecyclerView.ViewHolder getFooterViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isFooterViewWillBeProvided()) {
            view = section.getFooterView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getFooterView() returned null");
            }
        } else {
            Integer resId = section.getFooterResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'footer' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getFooterViewHolder(view);
    }

    private RecyclerView.ViewHolder getLoadingViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isLoadingViewWillBeProvided()) {
            view = section.getLoadingView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getLoadingView() returned null");
            }
        } else {
            Integer resId = section.getLoadingResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'loading' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getLoadingViewHolder(view);
    }

    private RecyclerView.ViewHolder getFailedViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isFailedViewWillBeProvided()) {
            view = section.getFailedView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getFailedView() returned null");
            }
        } else {
            Integer resId = section.getFailedResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'failed' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getFailedViewHolder(view);
    }

    private RecyclerView.ViewHolder getEmptyViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isEmptyViewWillBeProvided()) {
            view = section.getEmptyView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getEmptyView() returned null");
            }
        } else {
            Integer resId = section.getEmptyResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'empty' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getEmptyViewHolder(view);
    }

    public void addSection(String tag, Section section) {
        this.sections.put(tag, section);
        this.sectionViewTypeNumbers.put(tag, this.viewTypeCount);
        this.viewTypeCount += 6;
    }

    public String addSection(Section section) {
        String tag = UUID.randomUUID().toString();
        this.addSection(tag, section);
        return tag;
    }

    public Section getSection(String tag) {
        return this.sections.get(tag);
    }

    public void removeSection(Section section) {
        String tag = null;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            if (entry.getValue() != section) continue;
            tag = entry.getKey();
        }
        if (tag != null) {
            this.removeSection(tag);
        }
    }

    public void removeSection(String tag) {
        this.sections.remove(tag);
        this.sectionViewTypeNumbers.remove(tag);
    }

    public void removeAllSections() {
        this.sections.clear();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                if (section.hasHeader() && position == currentPos) {
                    this.getSectionForPosition(position).onBindHeaderViewHolder(holder);
                    return;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    this.getSectionForPosition(position).onBindFooterViewHolder(holder);
                    return;
                }
                this.getSectionForPosition(position).onBindContentViewHolder(holder, this.getPositionInSection(position));
                return;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getItemCount() {
        int count = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            count += section.getSectionItemsTotal();
        }
        return count;
    }

    public int getItemViewType(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                int viewType = this.sectionViewTypeNumbers.get(entry.getKey());
                if (section.hasHeader() && position == currentPos) {
                    return viewType;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    return viewType + 1;
                }
                switch (section.getState()) {
                    case LOADED: {
                        return viewType + 2;
                    }
                    case LOADING: {
                        return viewType + 3;
                    }
                    case FAILED: {
                        return viewType + 4;
                    }
                    case EMPTY: {
                        return viewType + 5;
                    }
                }
                throw new IllegalStateException("Invalid state");
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getSectionItemViewType(int position) {
        int viewType = this.getItemViewType(position);
        return viewType % 6;
    }

    public Section getSectionForPosition(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return section;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    @Deprecated
    public int getSectionPosition(int position) {
        return this.getPositionInSection(position);
    }

    public int getPositionInSection(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return position - currentPos - (section.hasHeader() ? 1 : 0);
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getSectionPosition(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        return this.getSectionPosition(section);
    }

    public int getSectionPosition(Section section) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section loopSection = entry.getValue();
            if (!loopSection.isVisible()) continue;
            if (loopSection == section) {
                return currentPos;
            }
            int sectionTotal = loopSection.getSectionItemsTotal();
            currentPos += sectionTotal;
        }
        throw new IllegalArgumentException("Invalid section");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Map<String, Section> getCopyOfSectionsMap() {
        LinkedHashMap<String, Section> copyOfSections;
        Map<String, Section> map = this.sections;
        synchronized (map) {
            copyOfSections = new LinkedHashMap<String, Section>(this.sections);
        }
        return copyOfSections;
    }

    public int getPositionInAdapter(String tag, int position) {
        Section section = this.getValidSectionOrThrowException(tag);
        return this.getPositionInAdapter(section, position);
    }

    public int getPositionInAdapter(Section section, int position) {
        return this.getSectionPosition(section) + (section.hasHeader() ? 1 : 0) + position;
    }

    public int getHeaderPositionInAdapter(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        return this.getHeaderPositionInAdapter(section);
    }

    public int getHeaderPositionInAdapter(Section section) {
        if (!section.hasHeader()) {
            throw new IllegalStateException("Section doesn't have a header");
        }
        return this.getSectionPosition(section);
    }

    public int getFooterPositionInAdapter(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        return this.getFooterPositionInAdapter(section);
    }

    public int getFooterPositionInAdapter(Section section) {
        if (!section.hasFooter()) {
            throw new IllegalStateException("Section doesn't have a footer");
        }
        return this.getSectionPosition(section) + section.getSectionItemsTotal() - 1;
    }

    public void notifyItemInsertedInSection(String tag, int position) {
        this.callSuperNotifyItemInserted(this.getPositionInAdapter(tag, position));
    }

    public void notifyItemInsertedInSection(Section section, int position) {
        this.callSuperNotifyItemInserted(this.getPositionInAdapter(section, position));
    }

    @VisibleForTesting
    void callSuperNotifyItemInserted(int position) {
        super.notifyItemInserted(position);
    }

    public void notifyItemRangeInsertedInSection(String tag, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeInserted(this.getPositionInAdapter(tag, positionStart), itemCount);
    }

    public void notifyItemRangeInsertedInSection(Section section, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeInserted(this.getPositionInAdapter(section, positionStart), itemCount);
    }

    @VisibleForTesting
    void callSuperNotifyItemRangeInserted(int positionStart, int itemCount) {
        super.notifyItemRangeInserted(positionStart, itemCount);
    }

    public void notifyItemRemovedFromSection(String tag, int position) {
        this.callSuperNotifyItemRemoved(this.getPositionInAdapter(tag, position));
    }

    public void notifyItemRemovedFromSection(Section section, int position) {
        this.callSuperNotifyItemRemoved(this.getPositionInAdapter(section, position));
    }

    @VisibleForTesting
    void callSuperNotifyItemRemoved(int position) {
        super.notifyItemRemoved(position);
    }

    public void notifyItemRangeRemovedFromSection(String tag, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeRemoved(this.getPositionInAdapter(tag, positionStart), itemCount);
    }

    public void notifyItemRangeRemovedFromSection(Section section, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeRemoved(this.getPositionInAdapter(section, positionStart), itemCount);
    }

    @VisibleForTesting
    void callSuperNotifyItemRangeRemoved(int positionStart, int itemCount) {
        super.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void notifyItemChangedInSection(String tag, int position) {
        this.callSuperNotifyItemChanged(this.getPositionInAdapter(tag, position));
    }

    public void notifyItemChangedInSection(Section section, int position) {
        this.callSuperNotifyItemChanged(this.getPositionInAdapter(section, position));
    }

    public void notifyHeaderChangedInSection(String tag) {
        this.notifyHeaderChangedInSection(this.getValidSectionOrThrowException(tag));
    }

    public void notifyHeaderChangedInSection(Section section) {
        this.callSuperNotifyItemChanged(this.getHeaderPositionInAdapter(section));
    }

    public void notifyFooterChangedInSection(String tag) {
        this.notifyFooterChangedInSection(this.getValidSectionOrThrowException(tag));
    }

    public void notifyFooterChangedInSection(Section section) {
        this.callSuperNotifyItemChanged(this.getFooterPositionInAdapter(section));
    }

    @VisibleForTesting
    void callSuperNotifyItemChanged(int position) {
        super.notifyItemChanged(position);
    }

    public void notifyItemRangeChangedInSection(String tag, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeChanged(this.getPositionInAdapter(tag, positionStart), itemCount);
    }

    public void notifyItemRangeChangedInSection(Section section, int positionStart, int itemCount) {
        this.callSuperNotifyItemRangeChanged(this.getPositionInAdapter(section, positionStart), itemCount);
    }

    @VisibleForTesting
    void callSuperNotifyItemRangeChanged(int positionStart, int itemCount) {
        super.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void notifyItemRangeChangedInSection(String tag, int positionStart, int itemCount, Object payload) {
        this.callSuperNotifyItemRangeChanged(this.getPositionInAdapter(tag, positionStart), itemCount, payload);
    }

    public void notifyItemRangeChangedInSection(Section section, int positionStart, int itemCount, Object payload) {
        this.callSuperNotifyItemRangeChanged(this.getPositionInAdapter(section, positionStart), itemCount, payload);
    }

    @VisibleForTesting
    void callSuperNotifyItemRangeChanged(int positionStart, int itemCount, Object payload) {
        super.notifyItemRangeChanged(positionStart, itemCount, payload);
    }

    public void notifyItemMovedInSection(String tag, int fromPosition, int toPosition) {
        this.callSuperNotifyItemMoved(this.getPositionInAdapter(tag, fromPosition), this.getPositionInAdapter(tag, toPosition));
    }

    public void notifyItemMovedInSection(Section section, int fromPosition, int toPosition) {
        this.callSuperNotifyItemMoved(this.getPositionInAdapter(section, fromPosition), this.getPositionInAdapter(section, toPosition));
    }

    @VisibleForTesting
    void callSuperNotifyItemMoved(int fromPosition, int toPosition) {
        super.notifyItemMoved(fromPosition, toPosition);
    }

    public void notifyNotLoadedStateChanged(String tag, Section.State previousState) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyNotLoadedStateChanged(section, previousState);
    }

    public void notifyNotLoadedStateChanged(Section section, Section.State previousState) {
        Section.State state = section.getState();
        if (state == previousState) {
            throw new IllegalStateException("No state changed");
        }
        if (previousState == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedFromLoaded");
        }
        if (state == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedToLoaded");
        }
        this.notifyItemChangedInSection(section, 0);
    }

    public void notifyStateChangedToLoaded(String tag, Section.State previousState) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyStateChangedToLoaded(section, previousState);
    }

    public void notifyStateChangedToLoaded(Section section, Section.State previousState) {
        Section.State state = section.getState();
        if (state == previousState) {
            throw new IllegalStateException("No state changed");
        }
        if (state != Section.State.LOADED) {
            if (previousState == Section.State.LOADED) {
                throw new IllegalStateException("Use notifyStateChangedFromLoaded");
            }
            throw new IllegalStateException("Use notifyNotLoadedStateChanged");
        }
        int contentItemsTotal = section.getContentItemsTotal();
        if (contentItemsTotal == 0) {
            this.notifyItemRemovedFromSection(section, 0);
        } else {
            this.notifyItemChangedInSection(section, 0);
            if (contentItemsTotal > 1) {
                this.notifyItemRangeInsertedInSection(section, 1, contentItemsTotal - 1);
            }
        }
    }

    public void notifyStateChangedFromLoaded(String tag, int previousContentItemsCount) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyStateChangedFromLoaded(section, previousContentItemsCount);
    }

    public void notifyStateChangedFromLoaded(Section section, int previousContentItemsCount) {
        Section.State state = section.getState();
        if (state == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedToLoaded");
        }
        if (previousContentItemsCount == 0) {
            this.notifyItemInsertedInSection(section, 0);
        } else {
            if (previousContentItemsCount > 1) {
                this.notifyItemRangeRemovedFromSection(section, 1, previousContentItemsCount - 1);
            }
            this.notifyItemChangedInSection(section, 0);
        }
    }

    public void notifyHeaderInsertedInSection(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyHeaderInsertedInSection(section);
    }

    public void notifyHeaderInsertedInSection(Section section) {
        int headerPosition = this.getHeaderPositionInAdapter(section);
        this.callSuperNotifyItemInserted(headerPosition);
    }

    public void notifyFooterInsertedInSection(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyFooterInsertedInSection(section);
    }

    public void notifyFooterInsertedInSection(Section section) {
        int footerPosition = this.getFooterPositionInAdapter(section);
        this.callSuperNotifyItemInserted(footerPosition);
    }

    public void notifyHeaderRemovedFromSection(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyHeaderRemovedFromSection(section);
    }

    public void notifyHeaderRemovedFromSection(Section section) {
        int position = this.getSectionPosition(section);
        this.callSuperNotifyItemRemoved(position);
    }

    public void notifyFooterRemovedFromSection(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifyFooterRemovedFromSection(section);
    }

    public void notifyFooterRemovedFromSection(Section section) {
        int position = this.getSectionPosition(section) + section.getSectionItemsTotal();
        this.callSuperNotifyItemRemoved(position);
    }

    public void notifySectionChangedToVisible(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifySectionChangedToVisible(section);
    }

    public void notifySectionChangedToVisible(Section section) {
        if (!section.isVisible()) {
            throw new IllegalStateException("This section is not visible.");
        }
        int sectionPosition = this.getSectionPosition(section);
        int sectionItemsTotal = section.getSectionItemsTotal();
        this.callSuperNotifyItemRangeInserted(sectionPosition, sectionItemsTotal);
    }

    public void notifySectionChangedToInvisible(String tag, int previousSectionPosition) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.notifySectionChangedToInvisible(section, previousSectionPosition);
    }

    public void notifySectionChangedToInvisible(Section section, int previousSectionPosition) {
        if (section.isVisible()) {
            throw new IllegalStateException("This section is not visible.");
        }
        int sectionItemsTotal = section.getSectionItemsTotal();
        this.callSuperNotifyItemRangeRemoved(previousSectionPosition, sectionItemsTotal);
    }

    @NonNull
    private Section getValidSectionOrThrowException(String tag) {
        Section section = this.getSection(tag);
        if (section == null) {
            throw new IllegalArgumentException("Invalid tag: " + tag);
        }
        return section;
    }

    public static class EmptyViewHolder
    extends RecyclerView.ViewHolder {
        public EmptyViewHolder(View itemView) {
            super(itemView);
        }
    }
}

