/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.base;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

public abstract class BaseDialogFragment
extends DialogFragment {
    protected String tag = ((Object)((Object)this)).getClass().getSimpleName();
    private static final float DEFAULT_DIMAMOUNT = 0.2f;

    protected abstract int getLayoutRes();

    protected abstract void bindView(View var1);

    public void onStart() {
        super.onStart();
        Window window = this.getDialog().getWindow();
        if (window != null) {
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.width = this.getDialogWidth() > 0 ? this.getDialogWidth() : -1;
            layoutParams.height = this.getDialogHeight() > 0 ? this.getDialogHeight() : -2;
            layoutParams.dimAmount = this.getDimAmount();
            layoutParams.gravity = this.getGravity();
            window.setAttributes(layoutParams);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.getDialog().requestWindowFeature(1);
        View view = null;
        if (this.getLayoutRes() > 0) {
            view = inflater.inflate(this.getLayoutRes(), container, false);
        }
        this.bindView(view);
        return view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Dialog dialog = this.getDialog();
        dialog.requestWindowFeature(1);
        dialog.setCanceledOnTouchOutside(this.isCancelableOutside());
        if (dialog.getWindow() != null && this.getDialogAnimationRes() > 0) {
            dialog.getWindow().setWindowAnimations(this.getDialogAnimationRes());
        }
        if (this.getOnKeyListener() != null) {
            dialog.setOnKeyListener(this.getOnKeyListener());
        }
    }

    protected DialogInterface.OnKeyListener getOnKeyListener() {
        return null;
    }

    public int getGravity() {
        return 80;
    }

    public int getDialogHeight() {
        return -2;
    }

    public int getDialogWidth() {
        return -1;
    }

    public float getDimAmount() {
        return 0.2f;
    }

    public String getFragmentTag() {
        return this.tag;
    }

    public void show(FragmentManager fragmentManager) {
        this.show(fragmentManager, this.getFragmentTag());
    }

    protected boolean isCancelableOutside() {
        return true;
    }

    protected int getDialogAnimationRes() {
        return 0;
    }

    public static final int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static final int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }
}

