/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils.image;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.aliyun.svideo.common.utils.image.AbstractImageLoader;
import com.aliyun.svideo.common.utils.image.AbstractImageLoaderTarget;
import com.aliyun.svideo.common.utils.image.GlideRoundedCornersTransform;
import com.aliyun.svideo.common.utils.image.ImageLoaderOptions;
import com.aliyun.svideo.common.utils.image.ImageLoaderRequestListener;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.BitmapTransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;

public class ImageLoaderImpl
extends AbstractImageLoader {
    private static final String TAG = ImageLoaderImpl.class.getSimpleName();
    private RequestBuilder mRequestBuilder;

    @Override
    public AbstractImageLoader loadImage(@NonNull Context context, @NonNull String url) {
        return this.loadImage(context, url, new ImageLoaderOptions.Builder().build());
    }

    @Override
    public AbstractImageLoader loadImage(@NonNull Context context, @NonNull int resId) {
        return this.loadImage(context, resId, new ImageLoaderOptions.Builder().build());
    }

    @Override
    public AbstractImageLoader loadImage(@NonNull Context context, @NonNull String url, @NonNull ImageLoaderOptions loaderOptions) {
        this.loadGlideResource(context, url, loaderOptions);
        return this;
    }

    @Override
    public AbstractImageLoader loadImage(@NonNull Context context, int resId, @NonNull ImageLoaderOptions loaderOptions) {
        this.loadGlideResource(context, resId, loaderOptions);
        return this;
    }

    private void loadGlideResource(@NonNull Context context, Object resource, @NonNull ImageLoaderOptions loaderOptions) {
        RequestBuilder requestBuilder;
        RequestManager requestManager;
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                Log.e((String)TAG, (String)"You cannot start a load for a destroyed activity");
                return;
            }
            requestManager = Glide.with((Activity)activity);
        } else {
            requestManager = Glide.with((Context)context);
        }
        if (loaderOptions.isAsBitmap()) {
            requestBuilder = requestManager.asBitmap().load(resource instanceof String ? (String)resource : (Integer)resource);
            if (loaderOptions.isCrossFade()) {
                requestBuilder = requestBuilder.transition((TransitionOptions)new BitmapTransitionOptions().crossFade());
            }
            this.loadGlideOption(context, requestBuilder, loaderOptions);
        } else {
            requestBuilder = requestManager.load(resource instanceof String ? (String)resource : (Integer)resource);
            if (loaderOptions.isCrossFade()) {
                requestBuilder = requestBuilder.transition((TransitionOptions)new DrawableTransitionOptions().crossFade());
            }
            this.loadGlideOption(context, requestBuilder, loaderOptions);
        }
    }

    @SuppressLint(value={"CheckResult"})
    private <R> void loadGlideOption(Context context, RequestBuilder<R> requestBuilder, ImageLoaderOptions loaderOptions) {
        this.mRequestBuilder = requestBuilder;
        RequestOptions requestOptions = RequestOptions.skipMemoryCacheOf((boolean)loaderOptions.isSkipMemoryCache());
        if (loaderOptions.getHolderDrawable() != null) {
            requestOptions = requestOptions.placeholder(loaderOptions.getHolderDrawable());
        }
        if (loaderOptions.getHolderDrawableId() != -1) {
            requestOptions = requestOptions.placeholder(loaderOptions.getHolderDrawableId());
        }
        if (loaderOptions.getErrorDrawableId() != -1) {
            requestOptions = requestOptions.error(loaderOptions.getErrorDrawableId());
        }
        if (loaderOptions.isCenterCrop()) {
            requestOptions = requestOptions.centerCrop();
        }
        if (loaderOptions.isCircle()) {
            requestOptions = requestOptions.optionalCircleCrop();
        }
        requestOptions = loaderOptions.isSkipDiskCacheCache() ? requestOptions.diskCacheStrategy(DiskCacheStrategy.NONE) : requestOptions.diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
        if (loaderOptions.getThumbnail() != 1.0f) {
            this.mRequestBuilder.thumbnail(loaderOptions.getThumbnail());
        }
        Point overridePoint = loaderOptions.getOverridePoint();
        if (overridePoint.x != 0 && overridePoint.y != 0) {
            requestOptions = requestOptions.override(overridePoint.x, overridePoint.y);
        }
        if (loaderOptions.isRoundCorner()) {
            requestOptions = requestOptions.transform((Transformation)new GlideRoundedCornersTransform(context, 4.0f, GlideRoundedCornersTransform.CornerType.ALL));
        }
        this.mRequestBuilder.apply(requestOptions);
    }

    @Override
    @SuppressLint(value={"CheckResult"})
    public <R> AbstractImageLoader listener(final @NonNull ImageLoaderRequestListener<R> listener) {
        this.mRequestBuilder.listener(new RequestListener<R>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<R> target, boolean isFirstResource) {
                String exceptionMsg = e == null ? "no msg" : e.getMessage();
                listener.onLoadFailed(exceptionMsg, isFirstResource);
                return false;
            }

            public boolean onResourceReady(R resource, Object model, Target<R> target, DataSource dataSource, boolean isFirstResource) {
                listener.onResourceReady(resource, isFirstResource);
                return false;
            }
        });
        return this;
    }

    @Override
    public void into(@NonNull ImageView imageView) {
        this.mRequestBuilder.into(imageView);
    }

    @Override
    public <T> void into(@NonNull View view, final @NonNull AbstractImageLoaderTarget<T> loaderTarget) {
        this.mRequestBuilder.into((Target)new CustomViewTarget<View, T>(view){

            public void onStart() {
                super.onStart();
                loaderTarget.onLoadStarted();
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                loaderTarget.onLoadFailed(errorDrawable);
            }

            public void onResourceReady(@NonNull T resource, @Nullable Transition<? super T> transition) {
                loaderTarget.onResourceReady(resource);
            }

            protected void onResourceCleared(@Nullable Drawable placeholder) {
                loaderTarget.onLoadCleared(placeholder);
            }
        });
    }

    @Override
    public void clear(@NonNull Context context, @NonNull ImageView imageView) {
        Glide.with((Context)context).clear((View)imageView);
    }
}

