/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.activity;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.sdk.android.oss.common.utils.DateUtil;
import com.aliyun.downloader.DownloaderConfig;
import com.aliyun.player.AliPlayer;
import com.aliyun.player.IPlayer;
import com.aliyun.player.VidPlayerConfigGen;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.dialogfragment.AlivcShareDialogFragment;
import com.aliyun.player.alivcplayerexpand.listener.OnScreenCostingSingleTagListener;
import com.aliyun.player.alivcplayerexpand.listener.OnStoppedListener;
import com.aliyun.player.alivcplayerexpand.listener.RefreshStsCallback;
import com.aliyun.player.alivcplayerexpand.playlist.AlivcVideoInfo;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.alivcplayerexpand.util.TimeFormater;
import com.aliyun.player.alivcplayerexpand.util.VidStsUtil;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadInfoListener;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadManager;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.choice.AlivcShowMoreDialog;
import com.aliyun.player.alivcplayerexpand.view.control.ControlView;
import com.aliyun.player.alivcplayerexpand.view.gesturedialog.BrightnessDialog;
import com.aliyun.player.alivcplayerexpand.view.more.AliyunShowMoreValue;
import com.aliyun.player.alivcplayerexpand.view.more.DanmakuSettingView;
import com.aliyun.player.alivcplayerexpand.view.more.ShowMoreView;
import com.aliyun.player.alivcplayerexpand.view.more.SpeedValue;
import com.aliyun.player.alivcplayerexpand.view.more.TrackInfoView;
import com.aliyun.player.alivcplayerexpand.view.quality.QualityItem;
import com.aliyun.player.alivcplayerexpand.view.softinput.SoftInputDialogFragment;
import com.aliyun.player.alivcplayerexpand.widget.AliyunVodPlayerView;
import com.aliyun.player.aliyunplayerbase.activity.BaseActivity;
import com.aliyun.player.aliyunplayerbase.bean.AliyunMps;
import com.aliyun.player.aliyunplayerbase.bean.AliyunPlayAuth;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.player.aliyunplayerbase.net.ServiceCommon;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.NetWatchdog;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;
import com.aliyun.player.aliyunplayerbase.view.tipsview.TipsView;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.bean.InfoBean;
import com.aliyun.player.bean.InfoCode;
import com.aliyun.player.nativeclass.CacheConfig;
import com.aliyun.player.nativeclass.MediaInfo;
import com.aliyun.player.nativeclass.PlayerConfig;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.player.source.Definition;
import com.aliyun.player.source.LiveSts;
import com.aliyun.player.source.StsInfo;
import com.aliyun.player.source.UrlSource;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidMps;
import com.aliyun.player.source.VidSts;
import com.aliyun.svideo.common.base.AlivcListSelectorDialogFragment;
import com.aliyun.svideo.common.okhttp.AlivcOkHttpClient;
import com.aliyun.svideo.common.utils.FastClickUtil;
import com.aliyun.svideo.common.utils.FileUtils;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.activity.AliyunPlayerDownloadListActivity;
import com.aliyun.vodplayerview.adapter.AliyunPlayerVideoListAdapter;
import com.aliyun.vodplayerview.global.Global;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import okhttp3.Request;

public class AliyunPlayerSkinActivity
extends BaseActivity {
    private static final String TAG = "AliyunPlayerSkinActivit";
    private AliyunScreenMode currentScreenMode = AliyunScreenMode.Small;
    private AliyunVodPlayerView mAliyunVodPlayerView = null;
    private com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorInfo currentError = com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorInfo.Normal;
    private boolean inRequest;
    private static String[] PERMISSIONS_STORAGE;
    private static final int REQUEST_EXTERNAL_STORAGE = 1;
    private int currentVidItemPosition;
    private AlivcShowMoreDialog danmakuShowMoreDialog;
    private AlivcShowMoreDialog showMoreDialog;
    private AlivcShowMoreDialog screenShowMoreDialog;
    private DanmakuSettingView mDanmakuSettingView;
    private AliyunDownloadManager mAliyunDownloadManager;
    private int mAlphProgress = 0;
    private int mRegionProgress = 0;
    private int mSpeedProgress = 30;
    private boolean mIsTimeExpired = false;
    private boolean mIsLoadDownloadInfo = false;
    private RecyclerView mPlayerListRecyclerView;
    private AliyunPlayerVideoListAdapter mAliyunPlayerVideoListAdapter;
    private ArrayList<AlivcVideoInfo.DataBean.VideoListBean> mVideoListBean;
    private ImageView mDownloadImageView;
    private ImageView mShareImageView;
    private MyDownloadInfoListener myDownloadInfoListener;
    private AlivcListSelectorDialogFragment mAlivcListSelectorDialogFragment;
    private SoftInputDialogFragment mSoftInputDialogFragment;
    private TextView mDownloadListTextView;
    private String mLocalVideoPath;
    private GlobalPlayerConfig.PLAYTYPE mCurrentPlayType = GlobalPlayerConfig.mCurrentPlayType;
    private ProgressBar mDownloadProgressBar;
    private String mCurrentVideoId;
    private boolean mNeedOnlyFullScreen;
    private int mCurrentBrightValue;
    private boolean mIsFromDownloadActivity;

    public static void startAliyunPlayerSkinActivityWithLocalVideo(Context context, String path) {
        Intent intent = new Intent(context, AliyunPlayerSkinActivity.class);
        intent.putExtra("local_video_path", path);
        intent.putExtra("need_only_full_screen", true);
        GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.URL;
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        if (!this.isStrangePhone()) {
            this.setTheme(R.style.NoActionTheme);
        }
        super.onCreate(savedInstanceState);
        this.restoreSaveInstance(savedInstanceState);
        this.getWindow().addFlags(8192);
        this.setManualBright();
        this.mCurrentBrightValue = this.getCurrentBrightValue();
        this.setContentView(R.layout.alivc_player_layout_skin);
        this.mLocalVideoPath = this.getIntent().getStringExtra("local_video_path");
        this.mNeedOnlyFullScreen = this.getIntent().getBooleanExtra("need_only_full_screen", false);
        this.initDownloadManager();
        this.initView();
        this.initAliyunPlayerView();
        this.initPlayerConfig();
        this.initDataSource();
        this.initVideoList();
        this.initListener();
    }

    private void initDownloadManager() {
        this.mAliyunDownloadManager = AliyunDownloadManager.getInstance((Context)this.getApplicationContext());
        DownloaderConfig downloaderConfig = new DownloaderConfig();
        downloaderConfig.mConnectTimeoutS = 3;
        downloaderConfig.mNetworkTimeoutMs = 5000L;
        this.mAliyunDownloadManager.setDownloaderConfig(downloaderConfig);
    }

    private void initView() {
        this.mShareImageView = (ImageView)this.findViewById(R.id.iv_share);
        this.mDownloadImageView = (ImageView)this.findViewById(R.id.iv_download);
        this.mAliyunVodPlayerView = (AliyunVodPlayerView)this.findViewById(R.id.video_view);
        this.mDownloadProgressBar = (ProgressBar)this.findViewById(R.id.download_progress);
        this.mDownloadListTextView = (TextView)this.findViewById(R.id.tv_download_list);
        this.mPlayerListRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerview_player_list);
        this.initSoftDialogFragment();
    }

    private void initSoftDialogFragment() {
        this.mSoftInputDialogFragment = SoftInputDialogFragment.newInstance();
        this.mSoftInputDialogFragment.setOnBarrageSendClickListener(new SoftInputDialogFragment.OnBarrageSendClickListener(){

            public void onBarrageSendClick(String danmu) {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setmDanmaku(danmu);
                    AliyunPlayerSkinActivity.this.mSoftInputDialogFragment.dismiss();
                }
            }
        });
    }

    private void initListener() {
        this.myDownloadInfoListener = new MyDownloadInfoListener(this);
        this.mAliyunDownloadManager.addDownloadInfoListener((AliyunDownloadInfoListener)this.myDownloadInfoListener);
        this.mDownloadImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean is4gConnected = NetWatchdog.is4GConnected((Context)AliyunPlayerSkinActivity.this.getApplicationContext());
                if (is4gConnected) {
                    Toast.makeText((Context)AliyunPlayerSkinActivity.this, (CharSequence)AliyunPlayerSkinActivity.this.getString(R.string.alivc_player_doawload_operator), (int)0).show();
                }
                if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL || GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS) {
                    Toast.makeText((Context)AliyunPlayerSkinActivity.this, (int)R.string.alivc_not_support_download, (int)0).show();
                    return;
                }
                if (!AliyunPlayerSkinActivity.this.mIsLoadDownloadInfo) {
                    AliyunPlayerSkinActivity.this.downloadVideo();
                }
                AliyunPlayerSkinActivity.this.mIsLoadDownloadInfo = true;
            }
        });
        this.mShareImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AlivcShareDialogFragment alivcVideoShareDialogFragment = AlivcShareDialogFragment.newInstance();
                alivcVideoShareDialogFragment.show(AliyunPlayerSkinActivity.this.getSupportFragmentManager(), "AlivcShareDialogFragment");
            }
        });
        this.mAliyunPlayerVideoListAdapter.setOnItemClickListener(new AliyunPlayerVideoListAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                AliyunPlayerSkinActivity.this.changePlaySource(position);
            }
        });
        this.mDownloadListTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (FastClickUtil.isFastClick()) {
                    return;
                }
                String downloadVid = "";
                if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
                    downloadVid = AliyunPlayerSkinActivity.this.mCurrentVideoId;
                } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS || GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
                    downloadVid = GlobalPlayerConfig.mVid;
                }
                if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mVid) && TextUtils.isEmpty((CharSequence)AliyunPlayerSkinActivity.this.mCurrentVideoId)) {
                    return;
                }
                if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS || GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
                    VidSts vidSts = AliyunPlayerSkinActivity.this.getVidSts(downloadVid);
                    AliyunPlayerSkinActivity.this.mAliyunDownloadManager.setmVidSts(vidSts);
                } else {
                    VidAuth vidAuth = AliyunPlayerSkinActivity.this.getVidAuth(downloadVid);
                    AliyunPlayerSkinActivity.this.mAliyunDownloadManager.setmVidAuth(vidAuth);
                }
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.onStop();
                }
                Intent intent = new Intent((Context)AliyunPlayerSkinActivity.this, AliyunPlayerDownloadListActivity.class);
                AliyunPlayerSkinActivity.this.startActivityForResult(intent, 1);
            }
        });
    }

    private void downloadVideo() {
        if (this.mAliyunDownloadManager == null) {
            return;
        }
        if (this.mDownloadProgressBar != null) {
            this.mDownloadProgressBar.setVisibility(0);
        }
        String downloadVid = "";
        if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
            downloadVid = this.mCurrentVideoId;
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS || GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
            downloadVid = GlobalPlayerConfig.mVid;
        }
        if (TextUtils.isEmpty((CharSequence)GlobalPlayerConfig.mVid) && TextUtils.isEmpty((CharSequence)this.mCurrentVideoId)) {
            return;
        }
        if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS || GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
            VidSts vidSts = this.getVidSts(downloadVid);
            this.mAliyunDownloadManager.setmVidSts(vidSts);
            this.mAliyunDownloadManager.prepareDownload(vidSts);
        } else {
            VidAuth vidAuth = this.getVidAuth(downloadVid);
            this.mAliyunDownloadManager.setmVidAuth(vidAuth);
            this.mAliyunDownloadManager.prepareDownload(vidAuth);
        }
    }

    private void initAliyunPlayerView() {
        this.mAliyunVodPlayerView.setKeepScreenOn(true);
        this.mAliyunVodPlayerView.setTheme(Theme.Blue);
        this.mAliyunVodPlayerView.setAutoPlay(true);
        this.mAliyunVodPlayerView.needOnlyFullScreenPlay(this.mNeedOnlyFullScreen);
        this.mAliyunVodPlayerView.setOnPreparedListener((IPlayer.OnPreparedListener)new MyPrepareListener(this));
        this.mAliyunVodPlayerView.setOnTrackReadyListener((IPlayer.OnTrackReadyListener)new MyOnTrackReadyListener(this));
        this.mAliyunVodPlayerView.setNetConnectedListener((AliyunVodPlayerView.NetConnectedListener)new MyNetConnectedListener(this));
        this.mAliyunVodPlayerView.setOnCompletionListener((IPlayer.OnCompletionListener)new MyCompletionListener(this));
        this.mAliyunVodPlayerView.setOnFirstFrameStartListener((IPlayer.OnRenderingStartListener)new MyFrameInfoListener(this));
        this.mAliyunVodPlayerView.setOnTrackChangedListener((IPlayer.OnTrackChangedListener)new MyOnTrackChangedListener(this));
        this.mAliyunVodPlayerView.setOnStoppedListener((OnStoppedListener)new MyStoppedListener(this));
        this.mAliyunVodPlayerView.setOrientationChangeListener((AliyunVodPlayerView.OnOrientationChangeListener)new MyOrientationChangeListener(this));
        this.mAliyunVodPlayerView.setOnTimeExpiredErrorListener((AliyunVodPlayerView.OnTimeExpiredErrorListener)new MyOnTimeExpiredErrorListener(this));
        this.mAliyunVodPlayerView.setOnShowMoreClickListener((ControlView.OnShowMoreClickListener)new MyShowMoreClickLisener(this));
        this.mAliyunVodPlayerView.setOnPlayStateBtnClickListener((AliyunVodPlayerView.OnPlayStateBtnClickListener)new MyPlayStateBtnClickListener(this));
        this.mAliyunVodPlayerView.setOnSeekCompleteListener((IPlayer.OnSeekCompleteListener)new MySeekCompleteListener(this));
        this.mAliyunVodPlayerView.setOnSeekStartListener((AliyunVodPlayerView.OnSeekStartListener)new MySeekStartListener(this));
        this.mAliyunVodPlayerView.setOnFinishListener((AliyunVodPlayerView.OnFinishListener)new MyOnFinishListener(this));
        this.mAliyunVodPlayerView.setOnScreenCostingSingleTagListener((OnScreenCostingSingleTagListener)new MyOnScreenCostingSingleTagListener(this));
        this.mAliyunVodPlayerView.setOnScreenBrightness((AliyunVodPlayerView.OnScreenBrightnessListener)new MyOnScreenBrightnessListener(this));
        this.mAliyunVodPlayerView.setSoftKeyHideListener((AliyunVodPlayerView.OnSoftKeyHideListener)new MyOnSoftKeyHideListener(this));
        this.mAliyunVodPlayerView.setOnErrorListener((IPlayer.OnErrorListener)new MyOnErrorListener(this));
        this.mAliyunVodPlayerView.setScreenBrightness(BrightnessDialog.getActivityBrightness((Activity)this));
        this.mAliyunVodPlayerView.setOnTrackInfoClickListener((ControlView.OnTrackInfoClickListener)new MyOnTrackInfoClickListener(this));
        this.mAliyunVodPlayerView.setOnInfoListener((IPlayer.OnInfoListener)new MyOnInfoListener(this));
        this.mAliyunVodPlayerView.setOutOnSeiDataListener((IPlayer.OnSeiDataListener)new MyOnSeiDataListener(this));
        this.mAliyunVodPlayerView.setOnTipClickListener((TipsView.OnTipClickListener)new MyOnTipClickListener(this));
        this.mAliyunVodPlayerView.setOnTipsViewBackClickListener((OnTipsViewBackClickListener)new MyOnTipsViewBackClickListener(this));
        this.mAliyunVodPlayerView.setOutOnVerifyTimeExpireCallback((AliPlayer.OnVerifyTimeExpireCallback)new MyOnVerifyStsCallback(this));
        this.mAliyunVodPlayerView.enableNativeLog();
        this.mAliyunVodPlayerView.setScreenBrightness(this.mCurrentBrightValue);
        this.mAliyunVodPlayerView.startNetWatch();
    }

    private void initVideoList() {
        this.initRecyclerView();
    }

    private void initRecyclerView() {
        LinearLayoutManager mLinearLayoutManager = new LinearLayoutManager((Context)this, 1, false);
        this.mPlayerListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)mLinearLayoutManager);
        this.mAliyunPlayerVideoListAdapter = new AliyunPlayerVideoListAdapter((Context)this);
        this.mPlayerListRecyclerView.setAdapter((RecyclerView.Adapter)this.mAliyunPlayerVideoListAdapter);
    }

    private void loadPlayList() {
        AlivcOkHttpClient.getInstance().get(ServiceCommon.GET_VIDEO_DEFAULT_LIST, new AlivcOkHttpClient.HttpCallBack(){

            public void onError(Request request, IOException e) {
                Toast.makeText((Context)AliyunPlayerSkinActivity.this, (CharSequence)e.getMessage(), (int)0).show();
            }

            public void onSuccess(Request request, String result) {
                Gson gson = new Gson();
                AlivcVideoInfo alivcVideoInfo = (AlivcVideoInfo)gson.fromJson(result, AlivcVideoInfo.class);
                if (alivcVideoInfo != null && alivcVideoInfo.getData() != null) {
                    AliyunPlayerSkinActivity.this.mVideoListBean = (ArrayList)alivcVideoInfo.getData().getVideoList();
                    if (AliyunPlayerSkinActivity.this.mAliyunPlayerVideoListAdapter != null) {
                        AliyunPlayerSkinActivity.this.mAliyunPlayerVideoListAdapter.setData(AliyunPlayerSkinActivity.this.mVideoListBean);
                        AliyunPlayerSkinActivity.this.mAliyunPlayerVideoListAdapter.notifyDataSetChanged();
                    }
                    if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT && AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                        AliyunPlayerSkinActivity.this.mCurrentVideoId = ((AlivcVideoInfo.DataBean.VideoListBean)AliyunPlayerSkinActivity.this.mVideoListBean.get(AliyunPlayerSkinActivity.this.currentVidItemPosition)).getVideoId();
                        VidSts vidSts = AliyunPlayerSkinActivity.this.getVidSts(AliyunPlayerSkinActivity.this.mCurrentVideoId);
                        AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setVidSts(vidSts);
                    }
                }
            }
        });
    }

    private void initDataSource() {
        GlobalPlayerConfig.PLAYTYPE mCurrentPlayType = GlobalPlayerConfig.mCurrentPlayType;
        if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
            VidAuth vidAuth = this.getVidAuth(GlobalPlayerConfig.mVid);
            this.mCurrentVideoId = GlobalPlayerConfig.mVid;
            this.mAliyunVodPlayerView.setAuthInfo(vidAuth);
        } else if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS) {
            VidSts vidSts = this.getVidSts(GlobalPlayerConfig.mVid);
            this.mCurrentVideoId = GlobalPlayerConfig.mVid;
            this.mAliyunVodPlayerView.setVidSts(vidSts);
        } else if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL) {
            UrlSource urlSource = new UrlSource();
            this.mCurrentVideoId = "";
            if (TextUtils.isEmpty((CharSequence)this.mLocalVideoPath)) {
                urlSource.setUri(GlobalPlayerConfig.mUrlPath);
            } else {
                urlSource.setUri(this.mLocalVideoPath);
            }
            this.mAliyunVodPlayerView.setLocalSource(urlSource);
        } else if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS) {
            VidMps vidMps = this.getVidMps(GlobalPlayerConfig.mVid);
            this.mCurrentVideoId = GlobalPlayerConfig.mVid;
            this.mAliyunVodPlayerView.setVidMps(vidMps);
        } else if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS) {
            LiveSts liveSts = this.getLiveSts(GlobalPlayerConfig.mLiveStsUrl);
            this.mAliyunVodPlayerView.setLiveStsDataSource(liveSts);
        } else {
            this.currentVidItemPosition = 0;
            this.loadPlayList();
        }
        if (mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS || mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH || mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.DEFAULT) {
            this.mDownloadImageView.setVisibility(0);
        } else {
            this.mDownloadImageView.setVisibility(8);
        }
    }

    private void initPlayerConfig() {
        if (this.mAliyunVodPlayerView != null) {
            this.mAliyunVodPlayerView.setEnableHardwareDecoder(GlobalPlayerConfig.mEnableHardDecodeType);
            this.mAliyunVodPlayerView.setRenderMirrorMode(GlobalPlayerConfig.mMirrorMode);
            this.mAliyunVodPlayerView.setRenderRotate(GlobalPlayerConfig.mRotateMode);
            this.mAliyunVodPlayerView.setDefaultBandWidth(GlobalPlayerConfig.mCurrentMutiRate.getValue());
            PlayerConfig playerConfig = this.mAliyunVodPlayerView.getPlayerConfig();
            playerConfig.mStartBufferDuration = GlobalPlayerConfig.PlayConfig.mStartBufferDuration;
            playerConfig.mHighBufferDuration = GlobalPlayerConfig.PlayConfig.mHighBufferDuration;
            playerConfig.mMaxBufferDuration = GlobalPlayerConfig.PlayConfig.mMaxBufferDuration;
            playerConfig.mMaxDelayTime = GlobalPlayerConfig.PlayConfig.mMaxDelayTime;
            playerConfig.mNetworkTimeout = GlobalPlayerConfig.PlayConfig.mNetworkTimeout;
            playerConfig.mMaxProbeSize = GlobalPlayerConfig.PlayConfig.mMaxProbeSize;
            playerConfig.mReferrer = GlobalPlayerConfig.PlayConfig.mReferrer;
            playerConfig.mHttpProxy = GlobalPlayerConfig.PlayConfig.mHttpProxy;
            playerConfig.mNetworkRetryCount = GlobalPlayerConfig.PlayConfig.mNetworkRetryCount;
            playerConfig.mEnableSEI = GlobalPlayerConfig.PlayConfig.mEnableSei;
            playerConfig.mClearFrameWhenStop = GlobalPlayerConfig.PlayConfig.mEnableClearWhenStop;
            this.mAliyunVodPlayerView.setPlayerConfig(playerConfig);
            this.initCacheConfig();
            Log.e((String)TAG, (String)("cache dir : " + GlobalPlayerConfig.PlayCacheConfig.mDir + " startBufferDuration = " + GlobalPlayerConfig.PlayConfig.mStartBufferDuration + " highBufferDuration = " + GlobalPlayerConfig.PlayConfig.mHighBufferDuration + " maxBufferDuration = " + GlobalPlayerConfig.PlayConfig.mMaxBufferDuration + " maxDelayTime = " + GlobalPlayerConfig.PlayConfig.mMaxDelayTime + " enableCache = " + GlobalPlayerConfig.PlayCacheConfig.mEnableCache + " --- mMaxDurationS = " + GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS + " --- mMaxSizeMB = " + GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB));
        }
    }

    private void initCacheConfig() {
        CacheConfig cacheConfig = new CacheConfig();
        GlobalPlayerConfig.PlayCacheConfig.mDir = FileUtils.getDir((Context)this) + GlobalPlayerConfig.CACHE_DIR_PATH;
        cacheConfig.mEnable = GlobalPlayerConfig.PlayCacheConfig.mEnableCache;
        cacheConfig.mDir = GlobalPlayerConfig.PlayCacheConfig.mDir;
        cacheConfig.mMaxDurationS = GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS;
        cacheConfig.mMaxSizeMB = GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB;
        this.mAliyunVodPlayerView.setCacheConfig(cacheConfig);
    }

    private void changePlaySource(int position) {
        this.currentVidItemPosition = position;
        AlivcVideoInfo.DataBean.VideoListBean videoListBean = this.mVideoListBean.get(position);
        this.changePlayVidSource(videoListBean);
    }

    private void changePlayLocalSource(String url, String title) {
        UrlSource urlSource = new UrlSource();
        urlSource.setUri(url);
        urlSource.setTitle(title);
        this.mAliyunVodPlayerView.setLocalSource(urlSource);
    }

    private void changePlayVidSource(AlivcVideoInfo.DataBean.VideoListBean videoListItem) {
        if (this.mAliyunVodPlayerView != null) {
            this.initCacheConfig();
            this.mCurrentVideoId = videoListItem.getVideoId();
            VidSts vidSts = this.getVidSts(this.mCurrentVideoId);
            this.mAliyunVodPlayerView.setVidSts(vidSts);
        }
    }

    private VidSts getVidSts(String vid) {
        VidSts vidSts = new VidSts();
        vidSts.setVid(vid);
        vidSts.setRegion(GlobalPlayerConfig.mRegion);
        vidSts.setAccessKeyId(GlobalPlayerConfig.mStsAccessKeyId);
        vidSts.setSecurityToken(GlobalPlayerConfig.mStsSecurityToken);
        vidSts.setAccessKeySecret(GlobalPlayerConfig.mStsAccessKeySecret);
        if (GlobalPlayerConfig.mPreviewTime > 0) {
            VidPlayerConfigGen configGen = new VidPlayerConfigGen();
            configGen.setPreviewTime(GlobalPlayerConfig.mPreviewTime);
            vidSts.setPlayConfig(configGen);
        }
        if (GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen) {
            ArrayList<Definition> list = new ArrayList<Definition>();
            list.add(Definition.DEFINITION_AUTO);
            vidSts.setDefinition(list);
        }
        return vidSts;
    }

    private VidAuth getVidAuth(String vid) {
        VidAuth vidAuth = new VidAuth();
        vidAuth.setVid(vid);
        vidAuth.setRegion(GlobalPlayerConfig.mRegion);
        vidAuth.setPlayAuth(GlobalPlayerConfig.mPlayAuth);
        if (GlobalPlayerConfig.mPreviewTime > 0) {
            VidPlayerConfigGen configGen = new VidPlayerConfigGen();
            configGen.setPreviewTime(GlobalPlayerConfig.mPreviewTime);
            vidAuth.setPlayConfig(configGen);
        }
        if (GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen) {
            ArrayList<Definition> list = new ArrayList<Definition>();
            list.add(Definition.DEFINITION_AUTO);
            vidAuth.setDefinition(list);
        }
        return vidAuth;
    }

    private LiveSts getLiveSts(String mUrlPath) {
        LiveSts liveSts = new LiveSts();
        liveSts.setUrl(mUrlPath);
        liveSts.setRegion(GlobalPlayerConfig.mRegion);
        liveSts.setAccessKeyId(GlobalPlayerConfig.mLiveStsAccessKeyId);
        liveSts.setAccessKeySecret(GlobalPlayerConfig.mLiveStsAccessKeySecret);
        liveSts.setSecurityToken(GlobalPlayerConfig.mLiveStsSecurityToken);
        liveSts.setDomain(GlobalPlayerConfig.mLiveStsDomain);
        liveSts.setApp(GlobalPlayerConfig.mLiveStsApp);
        liveSts.setStream(GlobalPlayerConfig.mLiveStsStream);
        return liveSts;
    }

    private VidMps getVidMps(String vid) {
        VidMps vidMps = new VidMps();
        vidMps.setMediaId(vid);
        vidMps.setRegion(GlobalPlayerConfig.mMpsRegion);
        vidMps.setAccessKeyId(GlobalPlayerConfig.mMpsAccessKeyId);
        vidMps.setAccessKeySecret(GlobalPlayerConfig.mMpsAccessKeySecret);
        vidMps.setSecurityToken(GlobalPlayerConfig.mMpsSecurityToken);
        vidMps.setAuthInfo(GlobalPlayerConfig.mMpsAuthInfo);
        vidMps.setHlsUriToken(GlobalPlayerConfig.mMpsHlsUriToken);
        if (GlobalPlayerConfig.mPreviewTime > 0) {
            VidPlayerConfigGen configGen = new VidPlayerConfigGen();
            configGen.setPreviewTime(GlobalPlayerConfig.mPreviewTime);
            vidMps.setPlayConfig(configGen);
        }
        if (GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen) {
            ArrayList<Definition> list = new ArrayList<Definition>();
            list.add(Definition.DEFINITION_AUTO);
            vidMps.setDefinition(list);
        }
        return vidMps;
    }

    private void onPrepared() {
        MediaInfo mediaInfo;
        Toast.makeText((Context)this, (int)R.string.toast_prepare_success, (int)0).show();
        if (this.mAliyunVodPlayerView != null && (mediaInfo = this.mAliyunVodPlayerView.getMediaInfo()) != null) {
            this.mCurrentVideoId = mediaInfo.getVideoId();
        }
    }

    private void onTrackReady(MediaInfo mediaInfo) {
        List trackInfos;
        long bitrate;
        if (mediaInfo != null && (bitrate = mediaInfo.getTotalBitrate()) == 0L && (trackInfos = mediaInfo.getTrackInfos()).size() > 0) {
            long l = ((TrackInfo)trackInfos.get((int)0)).videoBitrate;
        }
    }

    private void onCompletion() {
        Toast.makeText((Context)this, (int)R.string.toast_play_compleion, (int)0).show();
        this.hideAllDialog();
        if (GlobalPlayerConfig.mCurrentPlayType.equals((Object)GlobalPlayerConfig.PLAYTYPE.DEFAULT)) {
            this.onNext();
        } else if (this.mAliyunVodPlayerView != null) {
            this.mAliyunVodPlayerView.showReplay();
        }
    }

    private void hideAllDialog() {
        if (this.danmakuShowMoreDialog != null && this.danmakuShowMoreDialog.isShowing()) {
            this.danmakuShowMoreDialog.dismiss();
        }
        if (this.showMoreDialog != null && this.showMoreDialog.isShowing()) {
            this.showMoreDialog.dismiss();
        }
        if (this.screenShowMoreDialog != null && this.screenShowMoreDialog.isShowing()) {
            this.screenShowMoreDialog.dismiss();
        }
    }

    private void onNext() {
        AlivcVideoInfo.DataBean.VideoListBean videoListBean;
        if (this.currentError == com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorInfo.UnConnectInternet) {
            if (GlobalPlayerConfig.mCurrentPlayType.equals((Object)GlobalPlayerConfig.PLAYTYPE.STS)) {
                this.mAliyunVodPlayerView.showErrorTipView(4014, "-1", this.getResources().getString(R.string.alivc_net_disable));
            }
            return;
        }
        ++this.currentVidItemPosition;
        if (this.currentVidItemPosition > this.mVideoListBean.size() - 1) {
            this.currentVidItemPosition = 0;
        }
        if (this.mVideoListBean.size() > 0 && (videoListBean = this.mVideoListBean.get(this.currentVidItemPosition)) != null) {
            this.changePlayVidSource(videoListBean);
        }
    }

    private void onFirstFrameStart() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1) {
            if (grantResults[0] != 0) {
                Toast.makeText((Context)this, (CharSequence)(this.getResources().getString(R.string.alivc_sd_card_permission) + ""), (int)0).show();
            }
            return;
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void onDownloadPrepared(final List<AliyunDownloadMediaInfo> infos) {
        ArrayList<String> selectors = new ArrayList<String>();
        for (AliyunDownloadMediaInfo info : infos) {
            selectors.add(QualityItem.getItem((Context)this, (String)info.getQuality(), (boolean)false).getName());
        }
        this.mAlivcListSelectorDialogFragment = new AlivcListSelectorDialogFragment.Builder(this.getSupportFragmentManager()).setGravity(80).setCancelableOutside(true).setItemColor(ContextCompat.getColor((Context)this, (int)R.color.alivc_common_font_red_wine)).setUnItemColor(ContextCompat.getColor((Context)this, (int)R.color.alivc_common_font_black)).setNewData(selectors).setDialogAnimationRes(R.style.Dialog_Animation).setOnListItemSelectedListener(new AlivcListSelectorDialogFragment.OnListItemSelectedListener(){
            private File mFile;
            private String mPath;

            public void onClick(String position) {
                for (AliyunDownloadMediaInfo info : infos) {
                    if (!QualityItem.getItem((Context)AliyunPlayerSkinActivity.this, (String)info.getQuality(), (boolean)false).getName().equals(position)) continue;
                    if (Global.mDownloadMediaLists.contains(info)) {
                        AliyunDownloadMediaInfo aliyunDownloadMediaInfo = Global.mDownloadMediaLists.get(Global.mDownloadMediaLists.indexOf(info));
                        String savePath = aliyunDownloadMediaInfo.getSavePath();
                        this.mPath = TextUtils.isEmpty((CharSequence)savePath) ? "" : savePath;
                        this.mFile = new File(this.mPath);
                        if (this.mFile.exists()) {
                            Toast.makeText((Context)AliyunPlayerSkinActivity.this, (CharSequence)AliyunPlayerSkinActivity.this.getString(R.string.alivc_player_download_repeat_add), (int)0).show();
                            break;
                        }
                        AliyunPlayerSkinActivity.this.mAliyunDownloadManager.startDownload(info);
                        break;
                    }
                    AliyunPlayerSkinActivity.this.mAliyunDownloadManager.startDownload(info);
                    if (Global.mDownloadMediaLists.contains(info)) break;
                    Global.mDownloadMediaLists.add(0, info);
                    break;
                }
            }
        }).create().show();
        if (this.mDownloadProgressBar != null) {
            this.mDownloadProgressBar.setVisibility(8);
        }
        if (this.mAlivcListSelectorDialogFragment != null) {
            this.mAlivcListSelectorDialogFragment.setPosition(QualityItem.getItem((Context)this, (String)"", (boolean)false).getName());
        }
        this.mIsLoadDownloadInfo = false;
    }

    private void changeTrackFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
        if (this.showMoreDialog != null && this.showMoreDialog.isShowing()) {
            this.showMoreDialog.dismiss();
        }
        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alivc_player_track_change_error, new Object[]{errorInfo.getCode(), errorInfo.getMsg()}), (int)0).show();
    }

    private void changeTrackSuccess(TrackInfo trackInfo) {
        if (trackInfo == null) {
            return;
        }
        if (this.showMoreDialog != null && this.showMoreDialog.isShowing()) {
            this.showMoreDialog.dismiss();
        }
        if (trackInfo.getType() == TrackInfo.Type.TYPE_VIDEO) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alivc_player_track_bitrate_change_success, new Object[]{trackInfo.getVideoBitrate() + ""}), (int)0).show();
        } else if (trackInfo.getType() == TrackInfo.Type.TYPE_VOD) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alivc_player_track_definition_change_success, new Object[]{trackInfo.getVodDefinition()}), (int)0).show();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.alivc_player_track_change_success, new Object[]{trackInfo.getDescription()}), (int)0).show();
        }
    }

    private void onStopped() {
        Toast.makeText((Context)this, (int)R.string.log_play_stopped, (int)0).show();
    }

    protected void onResume() {
        super.onResume();
        this.updatePlayerViewMode();
        if (!GlobalPlayerConfig.PlayConfig.mEnablePlayBackground || this.mIsFromDownloadActivity) {
            if (this.mAliyunVodPlayerView != null) {
                this.mAliyunVodPlayerView.setAutoPlay(true);
                this.mAliyunVodPlayerView.onResume();
            }
            GlobalPlayerConfig.mCurrentPlayType = this.mCurrentPlayType;
        }
    }

    protected void onStop() {
        super.onStop();
        this.mIsFromDownloadActivity = false;
        if (!GlobalPlayerConfig.PlayConfig.mEnablePlayBackground) {
            if (this.mAliyunVodPlayerView != null) {
                this.mAliyunVodPlayerView.setAutoPlay(false);
                this.mAliyunVodPlayerView.onStop();
            }
            this.mCurrentPlayType = GlobalPlayerConfig.mCurrentPlayType;
        }
    }

    protected void onPause() {
        super.onPause();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updatePlayerViewMode();
    }

    private void updatePlayerViewMode() {
        if (this.mAliyunVodPlayerView != null) {
            int orientation = this.getResources().getConfiguration().orientation;
            if (this.mDownloadListTextView != null) {
                this.mDownloadListTextView.setVisibility(orientation == 1 ? 0 : 8);
            }
            if (orientation == 1) {
                this.getWindow().clearFlags(1024);
                this.mAliyunVodPlayerView.setSystemUiVisibility(0);
                RelativeLayout.LayoutParams aliVcVideoViewLayoutParams = (RelativeLayout.LayoutParams)this.mAliyunVodPlayerView.getLayoutParams();
                aliVcVideoViewLayoutParams.height = (int)((float)ScreenUtils.getWidth((Context)this) * 9.0f / 16.0f);
                aliVcVideoViewLayoutParams.width = -1;
            } else if (orientation == 2) {
                if (!this.isStrangePhone()) {
                    this.getWindow().setFlags(1024, 1024);
                    this.mAliyunVodPlayerView.setSystemUiVisibility(5894);
                }
                RelativeLayout.LayoutParams aliVcVideoViewLayoutParams = (RelativeLayout.LayoutParams)this.mAliyunVodPlayerView.getLayoutParams();
                aliVcVideoViewLayoutParams.height = -1;
                aliVcVideoViewLayoutParams.width = -1;
            }
        }
    }

    protected void onDestroy() {
        if (this.mAliyunVodPlayerView != null) {
            this.mAliyunVodPlayerView.onDestroy();
            this.mAliyunVodPlayerView = null;
        }
        if (this.mAliyunDownloadManager != null) {
            this.mAliyunDownloadManager.removeDownloadInfoListener((AliyunDownloadInfoListener)this.myDownloadInfoListener);
            this.myDownloadInfoListener = null;
        }
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean handler;
        if (this.mAliyunVodPlayerView != null && !(handler = this.mAliyunVodPlayerView.onKeyDown(keyCode, event))) {
            return false;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.updatePlayerViewMode();
    }

    private void screenCostingSingleTag() {
        if (this.screenShowMoreDialog != null && this.screenShowMoreDialog.isShowing()) {
            this.screenShowMoreDialog.dismiss();
        }
    }

    private void hideShowMoreDialog(boolean from, AliyunScreenMode currentMode) {
        if (this.showMoreDialog != null && currentMode == AliyunScreenMode.Small) {
            this.showMoreDialog.dismiss();
            this.currentScreenMode = currentMode;
        }
    }

    private void hideDanmakuSettingDialog(boolean fromUser, AliyunScreenMode currentMode) {
        if (this.danmakuShowMoreDialog != null && currentMode == AliyunScreenMode.Small) {
            this.danmakuShowMoreDialog.dismiss();
            this.currentScreenMode = currentMode;
        }
    }

    private void hideScreenSostDialog(boolean fromUser, AliyunScreenMode currentMode) {
        if (this.screenShowMoreDialog != null && currentMode == AliyunScreenMode.Small) {
            this.screenShowMoreDialog.dismiss();
            this.currentScreenMode = currentMode;
        }
    }

    private void hideDownloadDialog(boolean from, AliyunScreenMode currentMode) {
        if (this.mAlivcListSelectorDialogFragment != null && this.currentScreenMode != currentMode) {
            this.mAlivcListSelectorDialogFragment.dismiss();
            this.currentScreenMode = currentMode;
        }
        this.mDownloadListTextView.setVisibility(currentMode == AliyunScreenMode.Small ? 0 : 8);
    }

    private void onNetUnConnected() {
        this.currentError = com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorInfo.UnConnectInternet;
    }

    private void onReNetConnected(boolean isReconnect) {
        this.currentError = com.aliyun.player.aliyunplayerbase.view.tipsview.ErrorInfo.Normal;
    }

    private void onStsRetrySuccess(String mVid, String akid, String akSecret, String token) {
        GlobalPlayerConfig.mVid = mVid;
        GlobalPlayerConfig.mStsAccessKeyId = akid;
        GlobalPlayerConfig.mStsAccessKeySecret = akSecret;
        GlobalPlayerConfig.mStsSecurityToken = token;
        this.inRequest = false;
        this.mIsTimeExpired = false;
        VidSts vidSts = this.getVidSts(mVid);
        this.mAliyunVodPlayerView.setVidSts(vidSts);
    }

    private void onTimExpiredError() {
        VidStsUtil.getVidSts((String)GlobalPlayerConfig.mVid, (VidStsUtil.OnStsResultListener)new RetryExpiredSts(this));
    }

    private void showMore(AliyunPlayerSkinActivity activity) {
        this.showMoreDialog = new AlivcShowMoreDialog((Context)activity);
        AliyunShowMoreValue moreValue = new AliyunShowMoreValue();
        moreValue.setSpeed(this.mAliyunVodPlayerView.getCurrentSpeed());
        moreValue.setVolume((int)this.mAliyunVodPlayerView.getCurrentVolume());
        moreValue.setScaleMode(this.mAliyunVodPlayerView.getScaleMode());
        moreValue.setLoop(this.mAliyunVodPlayerView.isLoop());
        ShowMoreView showMoreView = new ShowMoreView((Context)activity, moreValue);
        this.showMoreDialog.setContentView((View)showMoreView);
        this.showMoreDialog.show();
        showMoreView.setOnScreenCastButtonClickListener(new ShowMoreView.OnScreenCastButtonClickListener(){

            public void onScreenCastClick() {
            }
        });
        showMoreView.setOnBarrageButtonClickListener(new ShowMoreView.OnBarrageButtonClickListener(){

            public void onBarrageClick() {
                if (AliyunPlayerSkinActivity.this.showMoreDialog != null && AliyunPlayerSkinActivity.this.showMoreDialog.isShowing()) {
                    AliyunPlayerSkinActivity.this.showMoreDialog.dismiss();
                }
                AliyunPlayerSkinActivity.this.showDanmakuSettingView();
            }
        });
        showMoreView.setOnSpeedCheckedChangedListener(new ShowMoreView.OnSpeedCheckedChangedListener(){

            public void onSpeedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.rb_speed_normal) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.changeSpeed(SpeedValue.One);
                } else if (checkedId == R.id.rb_speed_onequartern) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.changeSpeed(SpeedValue.OneQuartern);
                } else if (checkedId == R.id.rb_speed_onehalf) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.changeSpeed(SpeedValue.OneHalf);
                } else if (checkedId == R.id.rb_speed_twice) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.changeSpeed(SpeedValue.Twice);
                }
            }
        });
        showMoreView.setOnScaleModeCheckedChangedListener(new ShowMoreView.OnScaleModeCheckedChangedListener(){

            public void onScaleModeChanged(RadioGroup group, int checkedId) {
                IPlayer.ScaleMode mScaleMode = checkedId == R.id.rb_scale_aspect_fit ? IPlayer.ScaleMode.SCALE_ASPECT_FIT : (checkedId == R.id.rb_scale_aspect_fill ? IPlayer.ScaleMode.SCALE_ASPECT_FILL : (checkedId == R.id.rb_scale_to_fill ? IPlayer.ScaleMode.SCALE_TO_FILL : IPlayer.ScaleMode.SCALE_ASPECT_FIT));
                AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setScaleMode(mScaleMode);
            }
        });
        showMoreView.setOnLoopCheckedChangedListener(new ShowMoreView.OnLoopCheckedChangedListener(){

            public void onLoopChanged(RadioGroup group, int checkedId) {
                boolean isLoop = checkedId == R.id.rb_loop_open;
                AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setLoop(isLoop);
            }
        });
        if (this.mAliyunVodPlayerView != null) {
            showMoreView.setBrightness(this.mAliyunVodPlayerView.getScreenBrightness());
        }
        showMoreView.setOnLightSeekChangeListener(new ShowMoreView.OnLightSeekChangeListener(){

            public void onStart(SeekBar seekBar) {
            }

            public void onProgress(SeekBar seekBar, int progress, boolean fromUser) {
                AliyunPlayerSkinActivity.this.setWindowBrightness(progress);
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setScreenBrightness(progress);
                }
            }

            public void onStop(SeekBar seekBar) {
            }
        });
        if (this.mAliyunVodPlayerView != null) {
            showMoreView.setVoiceVolume(this.mAliyunVodPlayerView.getCurrentVolume());
        }
        showMoreView.setOnVoiceSeekChangeListener(new ShowMoreView.OnVoiceSeekChangeListener(){

            public void onStart(SeekBar seekBar) {
            }

            public void onProgress(SeekBar seekBar, int progress, boolean fromUser) {
                AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setCurrentVolume((float)progress / 100.0f);
            }

            public void onStop(SeekBar seekBar) {
            }
        });
    }

    private void showDanmakuSettingView() {
        this.danmakuShowMoreDialog = new AlivcShowMoreDialog((Context)this);
        this.mDanmakuSettingView = new DanmakuSettingView((Context)this);
        this.mDanmakuSettingView.setAlphaProgress(this.mAlphProgress);
        this.mDanmakuSettingView.setSpeedProgress(this.mSpeedProgress);
        this.mDanmakuSettingView.setRegionProgress(this.mRegionProgress);
        this.danmakuShowMoreDialog.setContentView((View)this.mDanmakuSettingView);
        this.danmakuShowMoreDialog.show();
        this.mDanmakuSettingView.setOnAlphaSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AliyunPlayerSkinActivity.this.mAlphProgress = progress;
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setDanmakuAlpha(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mDanmakuSettingView.setOnRegionSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AliyunPlayerSkinActivity.this.mRegionProgress = progress;
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setDanmakuRegion(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mDanmakuSettingView.setOnSpeedSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                AliyunPlayerSkinActivity.this.mSpeedProgress = progress;
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setDanmakuSpeed(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mDanmakuSettingView.setOnDefaultListener(new DanmakuSettingView.OnDefaultClickListener(){

            public void onDefaultClick() {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setDanmakuDefault();
                }
            }
        });
    }

    private String getUrlScheme(String url) {
        return Uri.parse((String)url).getScheme();
    }

    private void onPlayStateSwitch(int playerState) {
        if (playerState == 3 || playerState == 4) {
            // empty if block
        }
    }

    private void onSeekComplete() {
    }

    private void onSoftKeyShow() {
        if (this.mSoftInputDialogFragment != null) {
            this.mSoftInputDialogFragment.show(this.getSupportFragmentManager(), "SoftInputDialogFragment");
        }
    }

    private void onError(ErrorInfo errorInfo) {
        if (errorInfo.getCode().getValue() == ErrorCode.ERROR_SERVER_POP_UNKNOWN.getValue()) {
            this.mIsTimeExpired = true;
        }
    }

    private void onSubtitleClick(List<TrackInfo> subtitleTrackInfoList) {
        this.showMoreDialog = new AlivcShowMoreDialog((Context)this);
        TrackInfoView mTrackInfoView = new TrackInfoView((Context)this);
        mTrackInfoView.setTrackInfoLists(subtitleTrackInfoList);
        mTrackInfoView.setCurrentTrackInfo(this.mAliyunVodPlayerView.currentTrack(TrackInfo.Type.TYPE_SUBTITLE));
        this.showMoreDialog.setContentView((View)mTrackInfoView);
        this.showMoreDialog.show();
        mTrackInfoView.setOnSubtitleChangedListener(new TrackInfoView.OnSubtitleChangedListener(){

            public void onSubtitleChanged(TrackInfo selectTrackInfo) {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.selectTrack(selectTrackInfo);
                }
            }

            public void onSubtitleCancel() {
                Toast.makeText((Context)AliyunPlayerSkinActivity.this, (int)R.string.alivc_player_cancel_subtitle, (int)0).show();
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    // empty if block
                }
            }
        });
    }

    private void onAudioClick(List<TrackInfo> audioTrackInfoList) {
        this.showMoreDialog = new AlivcShowMoreDialog((Context)this);
        TrackInfoView mTrackInfoView = new TrackInfoView((Context)this);
        mTrackInfoView.setTrackInfoLists(audioTrackInfoList);
        mTrackInfoView.setCurrentTrackInfo(this.mAliyunVodPlayerView.currentTrack(TrackInfo.Type.TYPE_AUDIO));
        this.showMoreDialog.setContentView((View)mTrackInfoView);
        this.showMoreDialog.show();
        mTrackInfoView.setOnAudioChangedListener(new TrackInfoView.OnAudioChangedListener(){

            public void onAudioChanged(TrackInfo selectTrackInfo) {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.selectTrack(selectTrackInfo);
                }
            }
        });
    }

    private void onBitrateClick(List<TrackInfo> bitrateTrackInfoList) {
        this.showMoreDialog = new AlivcShowMoreDialog((Context)this);
        TrackInfoView mTrackInfoView = new TrackInfoView((Context)this);
        mTrackInfoView.setTrackInfoLists(bitrateTrackInfoList);
        mTrackInfoView.setCurrentTrackInfo(this.mAliyunVodPlayerView.currentTrack(TrackInfo.Type.TYPE_VIDEO));
        this.showMoreDialog.setContentView((View)mTrackInfoView);
        this.showMoreDialog.show();
        mTrackInfoView.setOnBitrateChangedListener(new TrackInfoView.OnBitrateChangedListener(){

            public void onBitrateChanged(TrackInfo selectTrackInfo, int checkedId) {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    if (checkedId == R.id.auto_bitrate) {
                        AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.selectAutoBitrateTrack();
                    } else {
                        AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.selectTrack(selectTrackInfo);
                    }
                }
            }
        });
    }

    private void onDefinitionClick(List<TrackInfo> definitionTrackInfoList) {
        this.showMoreDialog = new AlivcShowMoreDialog((Context)this);
        TrackInfoView mTrackInfoView = new TrackInfoView((Context)this);
        mTrackInfoView.setTrackInfoLists(definitionTrackInfoList);
        mTrackInfoView.setCurrentTrackInfo(this.mAliyunVodPlayerView.currentTrack(TrackInfo.Type.TYPE_VOD));
        this.showMoreDialog.setContentView((View)mTrackInfoView);
        this.showMoreDialog.show();
        mTrackInfoView.setOnDefinitionChangedListener(new TrackInfoView.OnDefinitionChangedListrener(){

            public void onDefinitionChanged(TrackInfo selectTrackInfo) {
                if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                    AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.selectTrack(selectTrackInfo);
                }
            }
        });
    }

    private void onInfo(InfoBean infoBean) {
        if (infoBean.getCode() == InfoCode.CacheSuccess) {
            Toast.makeText((Context)this, (int)R.string.alivc_player_cache_success, (int)0).show();
        } else if (infoBean.getCode() == InfoCode.CacheError) {
            Toast.makeText((Context)this, (CharSequence)infoBean.getExtraMsg(), (int)0).show();
        } else if (infoBean.getCode() == InfoCode.SwitchToSoftwareVideoDecoder) {
            Toast.makeText((Context)this, (int)R.string.alivc_player_switch_to_software_video_decoder, (int)0).show();
        }
    }

    private void onSeiData(int type, byte[] bytes) {
        Log.e((String)TAG, (String)("onSeiData: type = " + type + " data = " + new String(bytes)));
    }

    private void refresh(final boolean isDownload) {
        if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String errorMsg) {
                    ToastUtils.show((Context)AliyunPlayerSkinActivity.this, (String)errorMsg);
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mStsAccessKeyId = dataBean.getAccessKeyId();
                        GlobalPlayerConfig.mStsSecurityToken = dataBean.getSecurityToken();
                        GlobalPlayerConfig.mStsAccessKeySecret = dataBean.getAccessKeySecret();
                        VidSts vidSts = AliyunPlayerSkinActivity.this.getVidSts(AliyunPlayerSkinActivity.this.mCurrentVideoId);
                        if (isDownload) {
                            AliyunPlayerSkinActivity.this.mAliyunDownloadManager.setmVidSts(vidSts);
                            AliyunPlayerSkinActivity.this.mAliyunDownloadManager.prepareDownload(vidSts);
                        } else if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                            AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setVidSts(vidSts);
                        }
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayAuthInfo(new GetAuthInformation.OnGetPlayAuthInfoListener(){

                public void onGetPlayAuthError(String msg) {
                    ToastUtils.show((Context)AliyunPlayerSkinActivity.this, (String)msg);
                }

                public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mPlayAuth = dataBean.getPlayAuth();
                        VidAuth vidAuth = AliyunPlayerSkinActivity.this.getVidAuth(AliyunPlayerSkinActivity.this.mCurrentVideoId);
                        if (isDownload) {
                            AliyunPlayerSkinActivity.this.mAliyunDownloadManager.setmVidAuth(vidAuth);
                            AliyunPlayerSkinActivity.this.mAliyunDownloadManager.prepareDownload(vidAuth);
                        } else if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                            AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setAuthInfo(vidAuth);
                        }
                    }
                }
            });
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayMpsInfo(new GetAuthInformation.OnGetMpsInfoListener(){

                public void onGetMpsError(String msg) {
                    ToastUtils.show((Context)AliyunPlayerSkinActivity.this, (String)msg);
                }

                public void onGetMpsSuccess(AliyunMps.MpsBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mMpsRegion = dataBean.getRegionId();
                        GlobalPlayerConfig.mMpsAuthInfo = dataBean.getAuthInfo();
                        GlobalPlayerConfig.mMpsHlsUriToken = dataBean.getHlsUriToken();
                        GlobalPlayerConfig.mMpsAccessKeyId = dataBean.getAkInfo().getAccessKeyId();
                        GlobalPlayerConfig.mMpsSecurityToken = dataBean.getAkInfo().getSecurityToken();
                        GlobalPlayerConfig.mMpsAccessKeySecret = dataBean.getAkInfo().getAccessKeySecret();
                        VidMps vidMps = AliyunPlayerSkinActivity.this.getVidMps(AliyunPlayerSkinActivity.this.mCurrentVideoId);
                        if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                            AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.setVidMps(vidMps);
                        }
                    }
                }
            });
        } else if (this.mAliyunVodPlayerView != null) {
            this.mAliyunVodPlayerView.reTry();
        }
    }

    private void onTipsViewClick() {
        this.finish();
    }

    private AliPlayer.Status onVerifyAuth(final VidAuth vidAuth) {
        Log.e((String)TAG, (String)"onVerifyAuth: ");
        String mLiveExpiration = GlobalPlayerConfig.mLiveExpiration;
        long expirationInGMTFormat = TimeFormater.getExpirationInGMTFormat((String)mLiveExpiration);
        if (TextUtils.isEmpty((CharSequence)mLiveExpiration) || DateUtil.getFixedSkewedTimeMillis() / 1000L > expirationInGMTFormat - 300L) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayAuthInfo(new GetAuthInformation.OnGetPlayAuthInfoListener(){

                public void onGetPlayAuthError(String msg) {
                    if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                        AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.onStop();
                    }
                    ToastUtils.show((Context)AliyunPlayerSkinActivity.this, (String)("Get Auth Info error : " + msg));
                }

                public void onGetPlayAuthSuccess(AliyunPlayAuth.PlayAuthBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mLivePlayAuth = dataBean.getPlayAuth();
                        if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                            vidAuth.setPlayAuth(GlobalPlayerConfig.mLivePlayAuth);
                            AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.updateAuthInfo(vidAuth);
                        }
                    }
                }
            });
            Log.e((String)TAG, (String)"refreshAuth: ");
            return AliPlayer.Status.Pending;
        }
        Log.e((String)TAG, (String)"IPlayer.AuthStatus.Valid: ");
        return AliPlayer.Status.Valid;
    }

    private AliPlayer.Status onVerifySts(final StsInfo stsInfo) {
        Log.e((String)TAG, (String)"onVerifySts: ");
        String mLiveExpiration = GlobalPlayerConfig.mLiveExpiration;
        long expirationInGMTFormat = TimeFormater.getExpirationInGMTFormat((String)mLiveExpiration);
        if ((TextUtils.isEmpty((CharSequence)mLiveExpiration) || DateUtil.getFixedSkewedTimeMillis() / 1000L > expirationInGMTFormat - 300L) && GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS) {
            GetAuthInformation getAuthInformation = new GetAuthInformation();
            getAuthInformation.getVideoPlayLiveStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

                public void onGetStsError(String msg) {
                    if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                        AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.onStop();
                    }
                    ToastUtils.show((Context)AliyunPlayerSkinActivity.this, (String)("Get Sts Info error : " + msg));
                }

                public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                    if (dataBean != null) {
                        GlobalPlayerConfig.mLiveStsAccessKeyId = dataBean.getAccessKeyId();
                        GlobalPlayerConfig.mLiveStsSecurityToken = dataBean.getSecurityToken();
                        GlobalPlayerConfig.mLiveStsAccessKeySecret = dataBean.getAccessKeySecret();
                        GlobalPlayerConfig.mLiveExpiration = dataBean.getExpiration();
                        if (AliyunPlayerSkinActivity.this.mAliyunVodPlayerView != null) {
                            stsInfo.setAccessKeyId(GlobalPlayerConfig.mLiveStsAccessKeyId);
                            stsInfo.setAccessKeySecret(GlobalPlayerConfig.mLiveStsAccessKeySecret);
                            stsInfo.setSecurityToken(GlobalPlayerConfig.mLiveStsSecurityToken);
                            AliyunPlayerSkinActivity.this.mAliyunVodPlayerView.updateStsInfo(stsInfo);
                        }
                    }
                }
            });
            Log.e((String)TAG, (String)"refreshSts: ");
            return AliPlayer.Status.Pending;
        }
        Log.e((String)TAG, (String)"IPlayer.StsStatus.Valid: ");
        return AliPlayer.Status.Valid;
    }

    private void hideSoftKeyBoard(Activity activity) {
        View view = activity.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }

    private void onSeekStart(int position) {
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event == null || event.getKeyCode() == 67) {
            // empty if block
        }
        return super.dispatchKeyEvent(event);
    }

    private void setWindowBrightness(int brightness) {
        Window window = this.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.screenBrightness = (float)brightness / 100.0f;
        window.setAttributes(lp);
    }

    private int getCurrentBrightValue() {
        int nowBrightnessValue = 0;
        ContentResolver resolver = this.getContentResolver();
        try {
            nowBrightnessValue = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness", (int)255);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nowBrightnessValue;
    }

    public void setManualBright() {
        try {
            Settings.System.putInt((ContentResolver)this.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            this.mIsFromDownloadActivity = true;
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("mCurrentPlayType", this.mCurrentPlayType.ordinal());
        if (this.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
            outState.putString("mVid", GlobalPlayerConfig.mVid);
            outState.putString("mRegion", GlobalPlayerConfig.mRegion);
            outState.putString("mPlayAuth", GlobalPlayerConfig.mPlayAuth);
            outState.putInt("mPreviewTime", GlobalPlayerConfig.mPreviewTime);
        } else if (this.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS) {
            outState.putString("mVid", GlobalPlayerConfig.mVid);
            outState.putString("mRegion", GlobalPlayerConfig.mRegion);
            outState.putString("mStsAccessKeyId", GlobalPlayerConfig.mStsAccessKeyId);
            outState.putString("mStsAccessKeySecret", GlobalPlayerConfig.mStsAccessKeySecret);
            outState.putString("mStsSecurityToken", GlobalPlayerConfig.mStsSecurityToken);
            outState.putInt("mPreviewTime", GlobalPlayerConfig.mPreviewTime);
        } else if (this.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS) {
            outState.putString("mVid", GlobalPlayerConfig.mVid);
            outState.putString("mRegion", GlobalPlayerConfig.mRegion);
            outState.putString("mMpsAccessKeyId", GlobalPlayerConfig.mMpsAccessKeyId);
            outState.putString("mMpsAccessKeySecret", GlobalPlayerConfig.mMpsAccessKeySecret);
            outState.putString("mMpsSecurityToken", GlobalPlayerConfig.mMpsSecurityToken);
            outState.putString("mMpsHlsUriToken", GlobalPlayerConfig.mMpsHlsUriToken);
            outState.putString("mMpsAuthInfo", GlobalPlayerConfig.mMpsAuthInfo);
            outState.putInt("mPreviewTime", GlobalPlayerConfig.mPreviewTime);
        } else if (this.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS) {
            outState.putString("mLiveStsUrl", GlobalPlayerConfig.mLiveStsUrl);
            outState.putString("mRegion", GlobalPlayerConfig.mRegion);
            outState.putString("mLiveStsAccessKeyId", GlobalPlayerConfig.mLiveStsAccessKeyId);
            outState.putString("mLiveStsAccessKeySecret", GlobalPlayerConfig.mLiveStsAccessKeySecret);
            outState.putString("mLiveStsSecurityToken", GlobalPlayerConfig.mLiveStsSecurityToken);
            outState.putString("mLiveStsDomain", GlobalPlayerConfig.mLiveStsDomain);
            outState.putString("mLiveStsApp", GlobalPlayerConfig.mLiveStsApp);
            outState.putString("mLiveStsStream", GlobalPlayerConfig.mLiveStsStream);
        } else if (this.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL) {
            outState.putString("mUrlPath", GlobalPlayerConfig.mUrlPath);
        } else {
            outState.putString("mVid", GlobalPlayerConfig.mVid);
            outState.putString("mRegion", GlobalPlayerConfig.mRegion);
            outState.putString("mStsAccessKeyId", GlobalPlayerConfig.mStsAccessKeyId);
            outState.putString("mStsAccessKeySecret", GlobalPlayerConfig.mStsAccessKeySecret);
            outState.putString("mStsSecurityToken", GlobalPlayerConfig.mStsSecurityToken);
        }
        outState.putInt("mStartBufferDuration", GlobalPlayerConfig.PlayConfig.mStartBufferDuration);
        outState.putInt("mHighBufferDuration", GlobalPlayerConfig.PlayConfig.mHighBufferDuration);
        outState.putInt("mMaxBufferDuration", GlobalPlayerConfig.PlayConfig.mMaxBufferDuration);
        outState.putInt("mMaxDelayTime", GlobalPlayerConfig.PlayConfig.mMaxDelayTime);
        outState.putInt("mMaxProbeSize", GlobalPlayerConfig.PlayConfig.mMaxProbeSize);
        outState.putString("mReferrer", GlobalPlayerConfig.PlayConfig.mReferrer);
        outState.putString("mHttpProxy", GlobalPlayerConfig.PlayConfig.mHttpProxy);
        outState.putInt("mNetworkTimeout", GlobalPlayerConfig.PlayConfig.mNetworkTimeout);
        outState.putInt("mNetworkRetryCount", GlobalPlayerConfig.PlayConfig.mNetworkRetryCount);
        outState.putBoolean("mEnableSei", GlobalPlayerConfig.PlayConfig.mEnableSei);
        outState.putBoolean("mEnableClearWhenStop", GlobalPlayerConfig.PlayConfig.mEnableClearWhenStop);
        outState.putBoolean("mAutoSwitchOpen", GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen);
        outState.putBoolean("mEnableAccurateSeekModule", GlobalPlayerConfig.PlayConfig.mEnableAccurateSeekModule);
        outState.putBoolean("mEnablePlayBackground", GlobalPlayerConfig.PlayConfig.mEnablePlayBackground);
        outState.putBoolean("mEnableHardDecodeType", GlobalPlayerConfig.mEnableHardDecodeType);
        outState.putBoolean("mEnableCache", GlobalPlayerConfig.PlayCacheConfig.mEnableCache);
        outState.putString("mDir", GlobalPlayerConfig.PlayCacheConfig.mDir);
        outState.putInt("mMaxDurationS", GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS);
        outState.putInt("mMaxSizeMB", GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB);
    }

    private void restoreSaveInstance(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            int mPlayType = savedInstanceState.getInt("mCurrentPlayType");
            int authType = GlobalPlayerConfig.PLAYTYPE.AUTH.ordinal();
            int stsType = GlobalPlayerConfig.PLAYTYPE.STS.ordinal();
            int mpsType = GlobalPlayerConfig.PLAYTYPE.MPS.ordinal();
            int urlType = GlobalPlayerConfig.PLAYTYPE.URL.ordinal();
            int liveStsType = GlobalPlayerConfig.PLAYTYPE.LIVE_STS.ordinal();
            if (mPlayType == authType) {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.AUTH;
                GlobalPlayerConfig.mVid = savedInstanceState.getString("mVid");
                GlobalPlayerConfig.mRegion = savedInstanceState.getString("mRegion");
                GlobalPlayerConfig.mPlayAuth = savedInstanceState.getString("mPlayAuth");
                GlobalPlayerConfig.mPreviewTime = savedInstanceState.getInt("mPreviewTime");
            } else if (mPlayType == stsType) {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.STS;
                GlobalPlayerConfig.mVid = savedInstanceState.getString("mVid");
                GlobalPlayerConfig.mRegion = savedInstanceState.getString("mRegion");
                GlobalPlayerConfig.mStsAccessKeyId = savedInstanceState.getString("mStsAccessKeyId");
                GlobalPlayerConfig.mStsAccessKeySecret = savedInstanceState.getString("mStsAccessKeySecret");
                GlobalPlayerConfig.mStsSecurityToken = savedInstanceState.getString("mStsSecurityToken");
                GlobalPlayerConfig.mPreviewTime = savedInstanceState.getInt("mPreviewTime");
            } else if (mPlayType == mpsType) {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.MPS;
                GlobalPlayerConfig.mVid = savedInstanceState.getString("mVid");
                GlobalPlayerConfig.mRegion = savedInstanceState.getString("mRegion");
                GlobalPlayerConfig.mMpsAccessKeyId = savedInstanceState.getString("mMpsAccessKeyId");
                GlobalPlayerConfig.mMpsAccessKeySecret = savedInstanceState.getString("mMpsAccessKeySecret");
                GlobalPlayerConfig.mMpsSecurityToken = savedInstanceState.getString("mMpsSecurityToken");
                GlobalPlayerConfig.mMpsHlsUriToken = savedInstanceState.getString("mMpsHlsUriToken");
                GlobalPlayerConfig.mMpsAuthInfo = savedInstanceState.getString("mMpsAuthInfo");
                GlobalPlayerConfig.mPreviewTime = savedInstanceState.getInt("mPreviewTime");
            } else if (mPlayType == urlType) {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.URL;
                GlobalPlayerConfig.mUrlPath = savedInstanceState.getString("mUrlPath");
            } else if (mPlayType == liveStsType) {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.LIVE_STS;
                GlobalPlayerConfig.mLiveStsUrl = savedInstanceState.getString("mLiveStsUrl");
                GlobalPlayerConfig.mRegion = savedInstanceState.getString("mRegion");
                GlobalPlayerConfig.mLiveStsAccessKeyId = savedInstanceState.getString("mLiveStsAccessKeyId");
                GlobalPlayerConfig.mLiveStsAccessKeySecret = savedInstanceState.getString("mLiveStsAccessKeySecret");
                GlobalPlayerConfig.mLiveStsSecurityToken = savedInstanceState.getString("mLiveStsSecurityToken");
                GlobalPlayerConfig.mLiveStsDomain = savedInstanceState.getString("mLiveStsDomain");
                GlobalPlayerConfig.mLiveStsApp = savedInstanceState.getString("mLiveStsApp");
                GlobalPlayerConfig.mLiveStsStream = savedInstanceState.getString("mLiveStsStream");
            } else {
                this.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.DEFAULT;
                GlobalPlayerConfig.mVid = savedInstanceState.getString("mVid");
                GlobalPlayerConfig.mRegion = savedInstanceState.getString("mRegion");
                GlobalPlayerConfig.mStsAccessKeyId = savedInstanceState.getString("mStsAccessKeyId");
                GlobalPlayerConfig.mStsAccessKeySecret = savedInstanceState.getString("mStsAccessKeySecret");
                GlobalPlayerConfig.mStsSecurityToken = savedInstanceState.getString("mStsSecurityToken");
            }
            GlobalPlayerConfig.mCurrentPlayType = this.mCurrentPlayType;
            GlobalPlayerConfig.PlayConfig.mStartBufferDuration = savedInstanceState.getInt("mStartBufferDuration");
            GlobalPlayerConfig.PlayConfig.mHighBufferDuration = savedInstanceState.getInt("mHighBufferDuration");
            GlobalPlayerConfig.PlayConfig.mMaxBufferDuration = savedInstanceState.getInt("mMaxBufferDuration");
            GlobalPlayerConfig.PlayConfig.mMaxDelayTime = savedInstanceState.getInt("mMaxDelayTime");
            GlobalPlayerConfig.PlayConfig.mMaxProbeSize = savedInstanceState.getInt("mMaxProbeSize");
            GlobalPlayerConfig.PlayConfig.mReferrer = savedInstanceState.getString("mReferrer");
            GlobalPlayerConfig.PlayConfig.mHttpProxy = savedInstanceState.getString("mHttpProxy");
            GlobalPlayerConfig.PlayConfig.mNetworkTimeout = savedInstanceState.getInt("mNetworkTimeout");
            GlobalPlayerConfig.PlayConfig.mNetworkRetryCount = savedInstanceState.getInt("mNetworkRetryCount");
            GlobalPlayerConfig.PlayConfig.mEnableSei = savedInstanceState.getBoolean("mEnableSei");
            GlobalPlayerConfig.PlayConfig.mEnableClearWhenStop = savedInstanceState.getBoolean("mEnableClearWhenStop");
            GlobalPlayerConfig.PlayConfig.mAutoSwitchOpen = savedInstanceState.getBoolean("mAutoSwitchOpen");
            GlobalPlayerConfig.PlayConfig.mEnableAccurateSeekModule = savedInstanceState.getBoolean("mEnableAccurateSeekModule");
            GlobalPlayerConfig.PlayConfig.mEnablePlayBackground = savedInstanceState.getBoolean("mEnablePlayBackground");
            GlobalPlayerConfig.PlayCacheConfig.mEnableCache = savedInstanceState.getBoolean("mEnableCache");
            GlobalPlayerConfig.PlayCacheConfig.mDir = savedInstanceState.getString("mDir");
            GlobalPlayerConfig.PlayCacheConfig.mMaxDurationS = savedInstanceState.getInt("mMaxDurationS");
            GlobalPlayerConfig.PlayCacheConfig.mMaxSizeMB = savedInstanceState.getInt("mMaxSizeMB");
            GlobalPlayerConfig.mEnableHardDecodeType = savedInstanceState.getBoolean("mEnableHardDecodeType");
        }
    }

    static {
        System.loadLibrary("RtsSDK");
        PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    private static class MyOnVerifyStsCallback
    implements AliPlayer.OnVerifyTimeExpireCallback {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnVerifyStsCallback(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public AliPlayer.Status onVerifySts(StsInfo stsInfo) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                return aliyunPlayerSkinActivity.onVerifySts(stsInfo);
            }
            return AliPlayer.Status.Valid;
        }

        public AliPlayer.Status onVerifyAuth(VidAuth vidAuth) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                return aliyunPlayerSkinActivity.onVerifyAuth(vidAuth);
            }
            return AliPlayer.Status.Valid;
        }
    }

    private static class MyOnTipsViewBackClickListener
    implements OnTipsViewBackClickListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTipsViewBackClickListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onBackClick() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onTipsViewClick();
            }
        }
    }

    private static class MyOnTipClickListener
    implements TipsView.OnTipClickListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTipClickListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onContinuePlay() {
        }

        public void onStopPlay() {
        }

        public void onRetryPlay(int errorCode) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                if (errorCode == ErrorCode.ERROR_LOADING_TIMEOUT.getValue()) {
                    aliyunPlayerSkinActivity.mAliyunVodPlayerView.reTry();
                } else {
                    aliyunPlayerSkinActivity.refresh(false);
                }
            }
        }

        public void onReplay() {
        }

        public void onRefreshSts() {
        }

        public void onWait() {
        }

        public void onExit() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.finish();
            }
        }
    }

    private static class MyOnSeiDataListener
    implements IPlayer.OnSeiDataListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnSeiDataListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onSeiData(int type, byte[] bytes) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onSeiData(type, bytes);
            }
        }
    }

    private static class MyOnInfoListener
    implements IPlayer.OnInfoListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnInfoListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onInfo(InfoBean infoBean) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onInfo(infoBean);
            }
        }
    }

    private static class MyOnTrackInfoClickListener
    implements ControlView.OnTrackInfoClickListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTrackInfoClickListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onSubtitleClick(List<TrackInfo> subtitleTrackInfoList) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onSubtitleClick(subtitleTrackInfoList);
            }
        }

        public void onAudioClick(List<TrackInfo> audioTrackInfoList) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onAudioClick(audioTrackInfoList);
            }
        }

        public void onBitrateClick(List<TrackInfo> bitrateTrackInfoList) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onBitrateClick(bitrateTrackInfoList);
            }
        }

        public void onDefinitionClick(List<TrackInfo> definitionTrackInfoList) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onDefinitionClick(definitionTrackInfoList);
            }
        }
    }

    private static class MyOnErrorListener
    implements IPlayer.OnErrorListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnErrorListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onError(ErrorInfo errorInfo) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onError(errorInfo);
            }
        }
    }

    private static class MyOnSoftKeyHideListener
    implements AliyunVodPlayerView.OnSoftKeyHideListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnSoftKeyHideListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void softKeyHide() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.hideSoftKeyBoard((Activity)aliyunPlayerSkinActivity);
            }
        }

        public void onClickPaint() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onSoftKeyShow();
            }
        }
    }

    private static class MyOnScreenBrightnessListener
    implements AliyunVodPlayerView.OnScreenBrightnessListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnScreenBrightnessListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onScreenBrightness(int brightness) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.setWindowBrightness(brightness);
                if (aliyunPlayerSkinActivity.mAliyunVodPlayerView != null) {
                    aliyunPlayerSkinActivity.mAliyunVodPlayerView.setScreenBrightness(brightness);
                }
            }
        }
    }

    private static class MyOnFinishListener
    implements AliyunVodPlayerView.OnFinishListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnFinishListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onFinishClick() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.finish();
            }
        }
    }

    private static class MySeekStartListener
    implements AliyunVodPlayerView.OnSeekStartListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        MySeekStartListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onSeekStart(int position) {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onSeekStart(position);
            }
        }
    }

    private static class MySeekCompleteListener
    implements IPlayer.OnSeekCompleteListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        MySeekCompleteListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onSeekComplete() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onSeekComplete();
            }
        }
    }

    private static class MyPlayStateBtnClickListener
    implements AliyunVodPlayerView.OnPlayStateBtnClickListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        MyPlayStateBtnClickListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onPlayBtnClick(int playerState) {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onPlayStateSwitch(playerState);
            }
        }
    }

    private static class MyShowMoreClickLisener
    implements ControlView.OnShowMoreClickListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        MyShowMoreClickLisener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void showMore() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                if (FastClickUtil.isFastClick()) {
                    return;
                }
                activity.showMore(activity);
            }
        }
    }

    public static class MyOnTimeExpiredErrorListener
    implements AliyunVodPlayerView.OnTimeExpiredErrorListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTimeExpiredErrorListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onTimeExpiredError() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onTimExpiredError();
            }
        }
    }

    private static class RetryExpiredSts
    implements VidStsUtil.OnStsResultListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public RetryExpiredSts(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onSuccess(String vid, String akid, String akSecret, String token) {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onStsRetrySuccess(vid, akid, akSecret, token);
            }
        }

        public void onFail() {
        }
    }

    private class MyNetConnectedListener
    implements AliyunVodPlayerView.NetConnectedListener {
        WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyNetConnectedListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onReNetConnected(boolean isReconnect) {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onReNetConnected(isReconnect);
            }
        }

        public void onNetUnConnected() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                activity.onNetUnConnected();
            }
        }
    }

    private static class MyOrientationChangeListener
    implements AliyunVodPlayerView.OnOrientationChangeListener {
        private final WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOrientationChangeListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void orientationChange(boolean from, AliyunScreenMode currentMode) {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (activity != null) {
                if (currentMode == AliyunScreenMode.Small && GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.URL && !TextUtils.isEmpty((CharSequence)activity.mLocalVideoPath)) {
                    activity.finish();
                } else {
                    activity.hideDownloadDialog(from, currentMode);
                    activity.hideShowMoreDialog(from, currentMode);
                    activity.hideDanmakuSettingDialog(from, currentMode);
                    activity.hideScreenSostDialog(from, currentMode);
                }
            }
        }
    }

    private static class MyOnScreenCostingSingleTagListener
    implements OnScreenCostingSingleTagListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        private MyOnScreenCostingSingleTagListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onScreenCostingSingleTag() {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.screenCostingSingleTag();
            }
        }
    }

    private static class MyRefreshStsCallback
    implements RefreshStsCallback {
        private MyRefreshStsCallback() {
        }

        public VidSts refreshSts(String vid, String quality, String format, String title, boolean encript) {
            VidSts vidSts = VidStsUtil.getVidSts((String)vid);
            if (vidSts == null) {
                return null;
            }
            vidSts.setVid(vid);
            vidSts.setQuality(quality, true);
            vidSts.setTitle(title);
            return vidSts;
        }
    }

    private static class MyStoppedListener
    implements OnStoppedListener {
        private WeakReference<AliyunPlayerSkinActivity> activityWeakReference;

        public MyStoppedListener(AliyunPlayerSkinActivity skinActivity) {
            this.activityWeakReference = new WeakReference<AliyunPlayerSkinActivity>(skinActivity);
        }

        public void onStop() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.activityWeakReference.get());
            if (activity != null) {
                activity.onStopped();
            }
        }
    }

    private static class MyOnTrackChangedListener
    implements IPlayer.OnTrackChangedListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTrackChangedListener(AliyunPlayerSkinActivity activity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(activity);
        }

        public void onChangedSuccess(TrackInfo trackInfo) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.changeTrackSuccess(trackInfo);
            }
        }

        public void onChangedFail(TrackInfo trackInfo, ErrorInfo errorInfo) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.changeTrackFail(trackInfo, errorInfo);
            }
        }
    }

    private static class MyDownloadInfoListener
    implements AliyunDownloadInfoListener {
        private WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyDownloadInfoListener(AliyunPlayerSkinActivity aliyunPlayerSkinActivity) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(aliyunPlayerSkinActivity);
        }

        public void onPrepared(List<AliyunDownloadMediaInfo> infos) {
            Collections.sort(infos, new Comparator<AliyunDownloadMediaInfo>(){

                @Override
                public int compare(AliyunDownloadMediaInfo mediaInfo1, AliyunDownloadMediaInfo mediaInfo2) {
                    if (mediaInfo1.getSize() > mediaInfo2.getSize()) {
                        return 1;
                    }
                    if (mediaInfo1.getSize() < mediaInfo2.getSize()) {
                        return -1;
                    }
                    if (mediaInfo1.getSize() == mediaInfo2.getSize()) {
                        return 0;
                    }
                    return 0;
                }
            });
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onDownloadPrepared(infos);
            }
        }

        public void onAdd(AliyunDownloadMediaInfo info) {
        }

        public void onStart(AliyunDownloadMediaInfo info) {
        }

        public void onProgress(AliyunDownloadMediaInfo info, int percent) {
        }

        public void onStop(AliyunDownloadMediaInfo info) {
        }

        public void onCompletion(AliyunDownloadMediaInfo info) {
        }

        public void onError(AliyunDownloadMediaInfo info, ErrorCode code, String msg, String requestId) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                if (code.getValue() == ErrorCode.ERROR_SERVER_POP_TOKEN_EXPIRED.getValue() || code.getValue() == ErrorCode.ERROR_SERVER_VOD_INVALIDAUTHINFO_EXPIRETIME.getValue()) {
                    aliyunPlayerSkinActivity.refresh(true);
                } else {
                    if (aliyunPlayerSkinActivity.mDownloadProgressBar != null) {
                        aliyunPlayerSkinActivity.mDownloadProgressBar.setVisibility(8);
                    }
                    aliyunPlayerSkinActivity.mIsLoadDownloadInfo = false;
                    Toast.makeText((Context)aliyunPlayerSkinActivity, (CharSequence)(code.getValue() + " --- " + msg), (int)0).show();
                }
            }
        }

        public void onWait(AliyunDownloadMediaInfo info) {
        }

        public void onDelete(AliyunDownloadMediaInfo info) {
            if (info != null && Global.mDownloadMediaLists.size() > 0) {
                Global.mDownloadMediaLists.remove(info);
            }
        }

        public void onDeleteAll() {
            if (Global.mDownloadMediaLists.size() > 0) {
                Global.mDownloadMediaLists.clear();
            }
        }

        public void onFileProgress(AliyunDownloadMediaInfo info) {
        }
    }

    private static class MyFrameInfoListener
    implements IPlayer.OnRenderingStartListener {
        private WeakReference<AliyunPlayerSkinActivity> activityWeakReference;

        public MyFrameInfoListener(AliyunPlayerSkinActivity skinActivity) {
            this.activityWeakReference = new WeakReference<AliyunPlayerSkinActivity>(skinActivity);
        }

        public void onRenderingStart() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.activityWeakReference.get());
            if (activity != null) {
                activity.onFirstFrameStart();
            }
        }
    }

    private static class MyCompletionListener
    implements IPlayer.OnCompletionListener {
        private WeakReference<AliyunPlayerSkinActivity> activityWeakReference;

        public MyCompletionListener(AliyunPlayerSkinActivity skinActivity) {
            this.activityWeakReference = new WeakReference<AliyunPlayerSkinActivity>(skinActivity);
        }

        public void onCompletion() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.activityWeakReference.get());
            if (activity != null) {
                activity.onCompletion();
            }
        }
    }

    private static class MyOnTrackReadyListener
    implements IPlayer.OnTrackReadyListener {
        public WeakReference<AliyunPlayerSkinActivity> weakReference;

        public MyOnTrackReadyListener(AliyunPlayerSkinActivity weakReference) {
            this.weakReference = new WeakReference<AliyunPlayerSkinActivity>(weakReference);
        }

        public void onTrackReady(MediaInfo mediaInfo) {
            AliyunPlayerSkinActivity aliyunPlayerSkinActivity = (AliyunPlayerSkinActivity)((Object)this.weakReference.get());
            if (aliyunPlayerSkinActivity != null) {
                aliyunPlayerSkinActivity.onTrackReady(mediaInfo);
            }
        }
    }

    private static class MyPrepareListener
    implements IPlayer.OnPreparedListener {
        private WeakReference<AliyunPlayerSkinActivity> activityWeakReference;

        public MyPrepareListener(AliyunPlayerSkinActivity skinActivity) {
            this.activityWeakReference = new WeakReference<AliyunPlayerSkinActivity>(skinActivity);
        }

        public void onPrepared() {
            AliyunPlayerSkinActivity activity = (AliyunPlayerSkinActivity)((Object)this.activityWeakReference.get());
            if (activity != null) {
                activity.onPrepared();
            }
        }
    }
}

