/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.activity;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.AliyunPlayerTypeAuthFragment;
import com.aliyun.vodplayerview.fragment.AliyunPlayerTypeLiveStsFragment;
import com.aliyun.vodplayerview.fragment.AliyunPlayerTypeMpsFragment;
import com.aliyun.vodplayerview.fragment.AliyunPlayerTypeStsFragment;
import com.aliyun.vodplayerview.fragment.AliyunPlayerTypeUrlFragment;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import java.util.ArrayList;
import java.util.List;

public class AliyunPlayerTypeEditActivity
extends AppCompatActivity
implements View.OnClickListener {
    private RadioButton mPlayTypeUrlRadioButton;
    private RadioButton mPlayTypeStsRadioButton;
    private RadioButton mPlayTypeMpsRadioButton;
    private RadioButton mPlayTypeAuthRadioButton;
    private RadioButton mPlayTypeLiveStsRadioButton;
    private List<RadioButton> mPlayTypeRadioButtonList = new ArrayList<RadioButton>();
    private BaseFragment mCurrentFragment;
    private BaseFragment mAliyunPlayerTypeUrlFragment;
    private BaseFragment mAliyunPlayerTypeStsFragment;
    private BaseFragment mAliyunPlayerTypeMpsFragment;
    private BaseFragment mAliyunPlayerTypeAuthFragment;
    private BaseFragment mAliyunPlayerTypeLiveStsFragment;
    private TextView mNormalTextView;
    private TextView mConfirmConfigTextView;
    private ImageView mBackImageView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_aliyun_player_type_edit);
        this.initView();
        this.initFragment();
        this.initData();
        this.initListener();
    }

    private void initView() {
        this.mBackImageView = (ImageView)this.findViewById(R.id.iv_back);
        this.mNormalTextView = (TextView)this.findViewById(R.id.tv_normal_config);
        this.mConfirmConfigTextView = (TextView)this.findViewById(R.id.tv_confirm_config);
        this.mPlayTypeUrlRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_url);
        this.mPlayTypeStsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_sts);
        this.mPlayTypeMpsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_mps);
        this.mPlayTypeAuthRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_auth);
        this.mPlayTypeLiveStsRadioButton = (RadioButton)this.findViewById(R.id.radio_btn_play_type_live_sts);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeUrlRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeStsRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeMpsRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeAuthRadioButton);
        this.mPlayTypeRadioButtonList.add(this.mPlayTypeLiveStsRadioButton);
    }

    private void initData() {
        if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.STS) {
            this.selectedPlayType(this.mPlayTypeStsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeStsFragment);
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.MPS) {
            this.selectedPlayType(this.mPlayTypeMpsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeMpsFragment);
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.AUTH) {
            this.selectedPlayType(this.mPlayTypeAuthRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeAuthFragment);
        } else if (GlobalPlayerConfig.mCurrentPlayType == GlobalPlayerConfig.PLAYTYPE.LIVE_STS) {
            this.selectedPlayType(this.mPlayTypeLiveStsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeLiveStsFragment);
        } else {
            this.selectedPlayType(this.mPlayTypeUrlRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeUrlFragment);
        }
    }

    private void initFragment() {
        this.mAliyunPlayerTypeUrlFragment = new AliyunPlayerTypeUrlFragment();
        this.mAliyunPlayerTypeStsFragment = new AliyunPlayerTypeStsFragment();
        this.mAliyunPlayerTypeMpsFragment = new AliyunPlayerTypeMpsFragment();
        this.mAliyunPlayerTypeAuthFragment = new AliyunPlayerTypeAuthFragment();
        this.mAliyunPlayerTypeLiveStsFragment = new AliyunPlayerTypeLiveStsFragment();
    }

    private void initListener() {
        this.mBackImageView.setOnClickListener((View.OnClickListener)this);
        this.mNormalTextView.setOnClickListener((View.OnClickListener)this);
        this.mConfirmConfigTextView.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeUrlRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeStsRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeMpsRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeAuthRadioButton.setOnClickListener((View.OnClickListener)this);
        this.mPlayTypeLiveStsRadioButton.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        if (view == this.mBackImageView) {
            this.finish();
        } else if (view == this.mPlayTypeUrlRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.URL;
            this.selectedPlayType(this.mPlayTypeUrlRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeUrlFragment);
        } else if (view == this.mPlayTypeStsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.STS;
            this.selectedPlayType(this.mPlayTypeStsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeStsFragment);
        } else if (view == this.mPlayTypeMpsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.MPS;
            this.selectedPlayType(this.mPlayTypeMpsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeMpsFragment);
        } else if (view == this.mPlayTypeAuthRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.AUTH;
            this.selectedPlayType(this.mPlayTypeAuthRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeAuthFragment);
        } else if (view == this.mPlayTypeLiveStsRadioButton) {
            GlobalPlayerConfig.mCurrentPlayType = GlobalPlayerConfig.PLAYTYPE.LIVE_STS;
            this.selectedPlayType(this.mPlayTypeLiveStsRadioButton);
            this.switchFragment(this.mAliyunPlayerTypeLiveStsFragment);
        } else if (view == this.mConfirmConfigTextView) {
            this.judgeCurrentPlayType();
            if (this.mCurrentFragment != null) {
                this.mCurrentFragment.confirmPlayInfo();
            }
            this.setResult(-1);
            this.finish();
        } else if (view == this.mNormalTextView && this.mCurrentFragment != null) {
            this.mCurrentFragment.defaultPlayInfo();
        }
    }

    private void judgeCurrentPlayType() {
        GlobalPlayerConfig.mCurrentPlayType = this.mPlayTypeUrlRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.URL : (this.mPlayTypeStsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.STS : (this.mPlayTypeAuthRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.AUTH : (this.mPlayTypeLiveStsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.LIVE_STS : (this.mPlayTypeMpsRadioButton.isChecked() ? GlobalPlayerConfig.PLAYTYPE.MPS : GlobalPlayerConfig.PLAYTYPE.URL))));
    }

    private void selectedPlayType(RadioButton selectedRadioButton) {
        if (this.mPlayTypeRadioButtonList != null && selectedRadioButton != null) {
            for (RadioButton radioButton : this.mPlayTypeRadioButtonList) {
                radioButton.setChecked(radioButton == selectedRadioButton);
            }
        }
    }

    private void switchFragment(BaseFragment targetFragment) {
        FragmentTransaction mFragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        if (!targetFragment.isAdded()) {
            if (this.mCurrentFragment != null) {
                mFragmentTransaction.hide((Fragment)this.mCurrentFragment);
            }
            mFragmentTransaction.add(R.id.framelayout_input_content, (Fragment)targetFragment);
        } else {
            mFragmentTransaction.hide((Fragment)this.mCurrentFragment).show((Fragment)targetFragment);
        }
        this.mCurrentFragment = targetFragment;
        mFragmentTransaction.commit();
    }
}

