/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.util.Log;

public class NetWatchdog {
    private static final String TAG = NetWatchdog.class.getSimpleName();
    private Context mContext;
    private NetChangeListener mNetChangeListener;
    private NetConnectedListener mNetConnectedListener;
    private IntentFilter mNetIntentFilter = new IntentFilter();
    private boolean isReconnect;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo wifiNetworkInfo = cm.getNetworkInfo(1);
            NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
            NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
            NetworkInfo.State wifiState = NetworkInfo.State.UNKNOWN;
            NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
            Bundle bundle = intent.getExtras();
            NetworkInfo netInfo = null;
            if (bundle != null) {
                netInfo = (NetworkInfo)bundle.get("networkInfo");
            }
            if (wifiNetworkInfo != null) {
                wifiState = wifiNetworkInfo.getState();
            }
            if (mobileNetworkInfo != null) {
                mobileState = mobileNetworkInfo.getState();
            }
            if (activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting()) {
                if (NetWatchdog.this.mNetConnectedListener != null) {
                    NetWatchdog.this.mNetConnectedListener.onReNetConnected(NetWatchdog.this.isReconnect);
                    NetWatchdog.this.isReconnect = false;
                }
            } else if (activeNetworkInfo == null && NetWatchdog.this.mNetConnectedListener != null) {
                NetWatchdog.this.isReconnect = true;
                NetWatchdog.this.mNetConnectedListener.onNetUnConnected();
            }
            if (NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED == mobileState) {
                Log.d((String)TAG, (String)"onWifiTo4G()");
                if (NetWatchdog.this.mNetChangeListener != null) {
                    NetWatchdog.this.mNetChangeListener.onWifiTo4G();
                }
            } else if (NetworkInfo.State.CONNECTED == wifiState && NetworkInfo.State.CONNECTED != mobileState && netInfo != null && netInfo.getType() == 1) {
                if (NetWatchdog.this.mNetChangeListener != null) {
                    NetWatchdog.this.mNetChangeListener.on4GToWifi();
                }
            } else if (NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED != mobileState && NetWatchdog.this.mNetChangeListener != null) {
                NetWatchdog.this.mNetChangeListener.onNetDisconnected();
            }
        }
    };

    public NetWatchdog(Context context) {
        this.mContext = context.getApplicationContext();
        this.mNetIntentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
    }

    public void setNetChangeListener(NetChangeListener l) {
        this.mNetChangeListener = l;
    }

    public void setNetConnectedListener(NetConnectedListener mNetConnectedListener) {
        this.mNetConnectedListener = mNetConnectedListener;
    }

    public void startWatch() {
        try {
            this.mContext.registerReceiver(this.mReceiver, this.mNetIntentFilter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopWatch() {
        try {
            this.mContext.unregisterReceiver(this.mReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasNet(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo wifiNetworkInfo = cm.getNetworkInfo(1);
        NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
        NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
        NetworkInfo.State wifiState = NetworkInfo.State.UNKNOWN;
        NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
        if (wifiNetworkInfo != null) {
            wifiState = wifiNetworkInfo.getState();
        }
        if (mobileNetworkInfo != null) {
            mobileState = mobileNetworkInfo.getState();
        }
        if (NetworkInfo.State.CONNECTED != wifiState && NetworkInfo.State.CONNECTED != mobileState) {
            return false;
        }
        return activeNetworkInfo != null && activeNetworkInfo.isConnectedOrConnecting();
    }

    public static boolean is4GConnected(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo mobileNetworkInfo = cm.getNetworkInfo(0);
        NetworkInfo.State mobileState = NetworkInfo.State.UNKNOWN;
        if (mobileNetworkInfo != null) {
            mobileState = mobileNetworkInfo.getState();
        }
        return NetworkInfo.State.CONNECTED == mobileState;
    }

    public static interface NetConnectedListener {
        public void onReNetConnected(boolean var1);

        public void onNetUnConnected();
    }

    public static interface NetChangeListener {
        public void onWifiTo4G();

        public void on4GToWifi();

        public void onNetDisconnected();
    }
}

