/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.download;

import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;

public class StorageUtil {
    public static long MINIST_STORAGE_SIZE = 102400L;
    public static long MIN_STORAGE_SIZE = 204800L;

    public static boolean isExternalMemoryPath(String path) {
        String sdcardPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return path.contains(sdcardPath);
    }

    public static boolean externalMemoryAvailable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static long getAvailableExternalMemorySize() {
        if (StorageUtil.externalMemoryAvailable()) {
            long availableBlocks;
            long blockSize;
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                availableBlocks = stat.getAvailableBlocksLong();
            } else {
                blockSize = stat.getBlockSize();
                availableBlocks = stat.getAvailableBlocks();
            }
            return blockSize * availableBlocks / 1024L;
        }
        return -1L;
    }

    public static long getAvailableInternalMemorySize() {
        long availableBlocks;
        long blockSize;
        File path = Environment.getDataDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            availableBlocks = stat.getAvailableBlocks();
        }
        return blockSize * availableBlocks / 1024L;
    }

    public static String getTotalExternalMemorySizeStr() {
        if (StorageUtil.externalMemoryAvailable()) {
            long totalBlocks;
            long blockSize;
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                totalBlocks = stat.getBlockCountLong();
            } else {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return StorageUtil.formatSize(totalBlocks * blockSize);
        }
        return null;
    }

    public static long getTotalExternalMemorySize() {
        if (StorageUtil.externalMemoryAvailable()) {
            long totalBlocks;
            long blockSize;
            File path = Environment.getExternalStorageDirectory();
            StatFs stat = new StatFs(path.getPath());
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = stat.getBlockSizeLong();
                totalBlocks = stat.getBlockCountLong();
            } else {
                blockSize = stat.getBlockSize();
                totalBlocks = stat.getBlockCount();
            }
            return blockSize * totalBlocks / 1024L;
        }
        return -1L;
    }

    public static String formatSize(long size) {
        String suffix = null;
        if (size >= 1024L) {
            suffix = "KB";
            if ((size /= 1024L) >= 1024L) {
                suffix = "MB";
                size /= 1024L;
            }
        }
        StringBuilder resultBuffer = new StringBuilder(Long.toString(size));
        for (int commaOffset = resultBuffer.length() - 3; commaOffset > 0; commaOffset -= 3) {
            resultBuffer.insert(commaOffset, ',');
        }
        if (suffix != null) {
            resultBuffer.append(suffix);
        }
        return resultBuffer.toString();
    }
}

