/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.utils;

import android.content.Context;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VcPlayerLog {
    public static final int LogMode_Off = 0;
    public static final int LogMode_Console = 1;
    public static final int LogMode_File = 2;
    private static LogLevel sLogLevel = LogLevel.Verbose;
    private static int sLogMode = 1;
    private static BufferedWriter sLogWriter = null;
    private static String sAppPackageName = null;
    private static List<OnConfigChangedListener> listenerList = new ArrayList<OnConfigChangedListener>();

    public static void enableLog(boolean enable) {
        sLogMode = enable ? 1 : 0;
    }

    public static void setLogInfo(Context context, int logMode, LogLevel level, String absPath) {
        if (context != null) {
            sAppPackageName = context.getPackageName();
        }
        sLogMode = logMode < 0 ? 0 : logMode;
        sLogLevel = level == null ? LogLevel.Verbose : level;
        VcPlayerLog.closeWriter();
        if (VcPlayerLog.isModeContains(sLogMode, 2)) {
            VcPlayerLog.createLogWriter(absPath);
        }
        for (OnConfigChangedListener l : listenerList) {
            l.onConfigChanged(level.value(), (logMode & 1) == 1, (logMode & 2) == 2);
        }
    }

    public static void addOnConfigChangedListener(OnConfigChangedListener l) {
        if (l != null) {
            listenerList.add(l);
            l.onConfigChanged(sLogLevel.value(), (sLogMode & 1) == 1, (sLogMode & 2) == 2);
        }
    }

    public static void removeOnConfigChangedListener(OnConfigChangedListener l) {
        listenerList.remove(l);
    }

    public static void v(String tag, String msg) {
        VcPlayerLog.printLog(tag, msg, LogLevel.Verbose);
    }

    public static void d(String tag, String msg) {
        VcPlayerLog.printLog(tag, msg, LogLevel.Debug);
    }

    public static void i(String tag, String msg) {
        VcPlayerLog.printLog(tag, msg, LogLevel.Info);
    }

    public static void w(String tag, String msg) {
        VcPlayerLog.printLog(tag, msg, LogLevel.Warn);
    }

    public static void e(String tag, String msg) {
        VcPlayerLog.printLog(tag, msg, LogLevel.Error);
    }

    private static void printLog(String tag, String msg, LogLevel targetLevel) {
        VcPlayerLog.consoleLog(tag, msg, targetLevel);
        VcPlayerLog.fileLog(tag, msg, targetLevel);
    }

    private static void fileLog(String tag, String msg, LogLevel targetLevel) {
        if (!VcPlayerLog.isSourceLarger(sLogLevel, targetLevel)) {
            return;
        }
        if (VcPlayerLog.isModeContains(sLogMode, 2)) {
            String log = VcPlayerLog.formatLog(targetLevel.name(), tag, msg);
            VcPlayerLog.WriteLog(log);
        }
    }

    private static void consoleLog(String tag, String msg, LogLevel targetLevel) {
        if (VcPlayerLog.isSourceLarger(sLogLevel, targetLevel)) {
            return;
        }
        if (VcPlayerLog.isModeContains(sLogMode, 1)) {
            if (targetLevel == LogLevel.Verbose) {
                Log.v((String)tag, (String)msg);
            } else if (targetLevel == LogLevel.Debug) {
                Log.d((String)tag, (String)msg);
            } else if (targetLevel == LogLevel.Info) {
                Log.i((String)tag, (String)msg);
            } else if (targetLevel == LogLevel.Warn) {
                Log.w((String)tag, (String)msg);
            } else if (targetLevel == LogLevel.Error) {
                Log.e((String)tag, (String)msg);
            }
        }
    }

    private static String formatLog(String levelName, String tag, String msg) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new SimpleDateFormat("MM-dd HH:mm:ss:SSS").format(new Date()));
        stringBuilder.append(" ");
        stringBuilder.append(Process.myPid()).append("-").append(Process.myTid());
        stringBuilder.append(" ");
        stringBuilder.append(levelName).append(" ");
        stringBuilder.append(tag).append(": ").append(msg);
        return stringBuilder.toString();
    }

    public static synchronized void WriteLog(String log) {
        if (sLogWriter != null && !TextUtils.isEmpty((CharSequence)log)) {
            try {
                sLogWriter.write(log.trim() + "\n");
                sLogWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isModeContains(int source, int target) {
        return (source & target) == target;
    }

    private static boolean isSourceLarger(LogLevel source, LogLevel target) {
        return source.value() >= target.value();
    }

    private static void createLogWriter(String absPath) {
        if (TextUtils.isEmpty((CharSequence)absPath)) {
            return;
        }
        boolean ret = false;
        File file = new File(absPath);
        if (!file.exists() || file.isDirectory()) {
            File parent = file.getParentFile();
            ret = !parent.exists() || !parent.isDirectory() ? parent.mkdirs() : true;
            if (ret) {
                try {
                    ret = file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ret = true;
        }
        if (ret) {
            try {
                sLogWriter = new BufferedWriter(new FileWriter(file, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close() {
        VcPlayerLog.closeWriter();
        listenerList.clear();
    }

    private static void closeWriter() {
        if (sLogWriter != null) {
            try {
                sLogWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                sLogWriter = null;
            }
        }
    }

    public static interface OnConfigChangedListener {
        public void onConfigChanged(int var1, boolean var2, boolean var3);
    }

    public static class LogLevel {
        public static final LogLevel Verbose = new LogLevel(0, "V");
        public static final LogLevel Debug = new LogLevel(1, "D");
        public static final LogLevel Info = new LogLevel(2, "I");
        public static final LogLevel Warn = new LogLevel(3, "W");
        public static final LogLevel Error = new LogLevel(4, "E");
        private int value = -1;
        private String name = "";

        private LogLevel(int v, String aname) {
            this.value = v;
            this.name = aname;
        }

        public int value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }
    }
}

