/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ui.activity;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aliyun.player.aliyunplayerbase.activity.BaseActivity;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.ScreenUtils;
import com.aliyun.sdk.player.AliLiveShiftPlayer;
import com.aliyun.sdk.player.aliyunliveshiftplayer.R;
import com.aliyun.ui.view.AliyunLiveShiftPlayerView;
import com.aliyun.ui.view.control.ControlView;
import java.lang.ref.WeakReference;

public class AliyunLiveShiftActivity
extends BaseActivity {
    private AliyunLiveShiftPlayerView mLiveShiftView;
    private TextView mLiveShiftPlayerTitleTextView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_aliyun_live_shift);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.mLiveShiftView = (AliyunLiveShiftPlayerView)this.findViewById(R.id.live_shift_view);
        this.mLiveShiftPlayerTitleTextView = (TextView)this.findViewById(R.id.live_shift_player_title);
        this.mLiveShiftView.prepare();
    }

    private void initListener() {
        this.mLiveShiftView.setOutOnBackIconClickListener(new MyOnBackIconClickListener(this));
        this.mLiveShiftView.setOrientationChangeListener(new MyOrientationChangeListener(this));
        this.mLiveShiftView.setmOutOnSeekLiveCompletionListener(new MyOnSeekLiveCompletionListener(this));
        this.mLiveShiftView.setmOutOnTimeShiftUpdaterListener(new MyOnTimeShiftUpdaterListener(this));
    }

    private void onUpdater(long currentTime, long shiftStartTime, long shiftEndTime) {
    }

    private void onSeekLiveCompletion(long playTime) {
    }

    private void onBackClick() {
        this.finish();
    }

    protected void onStart() {
        super.onStart();
        if (this.mLiveShiftView != null) {
            this.mLiveShiftView.start();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mLiveShiftView != null) {
            this.mLiveShiftView.pause();
        }
    }

    protected void onDestroy() {
        if (this.mLiveShiftView != null) {
            this.mLiveShiftView.destroy();
        }
        super.onDestroy();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updatePlayerViewMode();
    }

    private void updatePlayerViewMode() {
        if (this.mLiveShiftView != null) {
            int orientation = this.getResources().getConfiguration().orientation;
            if (orientation == 1) {
                this.getWindow().clearFlags(1024);
                this.mLiveShiftView.setSystemUiVisibility(0);
                LinearLayout.LayoutParams aliVcVideoViewLayoutParams = (LinearLayout.LayoutParams)this.mLiveShiftView.getLayoutParams();
                aliVcVideoViewLayoutParams.height = (int)((float)ScreenUtils.getWidth((Context)this) * 9.0f / 16.0f);
                aliVcVideoViewLayoutParams.width = -1;
            } else if (orientation == 2) {
                if (!this.isStrangePhone()) {
                    this.getWindow().setFlags(1024, 1024);
                    this.mLiveShiftView.setSystemUiVisibility(5894);
                }
                LinearLayout.LayoutParams aliVcVideoViewLayoutParams = (LinearLayout.LayoutParams)this.mLiveShiftView.getLayoutParams();
                aliVcVideoViewLayoutParams.height = -1;
                aliVcVideoViewLayoutParams.width = -1;
            }
        }
    }

    private static class MyOnBackIconClickListener
    implements ControlView.OnBackIconClickListener {
        private WeakReference<AliyunLiveShiftActivity> weakReference;

        public MyOnBackIconClickListener(AliyunLiveShiftActivity aliyunLiveShiftActivity) {
            this.weakReference = new WeakReference<AliyunLiveShiftActivity>(aliyunLiveShiftActivity);
        }

        @Override
        public void onBackClickListener() {
            AliyunLiveShiftActivity aliyunLiveShiftActivity = (AliyunLiveShiftActivity)((Object)this.weakReference.get());
            if (aliyunLiveShiftActivity != null) {
                aliyunLiveShiftActivity.onBackClick();
            }
        }
    }

    private static class MyOrientationChangeListener
    implements AliyunLiveShiftPlayerView.OnOrientationChangeListener {
        private WeakReference<AliyunLiveShiftActivity> weakReference;

        public MyOrientationChangeListener(AliyunLiveShiftActivity aliyunLiveShiftActivity) {
            this.weakReference = new WeakReference<AliyunLiveShiftActivity>(aliyunLiveShiftActivity);
        }

        @Override
        public void orientationChange(boolean from, AliyunScreenMode currentMode) {
            AliyunLiveShiftActivity aliyunLiveShiftActivity = (AliyunLiveShiftActivity)((Object)this.weakReference.get());
            if (aliyunLiveShiftActivity != null) {
                // empty if block
            }
        }
    }

    private static class MyOnSeekLiveCompletionListener
    implements AliLiveShiftPlayer.OnSeekLiveCompletionListener {
        private WeakReference<AliyunLiveShiftActivity> weakReference;

        public MyOnSeekLiveCompletionListener(AliyunLiveShiftActivity aliyunLiveShiftActivity) {
            this.weakReference = new WeakReference<AliyunLiveShiftActivity>(aliyunLiveShiftActivity);
        }

        @Override
        public void onSeekLiveCompletion(long playTime) {
            AliyunLiveShiftActivity aliyunLiveShiftActivity = (AliyunLiveShiftActivity)((Object)this.weakReference.get());
            if (aliyunLiveShiftActivity != null) {
                aliyunLiveShiftActivity.onSeekLiveCompletion(playTime);
            }
        }
    }

    private static class MyOnTimeShiftUpdaterListener
    implements AliLiveShiftPlayer.OnTimeShiftUpdaterListener {
        private WeakReference<AliyunLiveShiftActivity> weakReference;

        public MyOnTimeShiftUpdaterListener(AliyunLiveShiftActivity aliyunLiveShiftActivity) {
            this.weakReference = new WeakReference<AliyunLiveShiftActivity>(aliyunLiveShiftActivity);
        }

        @Override
        public void onUpdater(long currentTime, long shiftStartTime, long shiftEndTime) {
            AliyunLiveShiftActivity aliyunLiveShiftActivity = (AliyunLiveShiftActivity)((Object)this.weakReference.get());
            if (aliyunLiveShiftActivity != null) {
                aliyunLiveShiftActivity.onUpdater(currentTime, shiftStartTime, shiftEndTime);
            }
        }
    }
}

