/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.ui.view.control;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;
import com.aliyun.player.aliyunplayerbase.util.Formatter;
import com.aliyun.sdk.player.aliyunliveshiftplayer.R;
import com.aliyun.ui.view.seekbar.LiveSeekBar;

public class ControlView
extends RelativeLayout {
    private TextView mTitleTextView;
    private ImageView mTitleBackImageView;
    private ImageView mPlayStateImagView;
    private LiveSeekBar mSmallLiveSeekBar;
    private LinearLayout mTitleBarLinearLayout;
    private LinearLayout mControlRootLinearLayout;
    private LinearLayout mSmallBarRootLinearLayout;
    private boolean mInSeek = false;
    private OnBackIconClickListener mOnBackIconClickListener;
    private OnSeekBarChangeListener mOnSeekBarChangeListener;
    private OnPlayStateClickListener mOnPlayStateClickListener;
    private OnScreenModeBtnClickListener mOnScreenModeBtnClickListener;
    private int mPlayState = 3;
    private AliyunScreenMode mAliyunScreenMode = AliyunScreenMode.Small;
    private ImageView mScreenModeImageView;
    private TextView mEndTimeTextView;
    private TextView mCurrentPlayTimeTextView;
    private long mShiftStartTime;

    public ControlView(Context context) {
        super(context);
        this.init();
    }

    public ControlView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ControlView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_live_shift_control, (ViewGroup)this, true);
        this.initView();
        this.initListener();
        this.updateSeekBarTheme();
        this.updateAllViews();
    }

    private void initView() {
        this.mTitleTextView = (TextView)this.findViewById(R.id.alivc_tv_title);
        this.mEndTimeTextView = (TextView)this.findViewById(R.id.tv_endTime);
        this.mTitleBarLinearLayout = (LinearLayout)this.findViewById(R.id.titlebar);
        this.mTitleBackImageView = (ImageView)this.findViewById(R.id.alivc_title_back);
        this.mPlayStateImagView = (ImageView)this.findViewById(R.id.alivc_player_state);
        this.mScreenModeImageView = (ImageView)this.findViewById(R.id.alivc_screen_mode);
        this.mControlRootLinearLayout = (LinearLayout)this.findViewById(R.id.ll_control_root);
        this.mCurrentPlayTimeTextView = (TextView)this.findViewById(R.id.tv_current_play_time);
        this.mSmallBarRootLinearLayout = (LinearLayout)this.findViewById(R.id.alivc_info_small_bar);
        this.mSmallLiveSeekBar = (LiveSeekBar)this.findViewById(R.id.alivc_info_live_small_seekbar);
    }

    private void initListener() {
        this.mTitleBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnBackIconClickListener != null) {
                    ControlView.this.mOnBackIconClickListener.onBackClickListener();
                }
            }
        });
        this.mPlayStateImagView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnPlayStateClickListener != null) {
                    if (ControlView.this.mPlayState == 3) {
                        ControlView.this.mPlayState = 4;
                    } else if (ControlView.this.mPlayState == 4) {
                        ControlView.this.mPlayState = 3;
                    }
                    ControlView.this.mOnPlayStateClickListener.onPlayStateClickListener(ControlView.this.mPlayState);
                    ControlView.this.updatePlayStateBtn();
                }
            }
        });
        this.mSmallLiveSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    ControlView.this.mInSeek = true;
                    long seekTime = (long)seekBar.getProgress() + ControlView.this.mShiftStartTime;
                    ControlView.this.mCurrentPlayTimeTextView.setText((CharSequence)Formatter.formatDate((long)seekTime));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                ControlView.this.mInSeek = false;
                if (ControlView.this.mOnSeekBarChangeListener != null) {
                    long seekTime = ControlView.this.mSmallLiveSeekBar.getProgress();
                    ControlView.this.mOnSeekBarChangeListener.onStopTrackingTouch(seekTime);
                }
            }
        });
        this.mScreenModeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ControlView.this.mOnScreenModeBtnClickListener != null) {
                    ControlView.this.mOnScreenModeBtnClickListener.onScreenModeClick();
                }
            }
        });
    }

    private void updateSeekBarTheme() {
        int progressDrawableResId = R.drawable.alivc_info_seekbar_bg_blue;
        int thumbResId = R.drawable.alivc_info_seekbar_thumb_blue;
        Resources resources = this.getResources();
        Drawable smallProgressDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)progressDrawableResId);
        Drawable smallThumb = ContextCompat.getDrawable((Context)this.getContext(), (int)thumbResId);
        this.mSmallLiveSeekBar.setProgressDrawable(smallProgressDrawable);
        this.mSmallLiveSeekBar.setThumb(smallThumb);
    }

    public void setPlayState(int playState) {
        this.mPlayState = playState;
        this.updatePlayStateBtn();
        this.updateScreenModeBtn();
    }

    public void setScreenModeStatus(AliyunScreenMode mode) {
        this.mAliyunScreenMode = mode;
        this.updateScreenModeBtn();
    }

    public void setVideoTitle(String title) {
    }

    private void updateAllViews() {
        this.updatePlayStateBtn();
    }

    private void updatePlayStateBtn() {
        if (this.mPlayState == 3) {
            this.mPlayStateImagView.setImageResource(R.drawable.alivc_playstate_pause);
        } else {
            this.mPlayStateImagView.setImageResource(R.drawable.alivc_playstate_play);
        }
    }

    private void updateScreenModeBtn() {
        if (this.mAliyunScreenMode == AliyunScreenMode.Full) {
            this.mScreenModeImageView.setImageResource(R.drawable.alivc_screen_mode_small);
        } else {
            this.mScreenModeImageView.setImageResource(R.drawable.alivc_screen_mode_large);
        }
    }

    public void setPlayProgress(long mCurrentTime) {
        if (this.mSmallLiveSeekBar != null) {
            this.mSmallLiveSeekBar.setPlayProgress(mCurrentTime);
        }
        if (this.mCurrentPlayTimeTextView != null && !this.mInSeek) {
            this.mCurrentPlayTimeTextView.setText((CharSequence)Formatter.formatDate((long)mCurrentTime));
        }
    }

    public void setLiveTime(long mCurrentLiveTime) {
        if (this.mSmallLiveSeekBar != null && !this.mInSeek) {
            this.mSmallLiveSeekBar.setLiveTime(mCurrentLiveTime);
        }
    }

    public void updateRange(long mShiftStartTime, long mEndTime) {
        this.mShiftStartTime = mShiftStartTime;
        if (this.mSmallLiveSeekBar != null) {
            this.mSmallLiveSeekBar.updateRange(mShiftStartTime, mEndTime);
        }
        if (this.mEndTimeTextView != null) {
            this.mEndTimeTextView.setText((CharSequence)Formatter.formatDate((long)mEndTime));
        }
    }

    public int getCurrentPlayState() {
        return this.mPlayState;
    }

    public void seekLiveCompletion() {
        this.mInSeek = false;
    }

    public void hide() {
        this.setVisibility(8);
    }

    public void show() {
        this.setVisibility(0);
    }

    public void setOnBackIconClickListener(OnBackIconClickListener listener) {
        this.mOnBackIconClickListener = listener;
    }

    public void setOnSeekBarChangeListener(OnSeekBarChangeListener listener) {
        this.mOnSeekBarChangeListener = listener;
    }

    public void setOnPlayStateClickListener(OnPlayStateClickListener listener) {
        this.mOnPlayStateClickListener = listener;
    }

    public void setOnScreenModeBtnClickListener(OnScreenModeBtnClickListener listener) {
        this.mOnScreenModeBtnClickListener = listener;
    }

    public static interface OnScreenModeBtnClickListener {
        public void onScreenModeClick();
    }

    public static interface OnPlayStateClickListener {
        public void onPlayStateClickListener(int var1);
    }

    public static interface OnSeekBarChangeListener {
        public void onStopTrackingTouch(long var1);
    }

    public static interface OnBackIconClickListener {
        public void onBackClickListener();
    }
}

