/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.vodplayerview.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.aliyunplayerbase.bean.AliyunSts;
import com.aliyun.player.aliyunplayerbase.net.GetAuthInformation;
import com.aliyun.svideo.common.utils.ToastUtils;
import com.aliyun.vodplayer.R;
import com.aliyun.vodplayerview.fragment.BaseFragment;
import com.google.zxing.activity.CaptureActivity;

public class AliyunPlayerTypeLiveStsFragment
extends BaseFragment {
    private static final int REQ_CODE_PERMISSION = 4370;
    private EditText mLiveStsUrlEditText;
    private EditText mStsRegionEditText;
    private EditText mStsAccessKeyIdEditText;
    private EditText mStsSecurityTokenEditText;
    private EditText mStsAccessKeySecretEditText;
    private EditText mStsDomainEditText;
    private EditText mStsAppEditText;
    private EditText mStsStreamEditText;
    private String mUrl;
    private String mRegion;
    private String mAccessKeyId;
    private String mSecurityToken;
    private String mAccessKeySecret;
    private String mLiveStsDomain;
    private String mLiveStsApp;
    private String mLiveStream;
    private TextView mRefreshTextView;
    private ImageView mQrCodeImageView;

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_aliyun_live_sts_player_type, container, false);
        this.mLiveStsUrlEditText = (EditText)view.findViewById(R.id.et_live_sts_url);
        this.mQrCodeImageView = (ImageView)view.findViewById(R.id.iv_qrcode);
        this.mRefreshTextView = (TextView)view.findViewById(R.id.tv_refresh);
        this.mStsRegionEditText = (EditText)view.findViewById(R.id.et_live_sts_region);
        this.mStsDomainEditText = (EditText)view.findViewById(R.id.et_live_sts_domain);
        this.mStsAppEditText = (EditText)view.findViewById(R.id.et_live_sts_app);
        this.mStsStreamEditText = (EditText)view.findViewById(R.id.et_live_sts_stream);
        this.mStsAccessKeyIdEditText = (EditText)view.findViewById(R.id.et_live_sts_access_key_id);
        this.mStsSecurityTokenEditText = (EditText)view.findViewById(R.id.et_live_sts_security_token);
        this.mStsAccessKeySecretEditText = (EditText)view.findViewById(R.id.et_live_sts_access_key_secret);
        this.initData();
        this.initListener();
        this.defaultPlayInfo();
        return view;
    }

    private void getVideoPlayStsInfo() {
        GetAuthInformation getAuthInformation = new GetAuthInformation();
        getAuthInformation.getVideoPlayLiveStsInfo(new GetAuthInformation.OnGetStsInfoListener(){

            public void onGetStsError(String errorMsg) {
                ToastUtils.show((Context)AliyunPlayerTypeLiveStsFragment.this.getContext(), (String)errorMsg);
            }

            public void onGetStsSuccess(AliyunSts.StsBean dataBean) {
                if (dataBean != null) {
                    AliyunPlayerTypeLiveStsFragment.this.mStsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
                    AliyunPlayerTypeLiveStsFragment.this.mStsAccessKeyIdEditText.setText((CharSequence)dataBean.getAccessKeyId());
                    AliyunPlayerTypeLiveStsFragment.this.mStsSecurityTokenEditText.setText((CharSequence)dataBean.getSecurityToken());
                    AliyunPlayerTypeLiveStsFragment.this.mStsAccessKeySecretEditText.setText((CharSequence)dataBean.getAccessKeySecret());
                    GlobalPlayerConfig.mLiveExpiration = dataBean.getExpiration();
                }
            }
        });
    }

    private void initData() {
        this.mStsDomainEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsDomain);
        this.mStsAppEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsApp);
        this.mStsStreamEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsStream);
        this.mLiveStsUrlEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsUrl);
        this.mStsRegionEditText.setText((CharSequence)GlobalPlayerConfig.mRegion);
        this.mStsAccessKeyIdEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsAccessKeyId);
        this.mStsSecurityTokenEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsSecurityToken);
        this.mStsAccessKeySecretEditText.setText((CharSequence)GlobalPlayerConfig.mLiveStsAccessKeySecret);
    }

    private void initListener() {
        this.mRefreshTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AliyunPlayerTypeLiveStsFragment.this.mUrl = AliyunPlayerTypeLiveStsFragment.this.mLiveStsUrlEditText.getText().toString();
                if (TextUtils.isEmpty((CharSequence)AliyunPlayerTypeLiveStsFragment.this.mUrl)) {
                    ToastUtils.show((Context)AliyunPlayerTypeLiveStsFragment.this.getContext(), (int)R.string.alivc_refresh_vid_empty);
                    return;
                }
                AliyunPlayerTypeLiveStsFragment.this.getVideoPlayStsInfo();
            }
        });
        this.mQrCodeImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ContextCompat.checkSelfPermission((Context)AliyunPlayerTypeLiveStsFragment.this.getActivity(), (String)"android.permission.CAMERA") != 0) {
                    ActivityCompat.requestPermissions((Activity)AliyunPlayerTypeLiveStsFragment.this.getActivity(), (String[])new String[]{"android.permission.CAMERA"}, (int)4370);
                } else {
                    AliyunPlayerTypeLiveStsFragment.this.startCaptureActivityForResult();
                }
            }
        });
    }

    private void startCaptureActivityForResult() {
        Intent intent = new Intent((Context)this.getActivity(), CaptureActivity.class);
        this.startActivityForResult(intent, 156);
    }

    private void getInputContent() {
        this.mUrl = this.mLiveStsUrlEditText.getText().toString();
        this.mRegion = this.mStsRegionEditText.getText().toString();
        this.mAccessKeyId = this.mStsAccessKeyIdEditText.getText().toString();
        this.mSecurityToken = this.mStsSecurityTokenEditText.getText().toString();
        this.mAccessKeySecret = this.mStsAccessKeySecretEditText.getText().toString();
        this.mLiveStsDomain = this.mStsDomainEditText.getText().toString();
        this.mLiveStsApp = this.mStsAppEditText.getText().toString();
        this.mLiveStream = this.mStsStreamEditText.getText().toString();
    }

    private void setGlobaConfig() {
        this.getInputContent();
        GlobalPlayerConfig.mLiveStsUrl = this.mUrl;
        GlobalPlayerConfig.mRegion = this.mRegion;
        GlobalPlayerConfig.mLiveStsAccessKeyId = this.mAccessKeyId;
        GlobalPlayerConfig.mLiveStsSecurityToken = this.mSecurityToken;
        GlobalPlayerConfig.mLiveStsAccessKeySecret = this.mAccessKeySecret;
        GlobalPlayerConfig.mLiveStsDomain = this.mLiveStsDomain;
        GlobalPlayerConfig.mLiveStsApp = this.mLiveStsApp;
        GlobalPlayerConfig.mLiveStsStream = this.mLiveStream;
    }

    @Override
    public void defaultPlayInfo() {
        this.getVideoPlayStsInfo();
    }

    @Override
    public void confirmPlayInfo() {
        this.setGlobaConfig();
        GlobalPlayerConfig.LIVE_STS_TYPE_CHECKED = true;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 4370: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.startCaptureActivityForResult();
                    break;
                }
                ToastUtils.show((Context)this.getActivity(), (String)this.getString(R.string.alivc_player_agree_camera_permission));
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 156: {
                switch (resultCode) {
                    case -1: {
                        String url = data.getStringExtra("qr_scan_result");
                        this.mLiveStsUrlEditText.setText((CharSequence)url);
                        if (TextUtils.isEmpty((CharSequence)url) || !url.contains("://") || !url.contains("?")) return;
                        String str = url.substring(url.indexOf("://") + 3, url.indexOf("?"));
                        String res = str.contains("_") ? str.substring(0, str.lastIndexOf("_")) : str;
                        String[] split = res.split("/");
                        Log.e((String)"AliyunPlayerView", (String)(" QR_Code : " + res));
                        if (split.length < 3) return;
                        this.mStsDomainEditText.setText((CharSequence)split[0]);
                        this.mStsAppEditText.setText((CharSequence)split[1]);
                        if (split[2].contains(".")) {
                            split[2] = split[2].substring(0, split[2].indexOf("."));
                        }
                        this.mStsStreamEditText.setText((CharSequence)split[2]);
                        break;
                    }
                    case 0: {
                        if (data == null) return;
                        this.mLiveStsUrlEditText.setText((CharSequence)data.getStringExtra("qr_scan_result"));
                        break;
                    }
                }
                return;
            }
        }
    }
}

