/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.bottomnavigationbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.bottomnavigationbar.BottomNavigationEntity;
import com.aliyun.svideo.common.bottomnavigationbar.BottomNavigationItemView;
import java.util.ArrayList;
import java.util.List;

public class BottomNavigationBar
extends LinearLayout
implements View.OnClickListener {
    private IBnbItemSelectListener bnbItemSelectListener;
    private IBnbItemDoubleClickListener bnbItemDoubleClickListener;
    private List<BottomNavigationEntity> entities = new ArrayList<BottomNavigationEntity>();
    private int mCurrentPosition = -1;
    private int mTextSelectedColor;
    private int mTextUnSelectedColor;
    private int mItemLayout;
    private boolean isAnim;
    private float scaleRatio;
    private static final String DEFAULT_SELECTED_COLOR = "#000000";
    private static final String DEFAULT_UNSELECTED_COLOR = "#999999";

    public BottomNavigationBar(Context context) {
        this(context, null);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNavigationBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, 0);
        this.init(context, attrs);
    }

    public void setEntities(List<BottomNavigationEntity> list) {
        this.entities.clear();
        this.entities.addAll(list);
        this.addItems();
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.BottomNavigationBar);
        this.mTextSelectedColor = array.getColor(R.styleable.BottomNavigationBar_bnb_selectedColor, Color.parseColor((String)DEFAULT_SELECTED_COLOR));
        this.mTextUnSelectedColor = array.getColor(R.styleable.BottomNavigationBar_bnb_unSelectedColor, Color.parseColor((String)DEFAULT_UNSELECTED_COLOR));
        this.isAnim = array.getBoolean(R.styleable.BottomNavigationBar_bnb_anim, false);
        this.scaleRatio = array.getFloat(R.styleable.BottomNavigationBar_bnb_scale_ratio, 1.1f);
        this.mItemLayout = array.getResourceId(R.styleable.BottomNavigationBar_bnb_layoutId, -1);
        array.recycle();
    }

    private void addItems() {
        if (this.entities.isEmpty()) {
            return;
        }
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
        params.weight = 1.0f;
        for (int i = 0; i < this.entities.size(); ++i) {
            BottomNavigationEntity entity = this.entities.get(i);
            BottomNavigationItemView item = new BottomNavigationItemView(this.getContext());
            item.setLayoutId(this.mItemLayout);
            item.setAnim(this.isAnim);
            item.setScaleRatio(this.scaleRatio);
            item.setBottomNavigationEntity(entity);
            item.setTextSelectedColor(this.mTextSelectedColor);
            item.setTextUnSelectedColor(this.mTextUnSelectedColor);
            item.setTag(i);
            this.addView((View)item, (ViewGroup.LayoutParams)params);
            item.setOnClickListener(this);
            item.setDefaultState();
        }
    }

    public void onClick(View view) {
        int position = (Integer)view.getTag();
        if (position == this.mCurrentPosition && this.bnbItemDoubleClickListener != null) {
            this.bnbItemDoubleClickListener.onBnbItemDoubleClick(position);
            return;
        }
        if (position != this.mCurrentPosition) {
            this.setCurrentPosition(position);
        }
    }

    public void setBnbItemSelectListener(IBnbItemSelectListener listener) {
        this.bnbItemSelectListener = listener;
    }

    public void setBnbItemDoubleClickListener(IBnbItemDoubleClickListener listener) {
        this.bnbItemDoubleClickListener = listener;
    }

    public void setCurrentPosition(int position) {
        int count = this.getChildCount();
        if (count == 0 || position > count) {
            return;
        }
        if (position == this.mCurrentPosition) {
            return;
        }
        BottomNavigationItemView lastItem = (BottomNavigationItemView)this.getChildAt(this.mCurrentPosition);
        BottomNavigationItemView currentItem = (BottomNavigationItemView)this.getChildAt(position);
        if (lastItem != null) {
            lastItem.setSelected(false);
        }
        if (currentItem != null) {
            currentItem.setSelected(true);
        }
        this.mCurrentPosition = position;
        if (this.bnbItemSelectListener != null) {
            this.bnbItemSelectListener.onBnbItemSelect(position);
        }
    }

    public void refreshItem(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.getChildCount()) {
            return;
        }
        BottomNavigationItemView itemView = (BottomNavigationItemView)this.getChildAt(index);
        itemView.refresh();
    }

    public void setAnim(boolean anim2) {
        this.isAnim = anim2;
    }

    public static interface IBnbItemDoubleClickListener {
        public void onBnbItemDoubleClick(int var1);
    }

    public static interface IBnbItemSelectListener {
        public void onBnbItemSelect(int var1);
    }
}

