/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.utils;

import android.content.Context;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class NetUtils {
    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager manager;
        NetworkInfo networkInfo;
        if (context != null && context.getApplicationContext() != null && (networkInfo = (manager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager manager;
        NetworkInfo networkInfo;
        if (context != null && (networkInfo = (manager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && networkInfo.getType() == 1) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager manager;
        NetworkInfo networkInfo;
        if (context != null && (networkInfo = (manager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && networkInfo.getType() == 0) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public static int getConnectedType(Context context) {
        ConnectivityManager manager;
        NetworkInfo networkInfo;
        if (context != null && (networkInfo = (manager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && networkInfo.isAvailable()) {
            return networkInfo.getType();
        }
        return -1;
    }

    public static int getAPNType(Context context) {
        int netType = 0;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        int nType = networkInfo.getType();
        if (nType == 1) {
            netType = 1;
        } else if (nType == 0) {
            int nSubType = networkInfo.getSubtype();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            netType = nSubType == 13 && !telephonyManager.isNetworkRoaming() ? 4 : (nSubType == 3 || nSubType == 8 || nSubType == 5 && !telephonyManager.isNetworkRoaming() ? 3 : (nSubType == 1 || nSubType == 2 || nSubType == 4 && !telephonyManager.isNetworkRoaming() ? 2 : 2));
        }
        return netType;
    }

    public static boolean isGPSEnabled(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        return locationManager.isProviderEnabled("gps");
    }
}

