/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import android.widget.ImageView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class ImageLoader {
    private LoadImgHandler mLoadImgHandler;

    public ImageLoader(ImageView target) {
        this.mLoadImgHandler = new LoadImgHandler(target);
    }

    public void loadAsync(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Bitmap bitmap = ImageLoader.this.getImageBitmap(url);
                Message msg = ImageLoader.this.mLoadImgHandler.obtainMessage();
                msg.obj = bitmap;
                ImageLoader.this.mLoadImgHandler.sendMessage(msg);
            }
        }).start();
    }

    private Bitmap getImageBitmap(String url) {
        URL imgUrl = null;
        Bitmap bitmap = null;
        try {
            imgUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)imgUrl.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setDoInput(true);
            conn.connect();
            InputStream is = conn.getInputStream();
            bitmap = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bitmap;
    }

    private static class LoadImgHandler
    extends Handler {
        private WeakReference<ImageView> imageViewWeakReference;

        LoadImgHandler(ImageView imageView) {
            this.imageViewWeakReference = new WeakReference<ImageView>(imageView);
        }

        public void handleMessage(Message msg) {
            ImageView targetView = (ImageView)this.imageViewWeakReference.get();
            if (targetView == null) {
                return;
            }
            Bitmap bitmap = (Bitmap)msg.obj;
            targetView.setImageBitmap(bitmap);
            super.handleMessage(msg);
        }
    }
}

