/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;

public class ScreenStatusController {
    private String TAG = ScreenStatusController.class.getSimpleName();
    private Context mContext;
    private IntentFilter mScreenStatusFilter = null;
    private ScreenStatusListener mScreenStatusListener = null;
    private BroadcastReceiver mScreenStatusReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.SCREEN_ON".equals(action)) {
                Log.d((String)ScreenStatusController.this.TAG, (String)"ACTION_SCREEN_ON");
                if (ScreenStatusController.this.mScreenStatusListener != null) {
                    ScreenStatusController.this.mScreenStatusListener.onScreenOn();
                }
            } else if ("android.intent.action.SCREEN_OFF".equals(action)) {
                Log.d((String)ScreenStatusController.this.TAG, (String)"ACTION_SCREEN_OFF");
                if (ScreenStatusController.this.mScreenStatusListener != null) {
                    ScreenStatusController.this.mScreenStatusListener.onScreenOff();
                }
            } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                // empty if block
            }
        }
    };

    public ScreenStatusController(Context context) {
        this.mContext = context;
        this.mScreenStatusFilter = new IntentFilter();
        this.mScreenStatusFilter.addAction("android.intent.action.SCREEN_ON");
        this.mScreenStatusFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mScreenStatusFilter.addAction("android.intent.action.USER_PRESENT");
    }

    public void setScreenStatusListener(ScreenStatusListener l) {
        this.mScreenStatusListener = l;
    }

    public void startListen() {
        if (this.mContext != null) {
            this.mContext.registerReceiver(this.mScreenStatusReceiver, this.mScreenStatusFilter);
        }
    }

    public void stopListen() {
        if (this.mContext != null) {
            this.mContext.unregisterReceiver(this.mScreenStatusReceiver);
        }
    }

    public static interface ScreenStatusListener {
        public void onScreenOn();

        public void onScreenOff();
    }
}

