/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util;

import android.os.AsyncTask;
import com.aliyun.player.alivcplayerexpand.util.HttpClientUtil;
import com.aliyun.player.source.VidSts;
import com.cicada.player.utils.Logger;
import org.json.JSONObject;

public class VidStsUtil {
    public static final String BASE_URL = "https://alivc-demo.aliyuncs.com";
    private static final String TAG = VidStsUtil.class.getSimpleName();

    public static VidSts getVidSts(String videoId) {
        try {
            String stsUrl = "https://alivc-demo.aliyuncs.com/demo/getSts";
            String response = HttpClientUtil.doGet(stsUrl);
            JSONObject jsonObject = new JSONObject(response);
            JSONObject securityTokenInfo = jsonObject.getJSONObject("data");
            if (securityTokenInfo == null) {
                return null;
            }
            String accessKeyId = securityTokenInfo.getString("accessKeyId");
            String accessKeySecret = securityTokenInfo.getString("accessKeySecret");
            String securityToken = securityTokenInfo.getString("securityToken");
            String expiration = securityTokenInfo.getString("expiration");
            VidSts vidSts = new VidSts();
            vidSts.setVid(videoId);
            vidSts.setAccessKeyId(accessKeyId);
            vidSts.setAccessKeySecret(accessKeySecret);
            vidSts.setSecurityToken(securityToken);
            return vidSts;
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)("e = " + e.getMessage()));
            return null;
        }
    }

    public static void getVidSts(final String vid, final OnStsResultListener onStsResultListener) {
        AsyncTask<Void, Void, VidSts> asyncTask = new AsyncTask<Void, Void, VidSts>(){

            protected VidSts doInBackground(Void ... params) {
                return VidStsUtil.getVidSts(vid);
            }

            protected void onPostExecute(VidSts s) {
                if (s == null) {
                    onStsResultListener.onFail();
                } else {
                    onStsResultListener.onSuccess(s.getVid(), s.getAccessKeyId(), s.getAccessKeySecret(), s.getSecurityToken());
                }
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    public static interface OnStsResultListener {
        public void onSuccess(String var1, String var2, String var3, String var4);

        public void onFail();
    }
}

