/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.download;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.aliyun.downloader.AliDownloaderFactory;
import com.aliyun.downloader.AliMediaDownloader;
import com.aliyun.downloader.DownloaderConfig;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.bean.LongVideoBean;
import com.aliyun.player.alivcplayerexpand.constants.GlobalPlayerConfig;
import com.aliyun.player.alivcplayerexpand.listener.RefreshStsCallback;
import com.aliyun.player.alivcplayerexpand.util.VidStsUtil;
import com.aliyun.player.alivcplayerexpand.util.database.DatabaseManager;
import com.aliyun.player.alivcplayerexpand.util.database.LoadDbDatasListener;
import com.aliyun.player.alivcplayerexpand.util.database.LoadDbTvListDatasListenerr;
import com.aliyun.player.alivcplayerexpand.util.database.LongVideoDatabaseManager;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadInfoListener;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.util.download.DownloadUtils;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.nativeclass.MediaInfo;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidSts;
import com.aliyun.svideo.common.utils.ThreadUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AliyunDownloadManager {
    public static final String TAG = "AliyunDownloadManager";
    public static final String MEMORY_LESS_MSG = "memory_less";
    public static final int INTENT_STATE_START = 0;
    public static final int INTENT_STATE_STOP = 1;
    public static final int INTENT_STATE_ADD = 2;
    private static final int MAX_NUM = 5;
    private static final int MIN_NUM = 1;
    public static final int VID_STS = 0;
    public static final int VID_AUTH = 1;
    private int mMaxNum = 3;
    private String downloadDir;
    private String encryptFilePath;
    private static volatile AliyunDownloadManager mInstance = null;
    private LinkedHashMap<AliyunDownloadMediaInfo, AliMediaDownloader> downloadInfos = new LinkedHashMap();
    private ConcurrentLinkedQueue<AliyunDownloadMediaInfo> preparedList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AliyunDownloadMediaInfo> downloadingList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AliyunDownloadMediaInfo> completedList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AliyunDownloadMediaInfo> waitedList = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<AliyunDownloadMediaInfo> stopedList = new ConcurrentLinkedQueue();
    private List<AliyunDownloadInfoListener> outListenerList = new ArrayList<AliyunDownloadInfoListener>();
    private DatabaseManager mDatabaseManager;
    private LongVideoDatabaseManager mLongVideoDatabaseManager;
    private long freshStorageSizeTime = 0L;
    private List<AliMediaDownloader> mJniDownloadLists = new ArrayList<AliMediaDownloader>();
    private Context mContext;
    private VidAuth mVidAuth;
    private VidSts mVidSts;
    private DownloaderConfig mDownloaderConfig = new DownloaderConfig();
    private AliyunDownloadInfoListener innerDownloadInfoListener = new AliyunDownloadInfoListener(){

        @Override
        public void onPrepared(final List<AliyunDownloadMediaInfo> infos) {
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onPrepared(infos);
                    }
                }
            });
        }

        @Override
        public void onAdd(final AliyunDownloadMediaInfo info) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    AliyunDownloadManager.this.prepareMediaInfo(info);
                    List<AliyunDownloadMediaInfo> downloadMediaInfos = AliyunDownloadManager.this.mDatabaseManager.selectAll();
                    if (downloadMediaInfos.contains(info)) {
                        int n = AliyunDownloadManager.this.mDatabaseManager.update(info);
                    } else {
                        AliyunDownloadManager.this.mDatabaseManager.insert(info);
                    }
                }
            });
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onAdd(info);
                    }
                }
            });
        }

        @Override
        public void onStart(final AliyunDownloadMediaInfo info) {
            AliyunDownloadManager.this.startMediaInfo(info);
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<AliyunDownloadMediaInfo> downloadMediaInfos = AliyunDownloadManager.this.mDatabaseManager.selectAll();
                    boolean hasContains = false;
                    if (TextUtils.isEmpty((CharSequence)info.getTvId())) {
                        AliyunDownloadMediaInfo downloadMediaInfo;
                        Iterator<AliyunDownloadMediaInfo> iterator = downloadMediaInfos.iterator();
                        while (iterator.hasNext() && !(hasContains = AliyunDownloadManager.this.judgeEquals(downloadMediaInfo = iterator.next(), info))) {
                        }
                    } else {
                        hasContains = downloadMediaInfos.contains(info);
                    }
                    if (hasContains) {
                        int n = AliyunDownloadManager.this.mDatabaseManager.update(info);
                    } else {
                        AliyunDownloadManager.this.mDatabaseManager.insert(info);
                    }
                }
            });
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onStart(info);
                    }
                }
            });
        }

        @Override
        public void onProgress(final AliyunDownloadMediaInfo info, final int percent) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (AliyunDownloadManager.this.freshStorageSizeTime == 0L || new Date().getTime() - AliyunDownloadManager.this.freshStorageSizeTime > 2000L) {
                        int update = AliyunDownloadManager.this.mDatabaseManager.update(info);
                        if (DownloadUtils.isStorageAlarm(AliyunDownloadManager.this.mContext)) {
                            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AliyunDownloadManager.this.stopDownloads(AliyunDownloadManager.this.downloadingList);
                                    AliyunDownloadManager.this.stopDownloads(AliyunDownloadManager.this.waitedList);
                                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                                        aliyunDownloadInfoListener.onError(info, ErrorCode.ERROR_UNKNOWN_ERROR, AliyunDownloadManager.MEMORY_LESS_MSG, null);
                                    }
                                }
                            });
                        }
                        AliyunDownloadManager.this.freshStorageSizeTime = new Date().getTime();
                    }
                }
            });
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        info.setStatus(AliyunDownloadMediaInfo.Status.Start);
                        aliyunDownloadInfoListener.onProgress(info, percent);
                    }
                }
            });
        }

        @Override
        public void onWait(final AliyunDownloadMediaInfo outMediaInfo) {
            AliyunDownloadManager.this.waitMediaInfo(outMediaInfo);
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onWait(outMediaInfo);
                    }
                }
            });
        }

        @Override
        public void onDelete(final AliyunDownloadMediaInfo info) {
            AliyunDownloadManager.this.deleteMediaInfo(info);
            AliyunDownloadManager.this.mDatabaseManager.delete(info);
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onDelete(info);
                    }
                }
            });
        }

        @Override
        public void onDeleteAll() {
            AliyunDownloadManager.this.deleteAllMediaInfo();
            AliyunDownloadManager.this.mDatabaseManager.deleteAll();
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onDeleteAll();
                    }
                }
            });
        }

        @Override
        public void onFileProgress(final AliyunDownloadMediaInfo mediaInfo) {
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.File);
                        aliyunDownloadInfoListener.onFileProgress(mediaInfo);
                    }
                }
            });
        }

        @Override
        public void onStop(final AliyunDownloadMediaInfo info) {
            AliyunDownloadManager.this.stopMediaInfo(info);
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    int update = AliyunDownloadManager.this.mDatabaseManager.update(info);
                }
            });
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onStop(info);
                    }
                }
            });
        }

        @Override
        public void onCompletion(AliyunDownloadMediaInfo info) {
            AliyunDownloadManager.this.completedMediaInfo(info);
            AliMediaDownloader jniDownloader = (AliMediaDownloader)AliyunDownloadManager.this.downloadInfos.get(info);
            if (jniDownloader == null) {
                return;
            }
            info.setSavePath(jniDownloader.getFilePath());
            int update = AliyunDownloadManager.this.mDatabaseManager.update(info);
            for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                aliyunDownloadInfoListener.onCompletion(info);
            }
        }

        @Override
        public void onError(final AliyunDownloadMediaInfo info, final ErrorCode code, final String msg, final String requestId) {
            AliyunDownloadManager.this.errorMediaInfo(info, code, msg);
            ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (AliyunDownloadInfoListener aliyunDownloadInfoListener : AliyunDownloadManager.this.outListenerList) {
                        aliyunDownloadInfoListener.onError(info, code, msg, requestId);
                    }
                }
            });
        }
    };

    private AliyunDownloadManager(Context context) {
        File file;
        this.mContext = context;
        this.mDatabaseManager = DatabaseManager.getInstance();
        this.mLongVideoDatabaseManager = LongVideoDatabaseManager.getInstance();
        if (!TextUtils.isEmpty((CharSequence)this.downloadDir) && !(file = new File(this.downloadDir)).exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliyunDownloadManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<AliyunDownloadManager> clazz = AliyunDownloadManager.class;
        synchronized (AliyunDownloadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new AliyunDownloadManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void setDownloaderConfig(DownloaderConfig downloaderConfig) {
        this.mDownloaderConfig = downloaderConfig;
    }

    public DownloaderConfig getDownloaderConfig() {
        return this.mDownloaderConfig;
    }

    public void setDownloadInfoListener(AliyunDownloadInfoListener listener) {
        this.outListenerList.clear();
        if (listener != null) {
            this.outListenerList.add(listener);
        }
    }

    public void addDownloadInfoListener(AliyunDownloadInfoListener listener) {
        if (this.outListenerList == null) {
            this.outListenerList = new ArrayList<AliyunDownloadInfoListener>();
        }
        if (listener != null && !this.outListenerList.contains(listener)) {
            this.outListenerList.add(listener);
        }
    }

    private boolean judgeEquals(AliyunDownloadMediaInfo mediaInfo1, AliyunDownloadMediaInfo mediaInfo2) {
        if (mediaInfo1 == null || mediaInfo2 == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)mediaInfo1.getVid()) && mediaInfo1.getVid().equals(mediaInfo2.getVid()) && !TextUtils.isEmpty((CharSequence)mediaInfo1.getQuality()) && mediaInfo1.getQuality().equals(mediaInfo2.getQuality()) && !TextUtils.isEmpty((CharSequence)mediaInfo1.getFormat()) && mediaInfo1.getFormat().equals(mediaInfo2.getFormat());
    }

    public int getMaxNum() {
        return this.mMaxNum;
    }

    public void setMaxNum(int mMaxNum) {
        if (mMaxNum <= 1) {
            mMaxNum = 1;
        }
        if (mMaxNum > 5) {
            mMaxNum = 5;
        }
        this.mMaxNum = mMaxNum;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(String downloadDir) {
        this.downloadDir = downloadDir;
    }

    public String getEncryptFilePath() {
        return this.encryptFilePath;
    }

    public void setEncryptFilePath(String encryptFilePath) {
        if (TextUtils.isEmpty((CharSequence)encryptFilePath)) {
            return;
        }
        this.encryptFilePath = encryptFilePath;
    }

    private void prepareDownload(VidSts vidSts, List<AliyunDownloadMediaInfo> mediaInfos) {
        if (vidSts == null || mediaInfos == null) {
            return;
        }
        for (final AliyunDownloadMediaInfo aliyunDownloadMediaInfo : mediaInfos) {
            vidSts.setVid(aliyunDownloadMediaInfo.getVid());
            aliyunDownloadMediaInfo.setVidSts(vidSts);
            if (aliyunDownloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Start || aliyunDownloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Prepare) {
                aliyunDownloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
            }
            final AliMediaDownloader jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
            jniDownloader.setSaveDir(this.downloadDir);
            jniDownloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

                public void onPrepared(MediaInfo mediaInfo) {
                    if (AliyunDownloadManager.this.downloadInfos != null && mediaInfo.getVideoId().equals(aliyunDownloadMediaInfo.getVid())) {
                        List trackInfos = mediaInfo.getTrackInfos();
                        for (TrackInfo trackInfo : trackInfos) {
                            if (trackInfo == null || !trackInfo.getVodDefinition().equals(aliyunDownloadMediaInfo.getQuality())) continue;
                            aliyunDownloadMediaInfo.setTrackInfo(trackInfo);
                            AliyunDownloadManager.this.downloadInfos.put(aliyunDownloadMediaInfo, jniDownloader);
                        }
                    }
                }
            });
            this.setErrorListener(jniDownloader, aliyunDownloadMediaInfo);
            jniDownloader.setDownloaderConfig(this.mDownloaderConfig);
            jniDownloader.prepare(vidSts);
        }
    }

    public void addDownload(VidSts vidSts, AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        if (vidSts == null || aliyunDownloadMediaInfo == null) {
            return;
        }
        if (this.preparedList.contains(aliyunDownloadMediaInfo) || this.stopedList.contains(aliyunDownloadMediaInfo) || this.waitedList.contains(aliyunDownloadMediaInfo) || this.downloadingList.contains(aliyunDownloadMediaInfo) || this.completedList.contains(aliyunDownloadMediaInfo)) {
            return;
        }
        vidSts.setVid(aliyunDownloadMediaInfo.getVid());
        aliyunDownloadMediaInfo.setVidSts(vidSts);
        AliMediaDownloader jniDownloader = this.downloadInfos.get(aliyunDownloadMediaInfo);
        if (jniDownloader == null || aliyunDownloadMediaInfo.getTrackInfo() == null) {
            this.prepareDownloadByQuality(aliyunDownloadMediaInfo, 2);
        } else {
            jniDownloader.setSaveDir(this.downloadDir);
            jniDownloader.selectItem(aliyunDownloadMediaInfo.getTrackInfo().getIndex());
            if (this.innerDownloadInfoListener != null) {
                this.innerDownloadInfoListener.onAdd(aliyunDownloadMediaInfo);
            }
            this.setErrorListener(jniDownloader, aliyunDownloadMediaInfo);
        }
    }

    public void prepareDownloadByLongVideoBean(final VidSts vidSts, final LongVideoBean longVideoBean) {
        if (vidSts == null || TextUtils.isEmpty((CharSequence)vidSts.getVid())) {
            return;
        }
        final ArrayList downloadMediaInfos = new ArrayList();
        final AliMediaDownloader jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
        jniDownloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

            public void onPrepared(MediaInfo mediaInfo) {
                AliyunDownloadManager.this.onPreparedCallback(vidSts, mediaInfo, downloadMediaInfos, longVideoBean);
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onPrepared(downloadMediaInfos);
                }
                AliyunDownloadManager.this.mJniDownloadLists.remove(jniDownloader);
            }
        });
        jniDownloader.setOnErrorListener(new AliMediaDownloader.OnErrorListener(){

            public void onError(ErrorInfo errorInfo) {
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadMediaInfo mediaInfo = new AliyunDownloadMediaInfo();
                    mediaInfo.setVidSts(vidSts);
                    AliyunDownloadManager.this.innerDownloadInfoListener.onError(mediaInfo, errorInfo.getCode(), errorInfo.getMsg(), null);
                    AliyunDownloadManager.this.mJniDownloadLists.remove(jniDownloader);
                    jniDownloader.release();
                }
            }
        });
        jniDownloader.setDownloaderConfig(this.mDownloaderConfig);
        jniDownloader.prepare(vidSts);
        this.mJniDownloadLists.add(jniDownloader);
    }

    public void prepareDownloadLists(final VidSts vidSts, AliyunDownloadMediaInfo mediaInfo) {
        if (vidSts == null || TextUtils.isEmpty((CharSequence)vidSts.getVid())) {
            return;
        }
        final ArrayList downloadMediaInfos = new ArrayList();
        AliMediaDownloader jniDownloader = this.downloadInfos.get(mediaInfo);
        if (jniDownloader != null) {
            return;
        }
        jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
        jniDownloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

            public void onPrepared(MediaInfo mediaInfo) {
                AliyunDownloadManager.this.onPreparedCallback(vidSts, mediaInfo, downloadMediaInfos, null);
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onPrepared(downloadMediaInfos);
                }
            }
        });
        mediaInfo.setVidSts(vidSts);
        this.setErrorListener(jniDownloader, mediaInfo);
        jniDownloader.setDownloaderConfig(this.mDownloaderConfig);
        jniDownloader.prepare(vidSts);
    }

    public void prepareDownload(final VidSts vidSts) {
        if (vidSts == null || TextUtils.isEmpty((CharSequence)vidSts.getVid())) {
            return;
        }
        this.mVidSts = vidSts;
        final ArrayList downloadMediaInfos = new ArrayList();
        final AliMediaDownloader jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
        jniDownloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

            public void onPrepared(MediaInfo mediaInfo) {
                AliyunDownloadManager.this.onPreparedCallback(vidSts, mediaInfo, downloadMediaInfos, null);
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onPrepared(downloadMediaInfos);
                }
                AliyunDownloadManager.this.mJniDownloadLists.remove(jniDownloader);
            }
        });
        AliyunDownloadMediaInfo mediaInfo = new AliyunDownloadMediaInfo();
        mediaInfo.setVidSts(vidSts);
        this.setErrorListener(jniDownloader, mediaInfo);
        jniDownloader.setDownloaderConfig(this.mDownloaderConfig);
        jniDownloader.prepare(vidSts);
        this.mJniDownloadLists.add(jniDownloader);
    }

    public void prepareDownload(final VidAuth vidAuth) {
        if (vidAuth == null || TextUtils.isEmpty((CharSequence)vidAuth.getVid())) {
            return;
        }
        this.mVidAuth = vidAuth;
        final ArrayList downloadMediaInfos = new ArrayList();
        AliMediaDownloader downloader = AliDownloaderFactory.create((Context)this.mContext);
        downloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

            public void onPrepared(MediaInfo mediaInfo) {
                List trackInfos = mediaInfo.getTrackInfos();
                for (TrackInfo trackInfo : trackInfos) {
                    TrackInfo.Type type = trackInfo.getType();
                    if (type != TrackInfo.Type.TYPE_VOD) continue;
                    AliyunDownloadMediaInfo downloadMediaInfo = new AliyunDownloadMediaInfo();
                    downloadMediaInfo.setVid(vidAuth.getVid());
                    downloadMediaInfo.setQuality(trackInfo.getVodDefinition());
                    downloadMediaInfo.setTitle(mediaInfo.getTitle());
                    downloadMediaInfo.setCoverUrl(mediaInfo.getCoverUrl());
                    downloadMediaInfo.setDuration(mediaInfo.getDuration());
                    downloadMediaInfo.setTrackInfo(trackInfo);
                    downloadMediaInfo.setQualityIndex(trackInfo.getIndex());
                    downloadMediaInfo.setFormat(trackInfo.getVodFormat());
                    downloadMediaInfo.setSize(trackInfo.getVodFileSize());
                    downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
                    downloadMediaInfo.setVidAuth(vidAuth);
                    downloadMediaInfo.setVidType(1);
                    downloadMediaInfos.add(downloadMediaInfo);
                    AliMediaDownloader itemAliMediaDownloader = AliDownloaderFactory.create((Context)AliyunDownloadManager.this.mContext);
                    itemAliMediaDownloader.setSaveDir(AliyunDownloadManager.this.downloadDir);
                    AliyunDownloadManager.this.downloadInfos.put(downloadMediaInfo, itemAliMediaDownloader);
                }
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onPrepared(downloadMediaInfos);
                }
            }
        });
        this.setErrorListener(downloader, null);
        downloader.setDownloaderConfig(this.mDownloaderConfig);
        downloader.prepare(vidAuth);
    }

    private void onPreparedCallback(VidSts vidSts, MediaInfo mediaInfo, List<AliyunDownloadMediaInfo> downloadMediaInfos, LongVideoBean longVideoBean) {
        List trackInfos = mediaInfo.getTrackInfos();
        for (TrackInfo trackInfo : trackInfos) {
            TrackInfo.Type type = trackInfo.getType();
            if (type != TrackInfo.Type.TYPE_VOD) continue;
            VidSts mVidSts = new VidSts();
            mVidSts.setVid(mediaInfo.getVideoId());
            mVidSts.setAccessKeyId(vidSts.getAccessKeyId());
            mVidSts.setSecurityToken(vidSts.getSecurityToken());
            mVidSts.setAccessKeySecret(vidSts.getAccessKeySecret());
            AliyunDownloadMediaInfo downloadMediaInfo = new AliyunDownloadMediaInfo();
            downloadMediaInfo.setVid(mediaInfo.getVideoId());
            downloadMediaInfo.setQuality(trackInfo.getVodDefinition());
            downloadMediaInfo.setTitle(mediaInfo.getTitle());
            downloadMediaInfo.setCoverUrl(mediaInfo.getCoverUrl());
            downloadMediaInfo.setDuration(mediaInfo.getDuration());
            downloadMediaInfo.setTrackInfo(trackInfo);
            downloadMediaInfo.setQualityIndex(trackInfo.getIndex());
            downloadMediaInfo.setFormat(trackInfo.getVodFormat());
            downloadMediaInfo.setSize(trackInfo.getVodFileSize());
            downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
            downloadMediaInfo.setVidType(0);
            downloadMediaInfo.setVidSts(mVidSts);
            if (longVideoBean != null) {
                downloadMediaInfo.setTvId(longVideoBean.getTvId());
                downloadMediaInfo.setTvName(longVideoBean.getTvName());
                downloadMediaInfo.setTvCoverUrl(longVideoBean.getTvCoverUrl());
            }
            downloadMediaInfos.add(downloadMediaInfo);
            AliMediaDownloader aliMediaDownloader = this.downloadInfos.get(downloadMediaInfo);
            if (aliMediaDownloader == null) {
                aliMediaDownloader = AliDownloaderFactory.create((Context)this.mContext);
            }
            aliMediaDownloader.setSaveDir(this.downloadDir);
            this.downloadInfos.put(downloadMediaInfo, aliMediaDownloader);
        }
    }

    public void prepareDownloadByQuality(final AliyunDownloadMediaInfo downloadMediaInfo, final int intentState) {
        if (downloadMediaInfo == null) {
            return;
        }
        final ArrayList downloadMediaInfos = new ArrayList();
        final AliMediaDownloader jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
        jniDownloader.setSaveDir(this.downloadDir);
        jniDownloader.setOnPreparedListener(new AliMediaDownloader.OnPreparedListener(){

            public void onPrepared(MediaInfo mediaInfo) {
                List trackInfos = mediaInfo.getTrackInfos();
                for (TrackInfo trackInfo : trackInfos) {
                    TrackInfo.Type type = trackInfo.getType();
                    if (type != TrackInfo.Type.TYPE_VOD || !trackInfo.getVodDefinition().equals(downloadMediaInfo.getQuality())) continue;
                    downloadMediaInfo.setQuality(trackInfo.getVodDefinition());
                    downloadMediaInfo.setTitle(mediaInfo.getTitle());
                    downloadMediaInfo.setCoverUrl(mediaInfo.getCoverUrl());
                    downloadMediaInfo.setDuration(mediaInfo.getDuration());
                    downloadMediaInfo.setTrackInfo(trackInfo);
                    downloadMediaInfo.setQualityIndex(trackInfo.getIndex());
                    downloadMediaInfo.setFormat(trackInfo.getVodFormat());
                    downloadMediaInfo.setSize(trackInfo.getVodFileSize());
                    downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
                    downloadMediaInfos.add(downloadMediaInfo);
                    AliyunDownloadManager.this.downloadInfos.put(downloadMediaInfo, jniDownloader);
                    jniDownloader.selectItem(trackInfo.getIndex());
                    if (intentState == 0) {
                        if (AliyunDownloadManager.this.downloadingList.size() <= AliyunDownloadManager.this.mMaxNum) {
                            AliyunDownloadManager.this.setListener(downloadMediaInfo, jniDownloader);
                            jniDownloader.start();
                            if (AliyunDownloadManager.this.innerDownloadInfoListener == null) continue;
                            AliyunDownloadManager.this.innerDownloadInfoListener.onStart(downloadMediaInfo);
                            continue;
                        }
                        if (AliyunDownloadManager.this.innerDownloadInfoListener == null) continue;
                        AliyunDownloadManager.this.innerDownloadInfoListener.onWait(downloadMediaInfo);
                        continue;
                    }
                    if (intentState == 1) {
                        AliyunDownloadManager.this.executeDelete(downloadMediaInfo);
                        continue;
                    }
                    jniDownloader.setSaveDir(AliyunDownloadManager.this.downloadDir);
                    jniDownloader.selectItem(downloadMediaInfo.getTrackInfo().getIndex());
                    if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                        AliyunDownloadManager.this.innerDownloadInfoListener.onAdd(downloadMediaInfo);
                    }
                    AliyunDownloadManager.this.setErrorListener(jniDownloader, downloadMediaInfo);
                }
            }
        });
        this.setErrorListener(jniDownloader, null);
        jniDownloader.setDownloaderConfig(this.mDownloaderConfig);
        if (downloadMediaInfo.getVidType() == 0) {
            if (downloadMediaInfo.getVidSts() == null) {
                this.mVidSts.setVid(downloadMediaInfo.getVid());
                jniDownloader.prepare(this.mVidSts);
            } else {
                jniDownloader.prepare(downloadMediaInfo.getVidSts());
            }
        } else if (downloadMediaInfo.getVidAuth() == null) {
            this.mVidAuth.setVid(downloadMediaInfo.getVid());
            jniDownloader.prepare(this.mVidAuth);
        } else {
            jniDownloader.prepare(downloadMediaInfo.getVidAuth());
        }
    }

    public void startDownload(AliyunDownloadMediaInfo downloadMediaInfo) {
        String savePath;
        File file;
        if (downloadMediaInfo == null) {
            return;
        }
        AliyunDownloadMediaInfo.Status status = downloadMediaInfo.getStatus();
        if (status == AliyunDownloadMediaInfo.Status.Start || this.downloadingList.contains(downloadMediaInfo)) {
            return;
        }
        if (downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete && (file = new File(savePath = downloadMediaInfo.getSavePath())).exists()) {
            Toast.makeText((Context)this.mContext.getApplicationContext(), (CharSequence)this.mContext.getResources().getString(R.string.alivc_video_download_finish_tips), (int)0).show();
            return;
        }
        if (DownloadUtils.isStorageAlarm(this.mContext, downloadMediaInfo)) {
            if (this.downloadingList.size() < this.mMaxNum) {
                AliMediaDownloader jniDownloader = this.downloadInfos.get(downloadMediaInfo);
                if (jniDownloader == null) {
                    jniDownloader = AliDownloaderFactory.create((Context)this.mContext);
                    jniDownloader.setSaveDir(this.downloadDir);
                    this.downloadInfos.put(downloadMediaInfo, jniDownloader);
                }
                jniDownloader.selectItem(downloadMediaInfo.getQualityIndex());
                this.setListener(downloadMediaInfo, jniDownloader);
                if (downloadMediaInfo.getVidType() == 1) {
                    if (downloadMediaInfo.getVidAuth() == null) {
                        if (this.innerDownloadInfoListener != null) {
                            this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN, this.mContext.getString(R.string.alivc_player_video_download_sts_and_auth_is_empty), "");
                        }
                        return;
                    }
                    jniDownloader.updateSource(downloadMediaInfo.getVidAuth());
                } else {
                    if (this.mVidSts == null) {
                        if (this.innerDownloadInfoListener != null) {
                            this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN, this.mContext.getString(R.string.alivc_player_video_download_sts_and_auth_is_empty), "");
                        }
                        return;
                    }
                    this.mVidSts.setVid(downloadMediaInfo.getVid());
                    jniDownloader.updateSource(this.mVidSts);
                }
                jniDownloader.start();
                if (this.innerDownloadInfoListener != null) {
                    this.innerDownloadInfoListener.onStart(downloadMediaInfo);
                }
            } else if (!this.waitedList.contains(downloadMediaInfo) && this.innerDownloadInfoListener != null) {
                this.innerDownloadInfoListener.onWait(downloadMediaInfo);
            }
        } else if (this.innerDownloadInfoListener != null) {
            this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN_ERROR, MEMORY_LESS_MSG, null);
        }
    }

    public void pauseDownload(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (downloadMediaInfo == null || this.downloadInfos == null) {
            return;
        }
        if (downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete || downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Error || downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Stop) {
            return;
        }
        AliMediaDownloader jniDownloader = this.downloadInfos.get(downloadMediaInfo);
        if (jniDownloader == null) {
            return;
        }
        jniDownloader.stop();
        if (this.innerDownloadInfoListener != null) {
            this.innerDownloadInfoListener.onStop(downloadMediaInfo);
        }
        this.autoDownload();
    }

    public void stopDownload(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (downloadMediaInfo == null || this.downloadInfos == null) {
            return;
        }
        if (downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete || downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Error || downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Stop) {
            return;
        }
        AliMediaDownloader jniDownloader = this.downloadInfos.get(downloadMediaInfo);
        if (jniDownloader == null) {
            return;
        }
        jniDownloader.stop();
        this.releaseJniDownloader(downloadMediaInfo);
        if (this.innerDownloadInfoListener != null) {
            this.innerDownloadInfoListener.onStop(downloadMediaInfo);
        }
        this.autoDownload();
    }

    public void stopDownloads(ConcurrentLinkedQueue<AliyunDownloadMediaInfo> downloadMediaInfos) {
        if (downloadMediaInfos == null || downloadMediaInfos.size() == 0 || this.downloadInfos == null) {
            return;
        }
        for (AliyunDownloadMediaInfo downloadMediaInfo : downloadMediaInfos) {
            AliMediaDownloader jniDownloader;
            if (downloadMediaInfo.getStatus() != AliyunDownloadMediaInfo.Status.Start && downloadMediaInfo.getStatus() != AliyunDownloadMediaInfo.Status.Wait || (jniDownloader = this.downloadInfos.get(downloadMediaInfo)) == null || downloadMediaInfo.getStatus() != AliyunDownloadMediaInfo.Status.Start) continue;
            jniDownloader.stop();
            this.releaseJniDownloader(downloadMediaInfo);
            if (this.innerDownloadInfoListener == null) continue;
            this.innerDownloadInfoListener.onStop(downloadMediaInfo);
        }
    }

    public void deleteFile(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (downloadMediaInfo == null || this.downloadInfos == null) {
            return;
        }
        if (downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Delete) {
            return;
        }
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Delete);
        this.executeDelete(downloadMediaInfo);
    }

    private void executeDelete(AliyunDownloadMediaInfo downloadMediaInfo) {
        int ret;
        AliMediaDownloader jniDownloader = this.downloadInfos.get(downloadMediaInfo);
        if (downloadMediaInfo == null) {
            if (this.innerDownloadInfoListener != null) {
                this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN_ERROR, this.mContext.getResources().getString(R.string.alivc_player_delete_failed), null);
            }
            return;
        }
        String saveDir = this.getDownloadDir();
        String vid = downloadMediaInfo.getVid();
        String format = downloadMediaInfo.getFormat();
        int index = downloadMediaInfo.getQualityIndex();
        if (jniDownloader != null) {
            jniDownloader.stop();
            this.releaseJniDownloader(downloadMediaInfo);
        }
        if ((ret = AliDownloaderFactory.deleteFile((String)saveDir, (String)vid, (String)format, (int)index)) == 12 || ret == 11) {
            Log.e((String)TAG, (String)("deleteFile warning  ret = " + ret));
            if (this.innerDownloadInfoListener != null) {
                this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN_ERROR, this.mContext.getResources().getString(R.string.alivc_player_delete_failed), null);
            }
        }
        if (this.innerDownloadInfoListener != null) {
            this.innerDownloadInfoListener.onDelete(downloadMediaInfo);
        }
        this.autoDownload();
    }

    private void getVidSts(final AliyunDownloadMediaInfo downloadMediaInfo, final int intentState) {
        VidStsUtil.getVidSts(GlobalPlayerConfig.mVid, new VidStsUtil.OnStsResultListener(){

            @Override
            public void onSuccess(String vid, String akid, String akSecret, String token) {
                VidSts vidSts = new VidSts();
                vidSts.setVid(downloadMediaInfo.getVid());
                vidSts.setRegion("cn-shanghai");
                vidSts.setAccessKeyId(akid);
                vidSts.setSecurityToken(token);
                vidSts.setAccessKeySecret(akSecret);
                vidSts.setQuality(downloadMediaInfo.getQuality(), false);
                downloadMediaInfo.setVidSts(vidSts);
                AliyunDownloadManager.this.prepareDownloadByQuality(downloadMediaInfo, intentState);
            }

            @Override
            public void onFail() {
                ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)AliyunDownloadManager.this.mContext.getApplicationContext(), (CharSequence)AliyunDownloadManager.this.mContext.getResources().getString(R.string.alivc_player_get_sts_failed), (int)0).show();
                        if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                            AliyunDownloadManager.this.innerDownloadInfoListener.onError(downloadMediaInfo, ErrorCode.ERROR_UNKNOWN_ERROR, AliyunDownloadManager.this.mContext.getResources().getString(R.string.alivc_player_get_sts_failed), null);
                        }
                    }
                });
            }
        });
    }

    public void deleteAllFile() {
        for (AliyunDownloadMediaInfo mediaInfo : this.preparedList) {
            this.deleteFile(mediaInfo);
        }
        for (AliyunDownloadMediaInfo mediaInfo : this.downloadingList) {
            this.deleteFile(mediaInfo);
        }
        for (AliyunDownloadMediaInfo mediaInfo : this.completedList) {
            this.deleteFile(mediaInfo);
        }
        for (AliyunDownloadMediaInfo mediaInfo : this.waitedList) {
            this.deleteFile(mediaInfo);
        }
        for (AliyunDownloadMediaInfo mediaInfo : this.stopedList) {
            this.deleteFile(mediaInfo);
        }
    }

    private void setListener(final AliyunDownloadMediaInfo downloadMediaInfo, AliMediaDownloader jniDownloader) {
        jniDownloader.setOnProgressListener(new AliMediaDownloader.OnProgressListener(){

            public void onDownloadingProgress(int percent) {
                Log.e((String)AliyunDownloadManager.TAG, (String)("onDownloadingProgress\u5185\u90e8\u4e0b\u8f7d : " + percent));
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    downloadMediaInfo.setProgress(percent);
                    AliyunDownloadManager.this.innerDownloadInfoListener.onProgress(downloadMediaInfo, percent);
                }
            }

            public void onProcessingProgress(int percent) {
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    downloadMediaInfo.setmFileHandleProgress(percent);
                    AliyunDownloadManager.this.innerDownloadInfoListener.onFileProgress(downloadMediaInfo);
                }
            }
        });
        jniDownloader.setOnCompletionListener(new AliMediaDownloader.OnCompletionListener(){

            public void onCompletion() {
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onCompletion(downloadMediaInfo);
                }
                AliyunDownloadManager.this.releaseJniDownloader(downloadMediaInfo);
            }
        });
        this.setErrorListener(jniDownloader, downloadMediaInfo);
    }

    public void initDownloading(LinkedList<AliyunDownloadMediaInfo> list) {
        if (this.downloadingList.size() != 0) {
            this.downloadingList.clear();
        }
        this.downloadingList.addAll(list);
    }

    public void initCompleted(LinkedList<AliyunDownloadMediaInfo> list) {
        if (this.completedList.size() != 0) {
            this.completedList.clear();
        }
        this.completedList.addAll(list);
    }

    private void autoDownload() {
        AliyunDownloadMediaInfo aliyunDownloadMediaInfo;
        if (this.downloadingList.size() < this.mMaxNum && this.waitedList.size() > 0 && (aliyunDownloadMediaInfo = this.waitedList.peek()).getStatus() == AliyunDownloadMediaInfo.Status.Wait) {
            this.startDownload(aliyunDownloadMediaInfo);
        }
    }

    private void deleteAllMediaInfo() {
        this.preparedList.clear();
        this.waitedList.clear();
        this.downloadingList.clear();
        this.stopedList.clear();
        this.completedList.clear();
        this.downloadInfos.clear();
    }

    private void deleteMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        Iterator<AliyunDownloadMediaInfo> preparedIterator = this.preparedList.iterator();
        while (preparedIterator.hasNext()) {
            if (!preparedIterator.next().equals(downloadMediaInfo)) continue;
            preparedIterator.remove();
        }
        Iterator<AliyunDownloadMediaInfo> waitedIterator = this.waitedList.iterator();
        while (waitedIterator.hasNext()) {
            if (!waitedIterator.next().equals(downloadMediaInfo)) continue;
            waitedIterator.remove();
        }
        Iterator<AliyunDownloadMediaInfo> downloadingIterator = this.downloadingList.iterator();
        while (downloadingIterator.hasNext()) {
            if (!downloadingIterator.next().equals(downloadMediaInfo)) continue;
            downloadingIterator.remove();
        }
        Iterator<AliyunDownloadMediaInfo> stopedIterator = this.stopedList.iterator();
        while (stopedIterator.hasNext()) {
            if (!stopedIterator.next().equals(downloadMediaInfo)) continue;
            stopedIterator.remove();
        }
        Iterator<AliyunDownloadMediaInfo> completedIterator = this.completedList.iterator();
        while (completedIterator.hasNext()) {
            if (!completedIterator.next().equals(downloadMediaInfo)) continue;
            completedIterator.remove();
        }
        this.downloadInfos.remove(downloadMediaInfo);
    }

    private void waitMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (!this.waitedList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.waitedList.add(downloadMediaInfo);
        }
        this.preparedList.remove(downloadMediaInfo);
        this.downloadingList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Wait);
    }

    private void stopMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (!this.stopedList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.stopedList.add(downloadMediaInfo);
        }
        this.downloadingList.remove(downloadMediaInfo);
        this.preparedList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
    }

    private void prepareMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (!this.preparedList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.preparedList.add(downloadMediaInfo);
        }
        this.downloadingList.remove(downloadMediaInfo);
        this.completedList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
    }

    private void startMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (!this.downloadingList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.downloadingList.add(downloadMediaInfo);
        }
        this.preparedList.remove(downloadMediaInfo);
        this.stopedList.remove(downloadMediaInfo);
        this.completedList.remove(downloadMediaInfo);
        this.waitedList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Start);
    }

    private void completedMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (!this.completedList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.completedList.add(downloadMediaInfo);
        }
        this.downloadingList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Complete);
        this.autoDownload();
    }

    private void errorMediaInfo(AliyunDownloadMediaInfo downloadMediaInfo, ErrorCode code, String msg) {
        if (downloadMediaInfo == null) {
            return;
        }
        if (!this.stopedList.contains(downloadMediaInfo) && downloadMediaInfo != null) {
            this.stopedList.add(downloadMediaInfo);
        }
        this.preparedList.remove(downloadMediaInfo);
        this.downloadingList.remove(downloadMediaInfo);
        this.completedList.remove(downloadMediaInfo);
        this.waitedList.remove(downloadMediaInfo);
        downloadMediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Error);
        downloadMediaInfo.setErrorCode(code);
        downloadMediaInfo.setErrorMsg(msg);
        this.autoDownload();
    }

    public void removeDownloadInfoListener(AliyunDownloadInfoListener listener) {
        if (listener != null && this.outListenerList != null) {
            this.outListenerList.remove(listener);
        }
    }

    public void findDatasByDb(final VidSts vidSts, final LoadDbDatasListener listener) {
        if (this.mDatabaseManager != null) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<AliyunDownloadMediaInfo> selectPreparedList = AliyunDownloadManager.this.mDatabaseManager.selectPreparedList();
                    List<AliyunDownloadMediaInfo> selectStopedList = AliyunDownloadManager.this.mDatabaseManager.selectStopedList();
                    List<AliyunDownloadMediaInfo> selectCompletedList = AliyunDownloadManager.this.mDatabaseManager.selectCompletedList();
                    List<AliyunDownloadMediaInfo> selectDownloadingList = AliyunDownloadManager.this.mDatabaseManager.selectDownloadingList();
                    final ArrayList<AliyunDownloadMediaInfo> dataList = new ArrayList<AliyunDownloadMediaInfo>();
                    dataList.addAll(selectCompletedList);
                    dataList.addAll(selectStopedList);
                    dataList.addAll(selectPreparedList);
                    for (AliyunDownloadMediaInfo mediaInfo : selectPreparedList) {
                        mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
                    }
                    for (AliyunDownloadMediaInfo mediaInfo : selectDownloadingList) {
                        mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
                    }
                    dataList.addAll(selectDownloadingList);
                    if (AliyunDownloadManager.this.stopedList != null) {
                        AliyunDownloadManager.this.stopedList.addAll(selectDownloadingList);
                        AliyunDownloadManager.this.stopedList.addAll(selectStopedList);
                        AliyunDownloadManager.this.stopedList.addAll(selectPreparedList);
                    }
                    if (AliyunDownloadManager.this.completedList != null) {
                        AliyunDownloadManager.this.completedList.addAll(selectCompletedList);
                    }
                    ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AliyunDownloadManager.this.prepareDownload(vidSts, dataList);
                            if (listener != null) {
                                listener.onLoadSuccess(dataList);
                            }
                        }
                    });
                }
            });
        }
    }

    public void findDatasByDb(final LoadDbDatasListener listener) {
        if (this.mDatabaseManager != null) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<AliyunDownloadMediaInfo> selectPreparedList = AliyunDownloadManager.this.mDatabaseManager.selectPreparedList();
                    List<AliyunDownloadMediaInfo> selectStopedList = AliyunDownloadManager.this.mDatabaseManager.selectStopedList();
                    List<AliyunDownloadMediaInfo> selectCompletedList = AliyunDownloadManager.this.mDatabaseManager.selectCompletedList();
                    List<AliyunDownloadMediaInfo> selectDownloadingList = AliyunDownloadManager.this.mDatabaseManager.selectDownloadingList();
                    List<AliyunDownloadMediaInfo> selectWaitList = AliyunDownloadManager.this.mDatabaseManager.selectWaitList();
                    final ArrayList<AliyunDownloadMediaInfo> dataList = new ArrayList<AliyunDownloadMediaInfo>();
                    if (selectPreparedList != null) {
                        for (AliyunDownloadMediaInfo mediaInfo : selectPreparedList) {
                            mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
                        }
                        dataList.addAll(selectPreparedList);
                    }
                    if (selectStopedList != null) {
                        dataList.addAll(selectStopedList);
                    }
                    if (selectCompletedList != null) {
                        dataList.addAll(selectCompletedList);
                    }
                    if (selectDownloadingList != null) {
                        for (AliyunDownloadMediaInfo mediaInfo : selectDownloadingList) {
                            mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Stop);
                        }
                        dataList.addAll(selectDownloadingList);
                    }
                    if (selectWaitList != null) {
                        dataList.addAll(selectWaitList);
                    }
                    if (AliyunDownloadManager.this.stopedList != null) {
                        if (selectDownloadingList != null) {
                            AliyunDownloadManager.this.stopedList.addAll(selectDownloadingList);
                        }
                        if (selectStopedList != null) {
                            AliyunDownloadManager.this.stopedList.addAll(selectStopedList);
                        }
                        if (selectPreparedList != null) {
                            AliyunDownloadManager.this.stopedList.addAll(selectPreparedList);
                        }
                    }
                    if (AliyunDownloadManager.this.completedList != null && selectCompletedList != null) {
                        AliyunDownloadManager.this.completedList.addAll(selectCompletedList);
                    }
                    ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                listener.onLoadSuccess(dataList);
                            }
                        }
                    });
                }
            });
        }
    }

    public void findDatasByDbTv(final LoadDbDatasListener listener) {
        if (this.mDatabaseManager != null) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<AliyunDownloadMediaInfo> selectPreparedList = AliyunDownloadManager.this.mDatabaseManager.selectPreparedList();
                    List<AliyunDownloadMediaInfo> selectStopedList = AliyunDownloadManager.this.mDatabaseManager.selectStopedList();
                    List<AliyunDownloadMediaInfo> selectCompletedList = AliyunDownloadManager.this.mDatabaseManager.selectCompletedList();
                    List<AliyunDownloadMediaInfo> selectDownloadingList = AliyunDownloadManager.this.mDatabaseManager.selectDownloadingList();
                    List<AliyunDownloadMediaInfo> selectWaitList = AliyunDownloadManager.this.mDatabaseManager.selectWaitList();
                    List<AliyunDownloadMediaInfo> selectWatchedList = AliyunDownloadManager.this.mDatabaseManager.selectWatchedList();
                    ArrayList<AliyunDownloadMediaInfo> dataList = new ArrayList<AliyunDownloadMediaInfo>();
                    if (selectCompletedList != null) {
                        dataList.addAll(selectCompletedList);
                    }
                    if (selectStopedList != null) {
                        dataList.addAll(selectStopedList);
                    }
                    if (selectPreparedList != null) {
                        dataList.addAll(selectPreparedList);
                    }
                    if (selectDownloadingList != null) {
                        dataList.addAll(selectDownloadingList);
                    }
                    if (selectWaitList != null) {
                        dataList.addAll(selectWaitList);
                    }
                    if (AliyunDownloadManager.this.stopedList != null && selectStopedList != null) {
                        AliyunDownloadManager.this.stopedList.addAll(selectStopedList);
                    }
                    if (AliyunDownloadManager.this.completedList != null) {
                        AliyunDownloadManager.this.completedList.addAll(selectCompletedList);
                    }
                    final List aliyunDownloadMediaInfos = AliyunDownloadManager.this.removeDuplicate(selectWatchedList, dataList);
                    ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (listener != null) {
                                listener.onLoadSuccess(aliyunDownloadMediaInfos);
                            }
                        }
                    });
                }
            });
        }
    }

    private List<AliyunDownloadMediaInfo> removeDuplicate(List<AliyunDownloadMediaInfo> selectWatchedList, List<AliyunDownloadMediaInfo> dataList) {
        for (AliyunDownloadMediaInfo mediaInfo : dataList) {
            for (AliyunDownloadMediaInfo watchedMediaInfo : selectWatchedList) {
                if (!watchedMediaInfo.getVid().equals(mediaInfo.getVid())) continue;
                mediaInfo.setWatchNumber(1);
            }
        }
        long size = 0L;
        int watchNum = 0;
        int num = 0;
        for (int i = 0; i < dataList.size(); ++i) {
            size = dataList.get(i).getSize();
            watchNum = dataList.get(i).getWatchNumber();
            num = dataList.get(i).getNumber();
            for (int j = dataList.size() - 1; j > i; --j) {
                if (TextUtils.isEmpty((CharSequence)dataList.get(j).getTvId()) || TextUtils.isEmpty((CharSequence)dataList.get(i).getTvId()) || !dataList.get(j).getTvId().equals(dataList.get(i).getTvId())) continue;
                size += dataList.get(j).getSize();
                watchNum += dataList.get(j).getWatchNumber();
                num += dataList.get(j).getNumber();
                dataList.remove(j);
            }
            dataList.get(i).setSize(size);
            dataList.get(i).setWatchNumber(watchNum);
            dataList.get(i).setNumber(num);
        }
        return dataList;
    }

    public void getDownloadMediaInfoWithTvId(final String tvId, final LoadDbTvListDatasListenerr loadDbDatasListener) {
        if (this.mDatabaseManager != null) {
            ThreadUtils.runOnSubThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    List<LongVideoBean> longVideoBeans = AliyunDownloadManager.this.mLongVideoDatabaseManager.selectAllWatchHistory();
                    final List<AliyunDownloadMediaInfo> aliyunDownloadMediaInfos = AliyunDownloadManager.this.mDatabaseManager.selectAllByTvId(tvId);
                    if (aliyunDownloadMediaInfos != null) {
                        for (AliyunDownloadMediaInfo mediaInfo : aliyunDownloadMediaInfos) {
                            for (LongVideoBean longVideoBean : longVideoBeans) {
                                if (!longVideoBean.getVideoId().equals(mediaInfo.getVid())) continue;
                                mediaInfo.setWatchNumber(1);
                            }
                        }
                    }
                    ThreadUtils.runOnUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (loadDbDatasListener != null) {
                                loadDbDatasListener.onLoadTvListSuccess(aliyunDownloadMediaInfos);
                            }
                        }
                    });
                }
            });
        }
    }

    public ConcurrentLinkedQueue<AliyunDownloadMediaInfo> getPreparedList() {
        return this.preparedList;
    }

    public ConcurrentLinkedQueue<AliyunDownloadMediaInfo> getCompletedList() {
        return this.completedList;
    }

    public ConcurrentLinkedQueue<AliyunDownloadMediaInfo> getDownloadingList() {
        return this.downloadingList;
    }

    public ConcurrentLinkedQueue<AliyunDownloadMediaInfo> getWaitedList() {
        return this.waitedList;
    }

    public ConcurrentLinkedQueue<AliyunDownloadMediaInfo> getStopedList() {
        return this.stopedList;
    }

    public void release() {
        if (this.mDatabaseManager != null) {
            this.mDatabaseManager.close();
        }
        if (this.preparedList != null) {
            this.preparedList.clear();
        }
        if (this.downloadingList != null) {
            this.downloadingList.clear();
        }
        if (this.completedList != null) {
            this.completedList.clear();
        }
        if (this.waitedList != null) {
            this.waitedList.clear();
        }
        if (this.outListenerList != null) {
            this.outListenerList.clear();
        }
        if (this.mJniDownloadLists != null) {
            this.mJniDownloadLists.clear();
        }
    }

    public void clearList() {
        if (this.preparedList != null) {
            this.preparedList.clear();
        }
        if (!this.downloadInfos.isEmpty()) {
            for (Map.Entry<AliyunDownloadMediaInfo, AliMediaDownloader> next : this.downloadInfos.entrySet()) {
                next.getValue().stop();
            }
            this.downloadInfos.clear();
        }
        if (this.downloadingList != null) {
            this.downloadingList.clear();
        }
        if (this.completedList != null) {
            this.completedList.clear();
        }
        if (this.waitedList != null) {
            this.waitedList.clear();
        }
        if (this.outListenerList != null) {
            this.outListenerList.clear();
        }
        if (this.stopedList != null) {
            this.stopedList.clear();
        }
    }

    public void setRefreshStsCallback(RefreshStsCallback refreshStsCallback) {
    }

    public void insertDb(AliyunDownloadMediaInfo mediaInfo) {
        if (mediaInfo == null || this.mDatabaseManager == null) {
            return;
        }
        mediaInfo.setStatus(AliyunDownloadMediaInfo.Status.Prepare);
        int itemCount = this.mDatabaseManager.selectItemExist(mediaInfo);
        if (itemCount <= 0) {
            this.mDatabaseManager.insert(mediaInfo);
        }
    }

    public void updateDb(AliyunDownloadMediaInfo mediaInfo) {
        if (mediaInfo == null || this.mDatabaseManager == null) {
            return;
        }
        this.mDatabaseManager.update(mediaInfo);
    }

    public VidAuth getmVidAuth() {
        return this.mVidAuth;
    }

    public void setmVidAuth(VidAuth mVidAuth) {
        this.mVidAuth = mVidAuth;
    }

    public VidSts getmVidSts() {
        return this.mVidSts;
    }

    public void setmVidSts(VidSts mVidSts) {
        this.mVidSts = mVidSts;
    }

    private void setErrorListener(final AliMediaDownloader jniDownloader, final AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        if (jniDownloader == null) {
            return;
        }
        jniDownloader.setOnErrorListener(new AliMediaDownloader.OnErrorListener(){

            public void onError(ErrorInfo errorInfo) {
                if (AliyunDownloadManager.this.innerDownloadInfoListener != null) {
                    AliyunDownloadManager.this.innerDownloadInfoListener.onError(aliyunDownloadMediaInfo, errorInfo.getCode(), errorInfo.getMsg(), errorInfo.getExtra());
                }
                if (aliyunDownloadMediaInfo == null) {
                    jniDownloader.release();
                } else {
                    AliyunDownloadManager.this.releaseJniDownloader(aliyunDownloadMediaInfo);
                }
            }
        });
    }

    private void releaseJniDownloader(AliyunDownloadMediaInfo downloadMediaInfo) {
        if (this.downloadInfos != null && this.downloadInfos.containsKey(downloadMediaInfo)) {
            AliMediaDownloader aliMediaDownloader = this.downloadInfos.get(downloadMediaInfo);
            if (aliMediaDownloader != null) {
                aliMediaDownloader.release();
            }
            this.downloadInfos.remove(downloadMediaInfo);
        }
    }
}

