/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.download;

import android.os.Parcel;
import android.text.TextUtils;
import com.aliyun.player.alivcplayerexpand.util.JsonUtil;
import com.aliyun.player.bean.ErrorCode;
import com.aliyun.player.nativeclass.TrackInfo;
import com.aliyun.player.source.VidAuth;
import com.aliyun.player.source.VidSts;
import com.cicada.player.utils.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AliyunDownloadMediaInfo {
    private static final String TAG = AliyunDownloadMediaInfo.class.getSimpleName();
    private String mVid;
    private String mQuality;
    private int mProgress = 0;
    private String mSavePath = null;
    private String mTitle;
    private String mCoverUrl;
    private long mDuration;
    private Status mStatus;
    private long mSize;
    private String mFormat;
    private int mDownloadIndex = 0;
    private int isEncripted = 0;
    private TrackInfo mTrackInfo;
    private VidSts mVidSts;
    private ErrorCode errorCode;
    private String errorMsg;
    private int mFileHandleProgress = 0;
    private int mQualityIndex;
    private String mTvId;
    private boolean isSelected;
    private int number = 1;
    private int watchNumber = 0;
    private String mTvName;
    private String mTvCoverUrl;
    private int mWatched;
    private VidAuth vidAuth;
    private int vidType;

    public VidAuth getVidAuth() {
        return this.vidAuth;
    }

    public void setVidAuth(VidAuth vidAuth) {
        this.vidAuth = vidAuth;
    }

    public int getVidType() {
        return this.vidType;
    }

    public void setVidType(int vidType) {
        this.vidType = vidType;
    }

    public int getWatched() {
        return this.mWatched;
    }

    public void setWatched(int mWatched) {
        this.mWatched = mWatched;
    }

    public String getTvCoverUrl() {
        return this.mTvCoverUrl;
    }

    public void setTvCoverUrl(String mTvCoverUrl) {
        this.mTvCoverUrl = mTvCoverUrl;
    }

    public int getWatchNumber() {
        return this.watchNumber;
    }

    public void setWatchNumber(int watchNumber) {
        this.watchNumber = watchNumber;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    protected AliyunDownloadMediaInfo(Parcel in) {
        this.mVid = in.readString();
        this.mQuality = in.readString();
        this.mProgress = in.readInt();
        this.mSavePath = in.readString();
        this.mTitle = in.readString();
        this.mCoverUrl = in.readString();
        this.mDuration = in.readLong();
        this.mSize = in.readLong();
        this.mFormat = in.readString();
        this.mDownloadIndex = in.readInt();
        this.isEncripted = in.readInt();
        this.errorMsg = in.readString();
        this.mFileHandleProgress = in.readInt();
        this.mQualityIndex = in.readInt();
        this.mTvId = in.readString();
        this.isSelected = in.readByte() != 0;
    }

    public String getTvName() {
        return this.mTvName;
    }

    public void setTvName(String mTvName) {
        this.mTvName = mTvName;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public String getTvId() {
        return this.mTvId;
    }

    public void setTvId(String mTvId) {
        this.mTvId = mTvId;
    }

    public AliyunDownloadMediaInfo() {
    }

    public int getQualityIndex() {
        return this.mQualityIndex;
    }

    public void setQualityIndex(int mQualityIndex) {
        this.mQualityIndex = mQualityIndex;
    }

    public int getmFileHandleProgress() {
        return this.mFileHandleProgress;
    }

    public void setmFileHandleProgress(int mFileHandleProgress) {
        this.mFileHandleProgress = mFileHandleProgress;
    }

    public int getDownloadIndex() {
        return this.mDownloadIndex;
    }

    public void setDownloadIndex(int mDownloadIndex) {
        this.mDownloadIndex = mDownloadIndex;
    }

    public String getVid() {
        return this.mVid;
    }

    public void setVid(String mVid) {
        this.mVid = mVid;
    }

    public String getQuality() {
        return this.mQuality;
    }

    public void setQuality(String mQuality) {
        this.mQuality = mQuality;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int mProgress) {
        this.mProgress = mProgress;
    }

    public String getSavePath() {
        return this.mSavePath;
    }

    public void setSavePath(String mSavePath) {
        this.mSavePath = mSavePath;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public String getCoverUrl() {
        return this.mCoverUrl;
    }

    public void setCoverUrl(String coverUrl) {
        this.mCoverUrl = coverUrl;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public void setDuration(long duration) {
        this.mDuration = duration;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public void setStatus(Status mStatus) {
        this.mStatus = mStatus;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getSizeStr() {
        int kbSize = (int)((float)this.mSize / 1024.0f);
        return kbSize < 1024 ? kbSize + "KB" : (float)kbSize / 1024.0f + "MB";
    }

    public void setSize(long mSize) {
        this.mSize = mSize;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String mFormat) {
        this.mFormat = mFormat;
    }

    public int isEncripted() {
        return this.isEncripted;
    }

    public void setEncripted(int encripted) {
        this.isEncripted = encripted;
    }

    public TrackInfo getTrackInfo() {
        return this.mTrackInfo;
    }

    public void setTrackInfo(TrackInfo mTrackInfo) {
        this.mTrackInfo = mTrackInfo;
    }

    public VidSts getVidSts() {
        return this.mVidSts;
    }

    public void setVidSts(VidSts mVidSts) {
        this.mVidSts = mVidSts;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public static String getJsonFromInfos(List<AliyunDownloadMediaInfo> infos) {
        JSONArray jsonArray = new JSONArray();
        if (infos != null && !infos.isEmpty()) {
            for (AliyunDownloadMediaInfo info : infos) {
                JSONObject infoJsonobject = AliyunDownloadMediaInfo.formatInfoToJsonobj(info);
                if (infoJsonobject == null) continue;
                jsonArray.put((Object)infoJsonobject);
            }
            return jsonArray.toString();
        }
        return jsonArray.toString();
    }

    private static JSONObject formatInfoToJsonobj(AliyunDownloadMediaInfo info) {
        if (info == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("vid", (Object)info.getVid());
            jsonObject.put("quality", (Object)info.getQuality());
            jsonObject.put("format", (Object)info.getFormat());
            jsonObject.put("coverUrl", (Object)info.getCoverUrl());
            jsonObject.put("duration", info.getDuration());
            jsonObject.put("title", (Object)info.getTitle());
            jsonObject.put("savePath", (Object)info.getSavePath());
            jsonObject.put("status", (Object)info.getStatus());
            jsonObject.put("size", info.getSize());
            jsonObject.put("progress", info.getProgress());
            jsonObject.put("dIndex", info.getDownloadIndex());
            jsonObject.put("encript", info.isEncripted());
            return jsonObject;
        }
        catch (JSONException var3) {
            Logger.e((String)TAG, (String)("e : " + var3.getMessage()));
            return null;
        }
    }

    public static List<AliyunDownloadMediaInfo> getInfosFromJson(String infoContent) {
        if (TextUtils.isEmpty((CharSequence)infoContent)) {
            return null;
        }
        JSONArray jsonArray = null;
        try {
            jsonArray = new JSONArray(infoContent);
        }
        catch (JSONException var8) {
            Logger.d((String)TAG, (String)(" e..." + (Object)((Object)var8)));
        }
        if (jsonArray == null) {
            return null;
        }
        ArrayList<AliyunDownloadMediaInfo> infos = new ArrayList<AliyunDownloadMediaInfo>();
        int size = jsonArray.length();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                AliyunDownloadMediaInfo info = AliyunDownloadMediaInfo.getInfoFromJson(jsonObject);
                infos.add(info);
                continue;
            }
            catch (JSONException var7) {
                Logger.d((String)TAG, (String)(" e..." + (Object)((Object)var7)));
            }
        }
        return infos;
    }

    private static AliyunDownloadMediaInfo getInfoFromJson(JSONObject jsonObject) {
        AliyunDownloadMediaInfo info = new AliyunDownloadMediaInfo();
        info.setVid(JsonUtil.getString(jsonObject, "vid"));
        info.setTitle(JsonUtil.getString(jsonObject, "title"));
        info.setQuality(JsonUtil.getString(jsonObject, "quality"));
        info.setFormat(JsonUtil.getString(jsonObject, "format"));
        info.setCoverUrl(JsonUtil.getString(jsonObject, "coverUrl"));
        info.setDuration(JsonUtil.getInt(jsonObject, "duration"));
        info.setSavePath(JsonUtil.getString(jsonObject, "savePath"));
        info.setStatus(Status.valueOf(JsonUtil.getString(jsonObject, "status")));
        info.setSize(JsonUtil.getInt(jsonObject, "size"));
        info.setProgress(JsonUtil.getInt(jsonObject, "progress"));
        info.setDownloadIndex(JsonUtil.getInt(jsonObject, "dIndex"));
        info.setEncripted(JsonUtil.getInt(jsonObject, "encript"));
        return info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || TextUtils.isEmpty((CharSequence)this.mVid) || TextUtils.isEmpty((CharSequence)this.mQuality)) {
            return false;
        }
        AliyunDownloadMediaInfo that = (AliyunDownloadMediaInfo)o;
        if (TextUtils.isEmpty((CharSequence)this.mTvId) && TextUtils.isEmpty((CharSequence)that.mTvId)) {
            return this.mVid.equals(that.mVid) && this.mQuality.equals(that.mQuality);
        }
        return this.mVid.equals(that.mVid);
    }

    public int hashCode() {
        Object[] hashObject = new Object[]{this.mVid, this.mQuality};
        return Arrays.hashCode(hashObject);
    }

    public static enum Status {
        Idle,
        Prepare,
        Wait,
        Start,
        Stop,
        Complete,
        Error,
        Delete,
        File;

    }
}

