/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.aliyun.player.alivcplayerexpand.widget.IRenderView;

public class SurfaceRenderView
extends SurfaceView
implements IRenderView,
SurfaceHolder.Callback {
    private IRenderView.IRenderCallback mRenderCallback;

    public SurfaceRenderView(Context context) {
        super(context);
        this.init(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public SurfaceRenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.setSecure(true);
        }
        Log.e((String)"AliLivePlayerView", (String)"init: SurfaceRenderView");
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @Override
    public void addRenderCallback(IRenderView.IRenderCallback renderCallback) {
        this.mRenderCallback = renderCallback;
    }

    @Override
    public View getView() {
        return this;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceCreate(surfaceHolder.getSurface());
        }
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int format, int width, int height) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceChanged(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Surface surface = surfaceHolder.getSurface();
        if (surface != null) {
            surface.release();
        }
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceDestroyed();
        }
    }
}

