/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunlistplayer.view;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.aliyun.player.AliListPlayer;
import com.aliyun.player.AliPlayerFactory;
import com.aliyun.player.IPlayer;
import com.aliyun.player.aliyunlistplayer.R;
import com.aliyun.player.aliyunlistplayer.adapter.AliyunRecyclerViewAdapter;
import com.aliyun.player.aliyunlistplayer.adapter.PagerLayoutManager;
import com.aliyun.player.aliyunlistplayer.listener.OnViewPagerListener;
import com.aliyun.player.aliyunlistplayer.view.RecyclerViewEmptySupport;
import com.aliyun.player.aliyunplayerbase.bean.AliyunVideoListBean;
import com.aliyun.player.aliyunplayerbase.bean.VideoSourceType;
import com.aliyun.player.aliyunplayerbase.view.refresh.AlivcSwipeRefreshLayout;
import com.aliyun.player.bean.ErrorInfo;
import com.aliyun.player.bean.InfoBean;
import com.aliyun.player.nativeclass.PlayerConfig;
import com.aliyun.player.source.StsInfo;
import com.aliyun.svideo.common.utils.ToastUtils;
import java.util.Iterator;
import java.util.List;

public class AliyunListPlayerView
extends FrameLayout {
    private View mListPlayerContainer;
    private ImageView mPlayIconImageView;
    private TextureView mListPlayerTextureView;
    private RecyclerViewEmptySupport mListPlayerRecyclerView;
    private AliyunRecyclerViewAdapter mRecyclerViewAdapter;
    private AliListPlayer mAliListPlayer;
    private StsInfo mStsInfo;
    private PagerLayoutManager mPagerLayoutManager;
    private static final int DEFAULT_PRELOAD_NUMBER = 5;
    private GestureDetector mGestureDetector;
    private SparseArray<String> mSparseArray;
    private int mCurrentPosition;
    private int mLastStopPosition = -1;
    private boolean isEnd;
    private boolean mIsOnBackground;
    private boolean mIsPause;
    private AlivcSwipeRefreshLayout mRefreshView;
    private boolean mIsLoadingData;
    private OnRefreshDataListener onRefreshDataListener;
    private TextView mRefreshTextView;
    private List<AliyunVideoListBean.VideoDataBean.VideoListBean> mVideoListBean;

    public AliyunListPlayerView(Context context) {
        super(context);
        this.initVideoView();
    }

    public AliyunListPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView();
    }

    public AliyunListPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView();
    }

    private void initVideoView() {
        this.initListPlayer();
        this.initListPlayerView();
        this.initPagerLayoutManager();
        this.initRecyclerView();
    }

    private void initListPlayer() {
        this.mAliListPlayer = AliPlayerFactory.createAliListPlayer((Context)this.getContext());
        this.mAliListPlayer.setLoop(true);
        PlayerConfig config = this.mAliListPlayer.getConfig();
        config.mClearFrameWhenStop = true;
        this.mAliListPlayer.setConfig(config);
        this.mAliListPlayer.setOnPreparedListener(new IPlayer.OnPreparedListener(){

            public void onPrepared() {
                if (!AliyunListPlayerView.this.mIsPause && !AliyunListPlayerView.this.mIsOnBackground) {
                    AliyunListPlayerView.this.mAliListPlayer.start();
                }
            }
        });
        this.mAliListPlayer.setOnRenderingStartListener(new IPlayer.OnRenderingStartListener(){

            public void onRenderingStart() {
                AliyunRecyclerViewAdapter.MyViewHolder mViewHolder;
                if (AliyunListPlayerView.this.mListPlayerRecyclerView != null && (mViewHolder = (AliyunRecyclerViewAdapter.MyViewHolder)AliyunListPlayerView.this.mListPlayerRecyclerView.findViewHolderForLayoutPosition(AliyunListPlayerView.this.mCurrentPosition)) != null) {
                    mViewHolder.getCoverView().setVisibility(8);
                }
            }
        });
        this.mAliListPlayer.setOnInfoListener(new IPlayer.OnInfoListener(){

            public void onInfo(InfoBean infoBean) {
            }
        });
        this.mAliListPlayer.setOnErrorListener(new IPlayer.OnErrorListener(){

            public void onError(ErrorInfo errorInfo) {
                ToastUtils.show((Context)AliyunListPlayerView.this.getContext(), (String)(errorInfo.getCode() + " --- " + errorInfo.getMsg()));
            }
        });
    }

    private void initListPlayerView() {
        this.mListPlayerContainer = View.inflate((Context)this.getContext(), (int)R.layout.layout_list_player_view, null);
        this.mPlayIconImageView = (ImageView)this.mListPlayerContainer.findViewById(R.id.iv_play_icon);
        this.mListPlayerTextureView = (TextureView)this.mListPlayerContainer.findViewById(R.id.list_player_textureview);
        this.mListPlayerTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                Surface mSurface = new Surface(surfaceTexture);
                if (AliyunListPlayerView.this.mAliListPlayer != null) {
                    AliyunListPlayerView.this.mAliListPlayer.setSurface(mSurface);
                    AliyunListPlayerView.this.mAliListPlayer.redraw();
                }
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                if (AliyunListPlayerView.this.mAliListPlayer != null) {
                    AliyunListPlayerView.this.mAliListPlayer.redraw();
                }
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                AliyunListPlayerView.this.onPauseClick();
                return true;
            }

            public boolean onDown(MotionEvent e) {
                return true;
            }
        });
        this.mListPlayerContainer.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return AliyunListPlayerView.this.mGestureDetector.onTouchEvent(motionEvent);
            }
        });
    }

    private void initRecyclerView() {
        View mListPlayerRecyclerViewRoot = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_list_player_recyclerview, (ViewGroup)this, true);
        this.mListPlayerRecyclerView = (RecyclerViewEmptySupport)mListPlayerRecyclerViewRoot.findViewById(R.id.list_player_recyclerview);
        this.mRefreshView = (AlivcSwipeRefreshLayout)mListPlayerRecyclerViewRoot.findViewById(R.id.refresh_view);
        this.mRefreshTextView = (TextView)mListPlayerRecyclerViewRoot.findViewById(R.id.tv_refresh);
        this.mRefreshView.setColorSchemeColors(new int[]{-256, -16711936, -16776961, -65536});
        this.mRefreshView.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (AliyunListPlayerView.this.onRefreshDataListener != null) {
                    AliyunListPlayerView.this.mIsLoadingData = true;
                    AliyunListPlayerView.this.onRefreshDataListener.onRefresh();
                }
            }
        });
        this.mRefreshTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AliyunListPlayerView.this.mRefreshView != null) {
                    AliyunListPlayerView.this.mRefreshView.setRefreshing(true);
                }
                if (AliyunListPlayerView.this.onRefreshDataListener != null) {
                    AliyunListPlayerView.this.mIsLoadingData = true;
                    AliyunListPlayerView.this.onRefreshDataListener.onRefresh();
                }
            }
        });
        this.mListPlayerRecyclerView.setHasFixedSize(true);
        this.mListPlayerRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mPagerLayoutManager);
        this.mListPlayerRecyclerView.setEmptyView(mListPlayerRecyclerViewRoot.findViewById(R.id.rl_empty_view));
        this.mRecyclerViewAdapter = new AliyunRecyclerViewAdapter(this.getContext());
        this.mListPlayerRecyclerView.setAdapter(this.mRecyclerViewAdapter);
    }

    private void initPagerLayoutManager() {
        if (this.mPagerLayoutManager == null) {
            this.mPagerLayoutManager = new PagerLayoutManager(this.getContext());
            this.mPagerLayoutManager.setItemPrefetchEnabled(true);
        }
        if (this.mPagerLayoutManager.viewPagerListenerIsNull()) {
            this.mPagerLayoutManager.setOnViewPagerListener(new OnViewPagerListener(){

                @Override
                public void onInitComplete() {
                    int itemCount;
                    int position = AliyunListPlayerView.this.mPagerLayoutManager.findFirstVisibleItemPosition();
                    if (position != -1) {
                        AliyunListPlayerView.this.mCurrentPosition = position;
                    }
                    if ((itemCount = AliyunListPlayerView.this.mRecyclerViewAdapter.getItemCount()) - position < 5 && !AliyunListPlayerView.this.mIsLoadingData && !AliyunListPlayerView.this.isEnd) {
                        AliyunListPlayerView.this.mIsLoadingData = true;
                        AliyunListPlayerView.this.loadMore();
                    }
                    AliyunListPlayerView.this.startPlay(AliyunListPlayerView.this.mCurrentPosition);
                    AliyunListPlayerView.this.mLastStopPosition = -1;
                }

                @Override
                public void onPageRelease(boolean isNext, int position, View view) {
                    if (AliyunListPlayerView.this.mCurrentPosition == position) {
                        AliyunListPlayerView.this.mLastStopPosition = position;
                        AliyunListPlayerView.this.stopPlay();
                        AliyunRecyclerViewAdapter.MyViewHolder holder = (AliyunRecyclerViewAdapter.MyViewHolder)AliyunListPlayerView.this.mListPlayerRecyclerView.findViewHolderForLayoutPosition(position);
                        if (holder != null) {
                            holder.getCoverView().setVisibility(0);
                        }
                    }
                }

                @Override
                public void onPageSelected(int position, boolean bottom, View view) {
                    if (AliyunListPlayerView.this.mCurrentPosition == position && AliyunListPlayerView.this.mLastStopPosition != position) {
                        return;
                    }
                    int itemCount = AliyunListPlayerView.this.mRecyclerViewAdapter.getItemCount();
                    if (itemCount == position + 1 && AliyunListPlayerView.this.isEnd) {
                        Toast.makeText((Context)AliyunListPlayerView.this.getContext(), (int)R.string.alivc_player_tip_last_video, (int)0).show();
                    }
                    if (itemCount - position < 5 && !AliyunListPlayerView.this.mIsLoadingData && !AliyunListPlayerView.this.isEnd) {
                        AliyunListPlayerView.this.mIsLoadingData = true;
                        AliyunListPlayerView.this.loadMore();
                    }
                    AliyunListPlayerView.this.startPlay(position);
                    AliyunListPlayerView.this.mCurrentPosition = position;
                }
            });
        }
    }

    private void loadMore() {
        if (this.onRefreshDataListener != null) {
            this.onRefreshDataListener.onLoadMore();
        }
    }

    private void startPlay(int position) {
        if (position < 0 || position > this.mVideoListBean.size()) {
            return;
        }
        this.mIsPause = false;
        this.mPlayIconImageView.setVisibility(8);
        AliyunRecyclerViewAdapter.MyViewHolder mViewHolder = (AliyunRecyclerViewAdapter.MyViewHolder)this.mListPlayerRecyclerView.findViewHolderForLayoutPosition(position);
        ViewParent parent = this.mListPlayerContainer.getParent();
        if (parent instanceof FrameLayout) {
            ((ViewGroup)parent).removeView(this.mListPlayerContainer);
        }
        if (mViewHolder != null) {
            mViewHolder.getContainerView().addView(this.mListPlayerContainer, 0);
        }
        if (!this.mIsOnBackground) {
            this.mAliListPlayer.moveTo((String)this.mSparseArray.get(position), this.mStsInfo);
        }
    }

    public void onPauseClick() {
        if (this.mIsPause) {
            this.resumePlay();
        } else {
            this.pausePlay();
        }
    }

    public void setStsInfo(StsInfo stsInfo) {
        this.mStsInfo = stsInfo;
    }

    public void moveTo(String uuid) {
        if (this.mAliListPlayer != null) {
            this.mAliListPlayer.moveTo(uuid);
        }
    }

    public void moveTo(String uuid, StsInfo stsInfo) {
        if (this.mAliListPlayer != null) {
            this.mAliListPlayer.moveTo(uuid, stsInfo);
        }
    }

    public void addVid(String videoId, String randomUUID) {
        if (this.mAliListPlayer != null) {
            this.mAliListPlayer.addVid(videoId, randomUUID);
        }
    }

    public void setData(List<AliyunVideoListBean.VideoDataBean.VideoListBean> videoListBeanItems) {
        this.clearNotShowVideo(videoListBeanItems);
        this.isEnd = false;
        this.mIsLoadingData = false;
        if (this.mRefreshView != null && this.mRefreshView.isRefreshing()) {
            this.mRefreshView.setRefreshing(false);
        }
        if (this.mRecyclerViewAdapter != null) {
            this.mRecyclerViewAdapter.setData(videoListBeanItems);
            this.mRecyclerViewAdapter.notifyDataSetChanged();
            this.mVideoListBean = videoListBeanItems;
        }
    }

    public void addMoreData(List<AliyunVideoListBean.VideoDataBean.VideoListBean> videoListBeanItems) {
        if (videoListBeanItems == null || videoListBeanItems.size() < 10) {
            this.isEnd = true;
            return;
        }
        this.isEnd = false;
        this.clearNotShowVideo(videoListBeanItems);
        this.mIsLoadingData = false;
        if (this.mRecyclerViewAdapter != null) {
            this.mRecyclerViewAdapter.addMoreData(videoListBeanItems);
        }
        this.hideRefresh();
    }

    private void clearNotShowVideo(List<AliyunVideoListBean.VideoDataBean.VideoListBean> list) {
        Iterator<AliyunVideoListBean.VideoDataBean.VideoListBean> it = list.iterator();
        while (it.hasNext()) {
            if (it.next().getSourceType() != VideoSourceType.TYPE_ERROR_NOT_SHOW) continue;
            it.remove();
        }
    }

    public void showRefresh() {
        if (this.mRefreshView != null) {
            this.mRefreshView.setRefreshing(true);
        }
    }

    public void hideRefresh() {
        if (this.mRefreshView != null) {
            this.mRefreshView.setRefreshing(false);
        }
    }

    public void setCorrelationTable(SparseArray<String> sparseArray) {
        this.mSparseArray = sparseArray;
    }

    public SparseArray<String> getCorrelationTable() {
        return this.mSparseArray;
    }

    private void stopPlay() {
        ViewParent parent = this.mListPlayerContainer.getParent();
        if (parent instanceof FrameLayout) {
            ((FrameLayout)parent).removeView(this.mListPlayerContainer);
        }
        this.mAliListPlayer.stop();
        this.mAliListPlayer.setSurface(null);
    }

    public void setOnBackground(boolean isOnBackground) {
        this.mIsOnBackground = isOnBackground;
        if (isOnBackground) {
            this.pausePlay();
        } else {
            this.resumePlay();
        }
    }

    private void pausePlay() {
        this.mIsPause = true;
        this.mPlayIconImageView.setVisibility(0);
        this.mAliListPlayer.pause();
    }

    private void resumePlay() {
        this.mIsPause = false;
        this.mPlayIconImageView.setVisibility(8);
        this.mAliListPlayer.start();
    }

    public void destroy() {
        if (this.mAliListPlayer != null) {
            this.mAliListPlayer.stop();
            this.mAliListPlayer.release();
        }
    }

    public void setOnRefreshDataListener(OnRefreshDataListener onRefreshDataListener) {
        this.onRefreshDataListener = onRefreshDataListener;
    }

    public static interface OnRefreshDataListener {
        public void onRefresh();

        public void onLoadMore();
    }
}

