/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.aliyunplayerbase.view.tipsview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aliyun.player.aliyunplayerbase.R;
import com.aliyun.player.aliyunplayerbase.view.tipsview.OnTipsViewBackClickListener;

public class CustomTipsView
extends RelativeLayout {
    private TextView mStopPlayBtn;
    private OnTipsViewClickListener mOnTipsViewClickListener = null;
    private OnTipsViewBackClickListener mOnTipsViewBackClickListener = null;
    private ImageView mBackImageView;
    private TextView mMsgTextView;
    private TextView mContinuePlayTextView;

    public CustomTipsView(Context context) {
        super(context);
        this.init();
    }

    public CustomTipsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CustomTipsView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getApplicationContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.alivc_dialog_netchange, (ViewGroup)this);
        this.mMsgTextView = (TextView)view.findViewById(R.id.msg);
        this.mContinuePlayTextView = (TextView)view.findViewById(R.id.continue_play);
        this.mContinuePlayTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomTipsView.this.mOnTipsViewClickListener != null) {
                    CustomTipsView.this.mOnTipsViewClickListener.onWait();
                }
            }
        });
        this.mStopPlayBtn = (TextView)view.findViewById(R.id.stop_play);
        this.mBackImageView = (ImageView)view.findViewById(R.id.iv_back);
        this.mStopPlayBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CustomTipsView.this.mOnTipsViewClickListener != null) {
                    CustomTipsView.this.mOnTipsViewClickListener.onExit();
                }
            }
        });
        this.mBackImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CustomTipsView.this.mOnTipsViewBackClickListener != null) {
                    CustomTipsView.this.mOnTipsViewBackClickListener.onBackClick();
                }
            }
        });
    }

    public void setTipsText(String tipsContext) {
        if (this.mMsgTextView != null) {
            this.mMsgTextView.setText((CharSequence)tipsContext);
        }
    }

    public void setConfirmText(String confirmText) {
        if (this.mContinuePlayTextView != null) {
            this.mContinuePlayTextView.setText((CharSequence)confirmText);
        }
    }

    public void setCancelText(String cancelText) {
        if (this.mStopPlayBtn != null) {
            this.mStopPlayBtn.setText((CharSequence)cancelText);
        }
    }

    public void setOnTipsViewClickListener(OnTipsViewClickListener l) {
        this.mOnTipsViewClickListener = l;
    }

    public void setOnBackClickListener(OnTipsViewBackClickListener listener) {
        this.mOnTipsViewBackClickListener = listener;
    }

    public static interface OnTipsViewClickListener {
        public void onWait();

        public void onExit();
    }
}

