/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.util.download;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;

public class DownloadDBHelper
extends SQLiteOpenHelper {
    private static final String DB_NAME = "download.db";
    private static final String TABLE_NAME = "download_cache";
    private static DownloadDBHelper helper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadDBHelper getDownloadHelper(Context context, int version) {
        if (helper != null) return helper;
        Class<DownloadDBHelper> clazz = DownloadDBHelper.class;
        synchronized (DownloadDBHelper.class) {
            if (helper != null) return helper;
            helper = new DownloadDBHelper(context, version);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return helper;
        }
    }

    private DownloadDBHelper(Context context, int version) {
        this(context, DB_NAME, null, version);
    }

    private DownloadDBHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, DB_NAME, factory, version);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table if not exists download_cache (_id integer primary key autoincrement, vid varchar(50), title varchar(50), cover varchar(255),  size long, progress double, quality varchar(10), state integer,  completeTime long)");
    }

    public long insert(AliyunDownloadMediaInfo info, int state) {
        if (this.hasAdded(info)) {
            return -1L;
        }
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("vid", info.getVid());
        values.put("title", info.getTitle());
        values.put("cover", info.getCoverUrl());
        values.put("size", Long.valueOf(info.getSize()));
        values.put("progress", Integer.valueOf(info.getProgress()));
        values.put("quality", info.getQuality());
        values.put("state", Integer.valueOf(state));
        long insert = db.insert(TABLE_NAME, null, values);
        db.close();
        return insert;
    }

    public long insertOnly(String columnName, ContentValues values) {
        SQLiteDatabase db = this.getWritableDatabase();
        return 0L;
    }

    private boolean hasAdded(AliyunDownloadMediaInfo info) {
        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = db.rawQuery("select * from download_cache where vid = ? and quality = ? and size = ?", new String[]{info.getVid(), info.getQuality(), String.valueOf(info.getSize())});
        boolean exist = cursor.moveToNext();
        cursor.close();
        return exist;
    }

    public int delete(String whereClause, String[] whereArgs) {
        SQLiteDatabase db = this.getWritableDatabase();
        int delete = db.delete(TABLE_NAME, whereClause, whereArgs);
        db.close();
        return delete;
    }

    public int update(AliyunDownloadMediaInfo info, String whereClause, String[] whereArgs, int state) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("vid", info.getVid());
        values.put("progress", Integer.valueOf(info.getProgress()));
        values.put("state", Integer.valueOf(state));
        int update = db.update(TABLE_NAME, values, whereClause, whereArgs);
        db.close();
        return update;
    }

    public Cursor query(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = db.query(TABLE_NAME, columns, selection, selectionArgs, groupBy, having, orderBy);
        return cursor;
    }

    public Cursor query(String[] colums, String selection, String[] selectionArgs) {
        SQLiteDatabase db = this.getWritableDatabase();
        Cursor cursor = db.query(TABLE_NAME, colums, selection, selectionArgs, null, null, null);
        return cursor;
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public static interface DownloadState {
        public static final int STATE_DOWNLOADING = 0;
        public static final int STATE_PAUSE = 1;
        public static final int STATE_COMPLETE = 2;
    }
}

