/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.download;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.util.FixedToastUtils;
import com.aliyun.player.alivcplayerexpand.util.download.AliyunDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.download.AlivcDownloadMediaInfo;
import com.aliyun.player.alivcplayerexpand.view.download.DownloadSection;
import com.aliyun.player.alivcplayerexpand.view.sectionlist.SectionedRecyclerViewAdapter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DownloadView
extends FrameLayout
implements View.OnClickListener,
CompoundButton.OnCheckedChangeListener {
    private SectionedRecyclerViewAdapter sectionAdapter;
    private RecyclerView downloadListView;
    private LinearLayout downloadEmptyView;
    private ImageView ivDownloadDelete;
    private ImageView ivCloseEdit;
    private RelativeLayout rlDownloadManagerContent;
    private RelativeLayout rlDownloadManagerEdit;
    private RelativeLayout rlDownloadManagerEditDefault;
    private ArrayList<AlivcDownloadMediaInfo> alivcDownloadMediaInfos;
    private ArrayList<AlivcDownloadMediaInfo> alivcDownloadingMediaInfos;
    private WeakReference<Context> context;
    private CheckBox cbAllDownloadCheck;
    private LinearLayoutManager linearLayoutManager;
    private DownloadSection section;
    private boolean itemFollowCheckBox = true;
    private boolean isEditeState = false;
    private OnDownloadItemClickListener onDownloadItemClickListener;
    private OnNotifyItemCheckedListener onItemCheckAllListener;
    private OnDownloadViewListener onDownloadViewListener;

    public boolean isEditeState() {
        return this.isEditeState;
    }

    public void setEditeState(boolean editeState) {
        this.isEditeState = editeState;
    }

    public DownloadView(@NonNull Context context) {
        super(context);
        this.context = new WeakReference<Context>(context);
        this.initView();
    }

    public DownloadView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = new WeakReference<Context>(context);
        this.initView();
    }

    public DownloadView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = new WeakReference<Context>(context);
        this.initView();
    }

    private void initView() {
        LayoutInflater.from((Context)((Context)this.context.get())).inflate(R.layout.alivc_download_view_layout, (ViewGroup)this, true);
        this.downloadEmptyView = (LinearLayout)this.findViewById(R.id.alivc_layout_empty_view);
        this.downloadListView = (RecyclerView)this.findViewById(R.id.download_list_view);
        this.linearLayoutManager = new LinearLayoutManager(this.getContext());
        this.downloadListView.setLayoutManager((RecyclerView.LayoutManager)this.linearLayoutManager);
        this.rlDownloadManagerContent = (RelativeLayout)this.findViewById(R.id.rl_download_manager_content);
        this.rlDownloadManagerEdit = (RelativeLayout)this.findViewById(R.id.rl_download_manager_edit);
        this.rlDownloadManagerEditDefault = (RelativeLayout)this.findViewById(R.id.rl_download_manager_edit_default);
        this.ivDownloadDelete = (ImageView)this.findViewById(R.id.iv_download_delete);
        this.ivCloseEdit = (ImageView)this.findViewById(R.id.iv_close_edit);
        this.cbAllDownloadCheck = (CheckBox)this.findViewById(R.id.checkbox_all_select);
        this.cbAllDownloadCheck.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.ivDownloadDelete.setOnClickListener((View.OnClickListener)this);
        this.rlDownloadManagerEditDefault.setOnClickListener((View.OnClickListener)this);
        this.ivCloseEdit.setOnClickListener((View.OnClickListener)this);
        this.sectionAdapter = new SectionedRecyclerViewAdapter();
        this.alivcDownloadMediaInfos = new ArrayList();
        this.alivcDownloadingMediaInfos = new ArrayList();
        this.downloadListView.setItemAnimator(null);
        this.downloadListView.setAdapter((RecyclerView.Adapter)this.sectionAdapter);
        this.sectionAdapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                if (DownloadView.this.isEditeState()) {
                    boolean checkedState;
                    boolean selectAllChecked = DownloadView.this.cbAllDownloadCheck.isChecked();
                    for (AlivcDownloadMediaInfo info : DownloadView.this.alivcDownloadMediaInfos) {
                        checkedState = info.isCheckedState();
                        if (checkedState) continue;
                        if (selectAllChecked) {
                            DownloadView.this.itemFollowCheckBox = false;
                            DownloadView.this.cbAllDownloadCheck.setChecked(false);
                        }
                        return;
                    }
                    for (AlivcDownloadMediaInfo info : DownloadView.this.alivcDownloadingMediaInfos) {
                        checkedState = info.isCheckedState();
                        if (checkedState) continue;
                        if (selectAllChecked) {
                            DownloadView.this.itemFollowCheckBox = false;
                            DownloadView.this.cbAllDownloadCheck.setChecked(false);
                        }
                        return;
                    }
                    DownloadView.this.cbAllDownloadCheck.setChecked(true);
                }
            }
        });
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.rl_download_manager_edit_default) {
            this.changeDownloadEditState(true);
            this.isEditeState = true;
            this.cbAllDownloadCheck.setChecked(false);
        } else if (i == R.id.iv_download_delete) {
            ArrayList<AlivcDownloadMediaInfo> deleteDownloadMediaInfos = new ArrayList<AlivcDownloadMediaInfo>();
            for (AlivcDownloadMediaInfo val : this.alivcDownloadingMediaInfos) {
                if (!val.isCheckedState()) continue;
                deleteDownloadMediaInfos.add(val);
            }
            for (AlivcDownloadMediaInfo val : this.alivcDownloadMediaInfos) {
                if (!val.isCheckedState()) continue;
                deleteDownloadMediaInfos.add(val);
            }
            if (this.onDownloadViewListener != null) {
                if (deleteDownloadMediaInfos.size() <= 0) {
                    Context context = (Context)this.context.get();
                    if (context != null) {
                        FixedToastUtils.show(context, this.getResources().getString(R.string.alivc_not_choose_video));
                    }
                } else {
                    this.onDownloadViewListener.onDeleteDownloadInfo(deleteDownloadMediaInfos);
                }
            }
        } else if (i == R.id.iv_close_edit) {
            this.setEditeState(false);
            this.changeDownloadEditState(false);
            this.isEditeState = false;
        }
    }

    public void deleteDownloadInfo() {
        AlivcDownloadMediaInfo val;
        this.changeDownloadEditState(false);
        this.isEditeState = false;
        Iterator<AlivcDownloadMediaInfo> it = this.alivcDownloadingMediaInfos.iterator();
        while (it.hasNext()) {
            val = it.next();
            if (!val.isCheckedState()) continue;
            it.remove();
        }
        it = this.alivcDownloadMediaInfos.iterator();
        while (it.hasNext()) {
            val = it.next();
            if (!val.isCheckedState()) continue;
            it.remove();
        }
        if (this.alivcDownloadingMediaInfos.size() <= 0) {
            this.sectionAdapter.removeSection("DownloadingTag");
        }
        if (this.alivcDownloadMediaInfos.size() <= 0) {
            this.sectionAdapter.removeSection("DownloadedTag");
        }
        this.sectionAdapter.notifyDataSetChanged();
        this.showDownloadContentView();
    }

    public void deleteDownloadInfo(AliyunDownloadMediaInfo downloadMediaInfo) {
        AliyunDownloadMediaInfo mediaInfo;
        AlivcDownloadMediaInfo val;
        this.changeDownloadEditState(false);
        this.isEditeState = false;
        Iterator<AlivcDownloadMediaInfo> it = this.alivcDownloadingMediaInfos.iterator();
        while (it.hasNext()) {
            val = it.next();
            mediaInfo = val.getAliyunDownloadMediaInfo();
            if (!mediaInfo.getQuality().equals(downloadMediaInfo.getQuality()) || !mediaInfo.getFormat().equals(downloadMediaInfo.getFormat()) || !mediaInfo.getVid().equals(downloadMediaInfo.getVid())) continue;
            it.remove();
        }
        it = this.alivcDownloadMediaInfos.iterator();
        while (it.hasNext()) {
            val = it.next();
            mediaInfo = val.getAliyunDownloadMediaInfo();
            if (!mediaInfo.getQuality().equals(downloadMediaInfo.getQuality()) || !mediaInfo.getFormat().equals(downloadMediaInfo.getFormat()) || !mediaInfo.getVid().equals(downloadMediaInfo.getVid())) continue;
            it.remove();
        }
        if (this.alivcDownloadingMediaInfos.size() <= 0) {
            this.sectionAdapter.removeSection("DownloadingTag");
        }
        if (this.alivcDownloadMediaInfos.size() <= 0) {
            this.sectionAdapter.removeSection("DownloadedTag");
        }
        this.sectionAdapter.notifyDataSetChanged();
        this.showDownloadContentView();
    }

    public void addAllDownloadMediaInfo(List<AliyunDownloadMediaInfo> alldownloadMediaInfos) {
        if (alldownloadMediaInfos == null) {
            return;
        }
        for (AliyunDownloadMediaInfo downloadMediaInfo : alldownloadMediaInfos) {
            AlivcDownloadMediaInfo alivcDownloadMediaInfo;
            String title;
            String tag = downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete ? "DownloadedTag" : "DownloadingTag";
            String string2 = title = downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete ? this.getResources().getString(R.string.already_downloaded) : this.getResources().getString(R.string.download_caching);
            if (downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete || downloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Start && downloadMediaInfo.getProgress() == 100) {
                alivcDownloadMediaInfo = new AlivcDownloadMediaInfo();
                alivcDownloadMediaInfo.setAliyunDownloadMediaInfo(downloadMediaInfo);
                this.alivcDownloadMediaInfos.add(0, alivcDownloadMediaInfo);
                this.addSection(tag, title, this.alivcDownloadMediaInfos);
                continue;
            }
            alivcDownloadMediaInfo = new AlivcDownloadMediaInfo();
            alivcDownloadMediaInfo.setAliyunDownloadMediaInfo(downloadMediaInfo);
            this.alivcDownloadingMediaInfos.add(0, alivcDownloadMediaInfo);
            this.addSection(tag, title, this.alivcDownloadingMediaInfos);
        }
        this.sectionAdapter.notifyDataSetChanged();
        this.showDownloadContentView();
    }

    public void addDownloadMediaInfo(AliyunDownloadMediaInfo downloadMedia) {
        String title;
        if (this.hasAdded(downloadMedia)) {
            return;
        }
        String tag = downloadMedia.getStatus() == AliyunDownloadMediaInfo.Status.Complete ? "DownloadedTag" : "DownloadingTag";
        String string2 = title = downloadMedia.getStatus() == AliyunDownloadMediaInfo.Status.Complete ? this.getResources().getString(R.string.already_downloaded) : this.getResources().getString(R.string.download_caching);
        if (downloadMedia.getStatus() == AliyunDownloadMediaInfo.Status.Complete) {
            AlivcDownloadMediaInfo alivcDownloadMediaInfo = new AlivcDownloadMediaInfo();
            alivcDownloadMediaInfo.setEditState(this.isEditeState);
            alivcDownloadMediaInfo.setAliyunDownloadMediaInfo(downloadMedia);
            this.alivcDownloadMediaInfos.add(0, alivcDownloadMediaInfo);
            this.addSection(tag, title, this.alivcDownloadMediaInfos);
        } else {
            AlivcDownloadMediaInfo alivcDownloadMediaInfo = new AlivcDownloadMediaInfo();
            alivcDownloadMediaInfo.setEditState(this.isEditeState);
            alivcDownloadMediaInfo.setAliyunDownloadMediaInfo(downloadMedia);
            this.alivcDownloadingMediaInfos.add(0, alivcDownloadMediaInfo);
            this.addSection(tag, title, this.alivcDownloadingMediaInfos);
        }
        this.showDownloadContentView();
        this.sectionAdapter.notifyDataSetChanged();
    }

    private void addSection(String tag, String title, final ArrayList<AlivcDownloadMediaInfo> alivcDownloadMediaInfos) {
        if (this.sectionAdapter.getSection(tag) == null) {
            this.section = new DownloadSection((Context)this.context.get(), tag, title, alivcDownloadMediaInfos);
            this.section.setOnSectionItemClickListener(new DownloadSection.OnSectionItemClickListener(){

                @Override
                public void onItemClick(int posion, String tag) {
                    AlivcDownloadMediaInfo alivcDownloadMediaInfo;
                    int positionInSection = DownloadView.this.sectionAdapter.getPositionInSection(posion);
                    if (tag.equals("DownloadingTag")) {
                        alivcDownloadMediaInfo = (AlivcDownloadMediaInfo)DownloadView.this.alivcDownloadingMediaInfos.get(positionInSection);
                        if (alivcDownloadMediaInfo.isEditState()) {
                            alivcDownloadMediaInfo.setCheckedState(!alivcDownloadMediaInfo.isCheckedState());
                            DownloadView.this.sectionAdapter.notifyItemChangedInSection(tag, positionInSection);
                            return;
                        }
                    } else if (tag.equals("DownloadedTag") && (alivcDownloadMediaInfo = (AlivcDownloadMediaInfo)alivcDownloadMediaInfos.get(positionInSection)).isEditState()) {
                        alivcDownloadMediaInfo.setCheckedState(!alivcDownloadMediaInfo.isCheckedState());
                        DownloadView.this.sectionAdapter.notifyItemChangedInSection(tag, positionInSection);
                        return;
                    }
                    if (tag.equals("DownloadingTag")) {
                        AliyunDownloadMediaInfo aliyunDownloadMediaInfo = ((AlivcDownloadMediaInfo)DownloadView.this.alivcDownloadingMediaInfos.get(positionInSection)).getAliyunDownloadMediaInfo();
                        if (aliyunDownloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Start) {
                            if (DownloadView.this.onDownloadViewListener != null) {
                                DownloadView.this.onDownloadViewListener.onStop(aliyunDownloadMediaInfo);
                                DownloadView.this.sectionAdapter.notifyItemChangedInSection(tag, positionInSection);
                            }
                        } else if (aliyunDownloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Stop && aliyunDownloadMediaInfo.getStatus() != AliyunDownloadMediaInfo.Status.Complete) {
                            DownloadView.this.onDownloadViewListener.onStart(aliyunDownloadMediaInfo);
                            DownloadView.this.sectionAdapter.notifyItemChangedInSection(tag, positionInSection);
                        }
                    }
                    if (tag.equals("DownloadedTag") && DownloadView.this.onDownloadItemClickListener != null) {
                        DownloadView.this.onDownloadItemClickListener.onDownloadedItemClick(positionInSection);
                    }
                    if (tag.equals("DownloadingTag") && DownloadView.this.onDownloadItemClickListener != null) {
                        DownloadView.this.onDownloadItemClickListener.onDownloadingItemClick(alivcDownloadMediaInfos, positionInSection);
                    }
                }
            });
            this.sectionAdapter.addSection(tag, this.section);
        }
    }

    public void setOnDownloadedItemClickListener(OnDownloadItemClickListener listener) {
        this.onDownloadItemClickListener = listener;
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (buttonView.getId() == R.id.checkbox_all_select) {
            if (!this.itemFollowCheckBox) {
                this.itemFollowCheckBox = true;
                return;
            }
            for (AlivcDownloadMediaInfo info : this.alivcDownloadMediaInfos) {
                if (info == null) continue;
                info.setCheckedState(isChecked);
            }
            for (AlivcDownloadMediaInfo info : this.alivcDownloadingMediaInfos) {
                if (info == null) continue;
                info.setCheckedState(isChecked);
            }
            this.sectionAdapter.notifyDataSetChanged();
        }
    }

    public void setOnItemCheckAllListener(OnNotifyItemCheckedListener listener) {
        this.onItemCheckAllListener = listener;
    }

    public void removeDownloadingMeiaInfo(AliyunDownloadMediaInfo downloadingMedia) {
        for (AlivcDownloadMediaInfo info : this.alivcDownloadingMediaInfos) {
            AliyunDownloadMediaInfo mInfo = info.getAliyunDownloadMediaInfo();
            if (!info.getAliyunDownloadMediaInfo().getVid().equals(downloadingMedia.getVid()) || !info.getAliyunDownloadMediaInfo().getFormat().equals(downloadingMedia.getFormat()) || !info.getAliyunDownloadMediaInfo().getQuality().equals(downloadingMedia.getQuality())) continue;
            this.alivcDownloadingMediaInfos.remove(info);
            break;
        }
        if (this.alivcDownloadingMediaInfos.size() <= 0) {
            this.sectionAdapter.removeSection("DownloadingTag");
        }
        this.sectionAdapter.notifyDataSetChanged();
    }

    public boolean hasAdded(AliyunDownloadMediaInfo info) {
        for (AlivcDownloadMediaInfo downloadMediaInfo : this.alivcDownloadingMediaInfos) {
            if (!info.getFormat().equals(downloadMediaInfo.getAliyunDownloadMediaInfo().getFormat()) || !info.getQuality().equals(downloadMediaInfo.getAliyunDownloadMediaInfo().getQuality()) || !info.getVid().equals(downloadMediaInfo.getAliyunDownloadMediaInfo().getVid()) || info.isEncripted() != downloadMediaInfo.getAliyunDownloadMediaInfo().isEncripted()) continue;
            Context context = (Context)this.context.get();
            if (context != null) {
                FixedToastUtils.show(context, context.getResources().getString(R.string.alivc_video_downloading_tips));
            }
            return true;
        }
        for (AlivcDownloadMediaInfo alivcDownloadMediaInfo : this.alivcDownloadMediaInfos) {
            if (!info.getFormat().equals(alivcDownloadMediaInfo.getAliyunDownloadMediaInfo().getFormat()) || !info.getQuality().equals(alivcDownloadMediaInfo.getAliyunDownloadMediaInfo().getQuality()) || !info.getVid().equals(alivcDownloadMediaInfo.getAliyunDownloadMediaInfo().getVid()) || info.isEncripted() != alivcDownloadMediaInfo.getAliyunDownloadMediaInfo().isEncripted()) continue;
            Context context = (Context)this.context.get();
            if (context != null) {
                FixedToastUtils.show(context, context.getResources().getString(R.string.alivc_video_download_finish_tips));
            }
            return true;
        }
        return false;
    }

    public void updateInfo(AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        AlivcDownloadMediaInfo tmpInfo = null;
        for (AlivcDownloadMediaInfo info : this.alivcDownloadingMediaInfos) {
            if (!info.getAliyunDownloadMediaInfo().getVid().equals(aliyunDownloadMediaInfo.getVid()) || !info.getAliyunDownloadMediaInfo().getQuality().equals(aliyunDownloadMediaInfo.getQuality()) || !info.getAliyunDownloadMediaInfo().getFormat().equals(aliyunDownloadMediaInfo.getFormat())) continue;
            tmpInfo = info;
            break;
        }
        if (tmpInfo != null) {
            tmpInfo.getAliyunDownloadMediaInfo().setProgress(aliyunDownloadMediaInfo.getProgress());
            tmpInfo.getAliyunDownloadMediaInfo().setStatus(aliyunDownloadMediaInfo.getStatus());
        }
        this.sectionAdapter.notifyDataSetChanged();
    }

    public void updateProgress() {
    }

    public void changeDownloadEditState(boolean isEdit) {
        for (AlivcDownloadMediaInfo info : this.alivcDownloadMediaInfos) {
            if (info == null) continue;
            info.setEditState(isEdit);
        }
        for (AlivcDownloadMediaInfo info : this.alivcDownloadingMediaInfos) {
            if (info == null) continue;
            info.setEditState(isEdit);
        }
        this.rlDownloadManagerEdit.setVisibility(isEdit ? 0 : 8);
        this.rlDownloadManagerEditDefault.setVisibility(isEdit ? 8 : 0);
        this.sectionAdapter.notifyDataSetChanged();
    }

    public void updateInfoByComplete(AliyunDownloadMediaInfo aliyunDownloadMediaInfo) {
        if (aliyunDownloadMediaInfo.getStatus() == AliyunDownloadMediaInfo.Status.Complete) {
            this.removeDownloadingMeiaInfo(aliyunDownloadMediaInfo);
            this.addDownloadMediaInfo(aliyunDownloadMediaInfo);
        }
        this.showDownloadContentView();
        this.sectionAdapter.notifyDataSetChanged();
    }

    public void updateInfoByError(AliyunDownloadMediaInfo info) {
        if (info != null && info.getStatus() == AliyunDownloadMediaInfo.Status.Error) {
            this.sectionAdapter.notifyDataSetChanged();
            this.showDownloadContentView();
        }
    }

    public void showDownloadContentView() {
        if (this.alivcDownloadMediaInfos.size() > 0 || this.alivcDownloadingMediaInfos.size() > 0) {
            this.downloadEmptyView.setVisibility(8);
            this.rlDownloadManagerContent.setVisibility(0);
        } else if (this.alivcDownloadMediaInfos.size() <= 0 || this.alivcDownloadingMediaInfos.size() <= 0) {
            this.downloadEmptyView.setVisibility(0);
            this.rlDownloadManagerContent.setVisibility(8);
        }
        if (this.isEditeState()) {
            this.rlDownloadManagerEdit.setVisibility(0);
            this.rlDownloadManagerEditDefault.setVisibility(8);
        } else {
            this.rlDownloadManagerEdit.setVisibility(8);
            this.rlDownloadManagerEditDefault.setVisibility(0);
        }
    }

    public void setOnDownloadViewListener(OnDownloadViewListener onDownloadViewListener) {
        this.onDownloadViewListener = onDownloadViewListener;
    }

    public ArrayList<AlivcDownloadMediaInfo> getAllDownloadMediaInfo() {
        if (this.alivcDownloadMediaInfos == null) {
            this.alivcDownloadMediaInfos = new ArrayList();
        }
        return this.alivcDownloadMediaInfos;
    }

    public ArrayList<AlivcDownloadMediaInfo> getDownloadMediaInfo() {
        ArrayList<AlivcDownloadMediaInfo> allDownloadMediaInfo = new ArrayList<AlivcDownloadMediaInfo>();
        if (this.alivcDownloadMediaInfos == null) {
            this.alivcDownloadMediaInfos = new ArrayList();
        }
        if (this.alivcDownloadingMediaInfos == null) {
            this.alivcDownloadMediaInfos = new ArrayList();
        }
        allDownloadMediaInfo.addAll(this.alivcDownloadMediaInfos);
        allDownloadMediaInfo.addAll(this.alivcDownloadingMediaInfos);
        return allDownloadMediaInfo;
    }

    public static interface OnDownloadViewListener {
        public void onStop(AliyunDownloadMediaInfo var1);

        public void onStart(AliyunDownloadMediaInfo var1);

        public void onDeleteDownloadInfo(ArrayList<AlivcDownloadMediaInfo> var1);
    }

    public static interface OnNotifyItemCheckedListener {
        public void onItemCheck(boolean var1);
    }

    public static interface OnDownloadItemClickListener {
        public void onDownloadedItemClick(int var1);

        public void onDownloadingItemClick(ArrayList<AlivcDownloadMediaInfo> var1, int var2);
    }
}

