/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.gesture;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import com.aliyun.player.alivcplayerexpand.view.gesture.GestureControl;
import com.aliyun.player.alivcplayerexpand.view.interfaces.ViewAction;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;

public class GestureView
extends View
implements ViewAction {
    private static final String TAG = GestureView.class.getSimpleName();
    protected GestureControl mGestureControl;
    private GestureListener mOutGestureListener = null;
    private ViewAction.HideType mHideType = null;
    private boolean mIsFullScreenLocked = false;
    private boolean mIsInMultiWindow;

    public GestureView(Context context) {
        super(context);
        this.init();
    }

    public GestureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GestureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mGestureControl = new GestureControl(this.getContext(), this);
        this.mGestureControl.setMultiWindow(this.mIsInMultiWindow);
        this.mGestureControl.setView(this);
        this.mGestureControl.setOnGestureControlListener(new GestureListener(){

            @Override
            public void onHorizontalDistance(float downX, float nowX) {
                if (GestureView.this.mIsFullScreenLocked) {
                    return;
                }
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onHorizontalDistance(downX, nowX);
                }
            }

            @Override
            public void onLeftVerticalDistance(float downY, float nowY) {
                if (GestureView.this.mIsFullScreenLocked) {
                    return;
                }
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onLeftVerticalDistance(downY, nowY);
                }
            }

            @Override
            public void onRightVerticalDistance(float downY, float nowY) {
                if (GestureView.this.mIsFullScreenLocked) {
                    return;
                }
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onRightVerticalDistance(downY, nowY);
                }
            }

            @Override
            public void onGestureEnd() {
                if (GestureView.this.mIsFullScreenLocked) {
                    return;
                }
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onGestureEnd();
                }
            }

            @Override
            public void onSingleTap() {
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onSingleTap();
                }
            }

            @Override
            public void onDoubleTap() {
                if (GestureView.this.mIsFullScreenLocked) {
                    return;
                }
                if (GestureView.this.mOutGestureListener != null) {
                    GestureView.this.mOutGestureListener.onDoubleTap();
                }
            }
        });
    }

    public void setScreenLockStatus(boolean locked) {
        this.mIsFullScreenLocked = locked;
    }

    public void setHideType(ViewAction.HideType hideType) {
        this.mHideType = hideType;
    }

    public void setMultiWindow(boolean isInMultiWindow) {
        this.mIsInMultiWindow = isInMultiWindow;
        if (this.mGestureControl != null) {
            this.mGestureControl.setMultiWindow(this.mIsInMultiWindow);
        }
    }

    public void setOnGestureListener(GestureListener gestureListener) {
        this.mOutGestureListener = gestureListener;
    }

    @Override
    public void reset() {
        this.mHideType = null;
    }

    @Override
    public void show() {
        if (this.mHideType != ViewAction.HideType.End) {
            this.setVisibility(0);
        }
    }

    @Override
    public void hide(ViewAction.HideType hideType) {
        if (this.mHideType != ViewAction.HideType.End) {
            this.mHideType = hideType;
        }
        this.setVisibility(8);
    }

    @Override
    public void setScreenModeStatus(AliyunScreenMode mode) {
    }

    public static interface GestureListener {
        public void onHorizontalDistance(float var1, float var2);

        public void onLeftVerticalDistance(float var1, float var2);

        public void onRightVerticalDistance(float var1, float var2);

        public void onGestureEnd();

        public void onSingleTap();

        public void onDoubleTap();
    }
}

