/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.guide;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;
import com.aliyun.player.alivcplayerexpand.theme.ITheme;
import com.aliyun.player.alivcplayerexpand.theme.Theme;
import com.aliyun.player.aliyunplayerbase.util.AliyunScreenMode;

public class GuideView
extends LinearLayout
implements ITheme {
    private TextView mBrightText;
    private TextView mProgressText;
    private TextView mVolumeText;

    public GuideView(Context context) {
        super(context);
        this.init();
    }

    public GuideView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GuideView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(Color.parseColor((String)"#88000000"));
        this.setGravity(17);
        this.setOrientation(1);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_view_guide, (ViewGroup)this, true);
        this.mBrightText = (TextView)this.findViewById(R.id.bright_text);
        this.mProgressText = (TextView)this.findViewById(R.id.progress_text);
        this.mVolumeText = (TextView)this.findViewById(R.id.volume_text);
        this.hide();
    }

    public void setScreenMode(AliyunScreenMode mode) {
        if (mode == AliyunScreenMode.Small) {
            this.hide();
            return;
        }
        SharedPreferences spf = this.getContext().getSharedPreferences("alivc_guide_record", 0);
        boolean hasShown = spf.getBoolean("has_shown", false);
        if (hasShown) {
            return;
        }
        this.setVisibility(0);
        SharedPreferences.Editor editor = spf.edit();
        editor.putBoolean("has_shown", true);
        editor.apply();
    }

    public void hide() {
        this.setVisibility(8);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.hide();
        return true;
    }

    @Override
    public void setTheme(Theme theme) {
        int colorRes = R.color.alivc_blue;
        if (theme == Theme.Blue) {
            colorRes = R.color.alivc_blue;
        } else if (theme == Theme.Green) {
            colorRes = R.color.alivc_green;
        } else if (theme == Theme.Orange) {
            colorRes = R.color.alivc_orange;
        } else if (theme == Theme.Red) {
            colorRes = R.color.alivc_red;
        }
        int color2 = ContextCompat.getColor((Context)this.getContext(), (int)colorRes);
        this.mBrightText.setTextColor(color2);
        this.mProgressText.setTextColor(color2);
        this.mVolumeText.setTextColor(color2);
    }
}

