/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.more;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;

public class DanmakuSettingView
extends LinearLayout {
    public static final int ALPHA_PROGRESS_DEFAULT = 0;
    public static final int SPEED_PROGRESS_DEFAULT = 30;
    public static final int REGION_PROGRESS_DEFAULT = 0;
    private View view;
    private SeekBar mAlphaSeek;
    private TextView mAlphaValueTextView;
    private SeekBar.OnSeekBarChangeListener mOnAlphaSeekBarChangeListener;
    private int mAlphProgress;
    private SeekBar mRegionSeek;
    private TextView mRegionValueTextView;
    private SeekBar.OnSeekBarChangeListener mOnRegionSeekBarChangeListener;
    private int mRegionProgress;
    private SeekBar mSpeedSeek;
    private TextView mSpeedValueTextView;
    private SeekBar.OnSeekBarChangeListener mOnSpeedSeekBarChangeListener;
    private int mSpeedProgress;
    private TextView mDefaultTextView;
    private OnDefaultClickListener mOnDefaultClickListener;

    public DanmakuSettingView(Context context) {
        super(context);
        this.init(context);
    }

    public DanmakuSettingView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DanmakuSettingView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.view = LayoutInflater.from((Context)context).inflate(R.layout.alivc_dialog_danmaku_setting, (ViewGroup)this, true);
        this.initView();
        this.initListener();
        this.initDefault();
    }

    private void initView() {
        this.mAlphaSeek = (SeekBar)this.view.findViewById(R.id.seek_alpha);
        this.mSpeedSeek = (SeekBar)this.view.findViewById(R.id.seek_speed);
        this.mRegionSeek = (SeekBar)this.view.findViewById(R.id.seek_region);
        this.mDefaultTextView = (TextView)this.view.findViewById(R.id.tv_default);
        this.mAlphaValueTextView = (TextView)this.view.findViewById(R.id.tv_alpha_value);
        this.mSpeedValueTextView = (TextView)this.view.findViewById(R.id.tv_speed_value);
        this.mRegionValueTextView = (TextView)this.view.findViewById(R.id.tv_region_value);
    }

    private void initListener() {
        this.mAlphaSeek.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DanmakuSettingView.this.mAlphProgress = progress;
                if (DanmakuSettingView.this.mOnAlphaSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnAlphaSeekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
                }
                if (DanmakuSettingView.this.mAlphaValueTextView != null) {
                    DanmakuSettingView.this.mAlphaValueTextView.setText((CharSequence)(progress + "%"));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnAlphaSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnAlphaSeekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnAlphaSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnAlphaSeekBarChangeListener.onStopTrackingTouch(seekBar);
                }
            }
        });
        this.mSpeedSeek.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DanmakuSettingView.this.mSpeedProgress = progress;
                if (DanmakuSettingView.this.mOnSpeedSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnSpeedSeekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
                }
                if (DanmakuSettingView.this.mSpeedValueTextView != null) {
                    DanmakuSettingView.this.mSpeedValueTextView.setText((CharSequence)(progress + "%"));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnSpeedSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnSpeedSeekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnSpeedSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnSpeedSeekBarChangeListener.onStopTrackingTouch(seekBar);
                }
            }
        });
        this.mRegionSeek.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                DanmakuSettingView.this.mRegionProgress = progress;
                if (DanmakuSettingView.this.mOnRegionSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnRegionSeekBarChangeListener.onProgressChanged(seekBar, progress, fromUser);
                }
                if (DanmakuSettingView.this.mRegionValueTextView != null) {
                    switch (progress) {
                        case 0: {
                            DanmakuSettingView.this.mRegionValueTextView.setText((CharSequence)DanmakuSettingView.this.getResources().getString(R.string.alivc_danmaku_position_quarter));
                            break;
                        }
                        case 1: {
                            DanmakuSettingView.this.mRegionValueTextView.setText((CharSequence)DanmakuSettingView.this.getResources().getString(R.string.alivc_danmaku_position_half));
                            break;
                        }
                        case 2: {
                            DanmakuSettingView.this.mRegionValueTextView.setText((CharSequence)DanmakuSettingView.this.getResources().getString(R.string.alivc_danmaku_position_Three_fourths));
                            break;
                        }
                        case 3: {
                            DanmakuSettingView.this.mRegionValueTextView.setText((CharSequence)DanmakuSettingView.this.getResources().getString(R.string.alivc_danmaku_position_unlimit));
                        }
                    }
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnRegionSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnRegionSeekBarChangeListener.onStartTrackingTouch(seekBar);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (DanmakuSettingView.this.mOnRegionSeekBarChangeListener != null) {
                    DanmakuSettingView.this.mOnRegionSeekBarChangeListener.onStopTrackingTouch(seekBar);
                }
            }
        });
        this.mDefaultTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DanmakuSettingView.this.mAlphaSeek.setProgress(0);
                DanmakuSettingView.this.mSpeedSeek.setProgress(30);
                DanmakuSettingView.this.mRegionSeek.setProgress(0);
                if (DanmakuSettingView.this.mOnDefaultClickListener != null) {
                    DanmakuSettingView.this.mOnDefaultClickListener.onDefaultClick();
                }
            }
        });
    }

    private void initDefault() {
        this.mAlphaSeek.setProgress(0);
        this.mSpeedSeek.setProgress(30);
        this.mRegionSeek.setProgress(0);
    }

    public void setAlphaProgress(int progress) {
        this.mAlphProgress = progress;
        if (this.mAlphaSeek != null) {
            this.mAlphaSeek.setProgress(progress);
        }
    }

    public void setSpeedProgress(int progress) {
        this.mSpeedProgress = progress;
        if (this.mSpeedSeek != null) {
            this.mSpeedSeek.setProgress(progress);
        }
    }

    public void setRegionProgress(int progress) {
        this.mRegionProgress = progress;
        if (this.mRegionSeek != null) {
            this.mRegionSeek.setProgress(progress);
        }
    }

    public void setOnAlphaSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        this.mOnAlphaSeekBarChangeListener = listener;
    }

    public void setOnRegionSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        this.mOnRegionSeekBarChangeListener = listener;
    }

    public void setOnSpeedSeekBarChangeListener(SeekBar.OnSeekBarChangeListener listener) {
        this.mOnSpeedSeekBarChangeListener = listener;
    }

    public void setOnDefaultListener(OnDefaultClickListener listener) {
        this.mOnDefaultClickListener = listener;
    }

    public static interface OnDefaultClickListener {
        public void onDefaultClick();
    }
}

