/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.view.thumbnail;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.aliyun.player.alivcplayerexpand.R;

public class ThumbnailView
extends LinearLayout {
    private TextView mPositionTextView;
    private ImageView mThumbnailImageView;

    public ThumbnailView(Context context) {
        super(context);
        this.init();
    }

    public ThumbnailView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ThumbnailView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.alivc_view_thumbnail, (ViewGroup)this, true);
        this.findAllViews();
    }

    private void findAllViews() {
        this.mPositionTextView = (TextView)this.findViewById(R.id.tv_position);
        this.mThumbnailImageView = (ImageView)this.findViewById(R.id.iv_thumbnail);
    }

    public void setTime(String time) {
        this.mPositionTextView.setText((CharSequence)time);
    }

    public void setThumbnailPicture(Bitmap bitmap) {
        this.mThumbnailImageView.setImageBitmap(bitmap);
    }

    public void showThumbnailView() {
        this.setVisibility(0);
    }

    public void hideThumbnailView() {
        this.setVisibility(8);
    }

    public ImageView getThumbnailImageView() {
        return this.mThumbnailImageView;
    }
}

