/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.player.alivcplayerexpand.widget;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.aliyun.player.alivcplayerexpand.widget.IRenderView;

public class TextureRenderView
extends TextureView
implements IRenderView,
TextureView.SurfaceTextureListener {
    private IRenderView.IRenderCallback mRenderCallback;
    private Surface mSurface;

    public TextureRenderView(Context context) {
        super(context);
        this.init(context);
    }

    public TextureRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public TextureRenderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        Log.e((String)"AliLivePlayerView", (String)"init: TextureRenderView");
        this.setSurfaceTextureListener(this);
    }

    @Override
    public void addRenderCallback(IRenderView.IRenderCallback renderCallback) {
        this.mRenderCallback = renderCallback;
    }

    @Override
    public View getView() {
        return this;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i1) {
        this.mSurface = new Surface(surfaceTexture);
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceCreate(this.mSurface);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceChanged(width, height);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.mSurface.release();
        if (this.mRenderCallback != null) {
            this.mRenderCallback.onSurfaceDestroyed();
        }
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

