/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.svideo.common.base;

import android.content.Context;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.aliyun.svideo.common.R;
import com.aliyun.svideo.common.base.BaseDialogFragment;
import com.aliyun.svideo.common.widget.WheelView;

public class AlivcWheelDialogFragment
extends BaseDialogFragment
implements WheelView.OnValueChangeListener {
    private WheelView mWheelView;
    private TextView mTvLeft;
    private TextView mTvRight;
    public FragmentManager mFragmentManager;
    private String[] mDialogWheel;
    private String mDialogLeft;
    private String mDialogRight;
    private OnWheelDialogListener mOnWheelDialogListener;
    public boolean mIsCancelableOutside = true;
    public int mDialogAnimationRes = 0;

    @Override
    protected int getLayoutRes() {
        return R.layout.alivc_common_dialogfragment_wheelview;
    }

    @Override
    protected void bindView(View view) {
        this.mTvLeft = (TextView)view.findViewById(R.id.alivc_tv_cancel);
        this.mTvRight = (TextView)view.findViewById(R.id.alivc_tv_sure);
        this.mWheelView = (WheelView)view.findViewById(R.id.alivc_wheelView_dialog);
        this.mTvLeft.setText((CharSequence)this.mDialogLeft);
        this.mTvRight.setText((CharSequence)this.mDialogRight);
        this.mWheelView.refreshByNewDisplayedValues(this.mDialogWheel);
        this.mWheelView.setWrapSelectorWheel(false);
        this.mWheelView.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.alivc_common_bg_white_gray));
        this.mWheelView.setSelectedTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.alivc_common_bg_black));
        this.mWheelView.setNormalTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.alivc_common_font_gray_333333));
        this.initEvent();
    }

    protected void initEvent() {
        this.mTvLeft.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlivcWheelDialogFragment.this.mOnWheelDialogListener != null) {
                    AlivcWheelDialogFragment.this.mOnWheelDialogListener.onClickLeft(AlivcWheelDialogFragment.this, AlivcWheelDialogFragment.this.getWheelValue());
                }
            }
        });
        this.mTvRight.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AlivcWheelDialogFragment.this.mOnWheelDialogListener != null) {
                    AlivcWheelDialogFragment.this.mOnWheelDialogListener.onClickRight(AlivcWheelDialogFragment.this, AlivcWheelDialogFragment.this.getWheelValue());
                }
            }
        });
    }

    private String getWheelValue() {
        String[] content = this.mWheelView.getDisplayedValues();
        return content == null ? null : content[this.mWheelView.getValue() - this.mWheelView.getMinValue()];
    }

    @Override
    public void onValueChange(WheelView picker, int oldVal, int newVal) {
        String[] content = this.mWheelView.getDisplayedValues();
        if (content != null && this.mOnWheelDialogListener != null) {
            this.mOnWheelDialogListener.onValueChanged(this, content[newVal - this.mWheelView.getMinValue()]);
        }
    }

    @Override
    protected boolean isCancelableOutside() {
        return this.mIsCancelableOutside;
    }

    @Override
    protected int getDialogAnimationRes() {
        return this.mDialogAnimationRes;
    }

    public AlivcWheelDialogFragment show() {
        Log.d((String)"Dialog", (String)"show");
        try {
            FragmentTransaction ft = this.mFragmentManager.beginTransaction();
            ft.remove((Fragment)this);
            ft.add((Fragment)this, this.tag);
            ft.commitAllowingStateLoss();
        }
        catch (Exception e) {
            Log.e((String)"Dialog", (String)e.toString());
        }
        return this;
    }

    public void setWheelDialogListener(OnWheelDialogListener onWheelDialogListener) {
        this.mOnWheelDialogListener = onWheelDialogListener;
    }

    static /* synthetic */ String[] access$202(AlivcWheelDialogFragment x0, String[] x1) {
        x0.mDialogWheel = x1;
        return x1;
    }

    public static interface OnWheelDialogListener {
        public void onClickLeft(DialogFragment var1, String var2);

        public void onClickRight(DialogFragment var1, String var2);

        public void onValueChanged(DialogFragment var1, String var2);
    }

    public static final class Builder {
        private AlivcWheelDialogFragment mDialogFragment = new AlivcWheelDialogFragment();

        public Builder(FragmentManager fragmentManager) {
            this.mDialogFragment.mFragmentManager = fragmentManager;
        }

        public Builder setWheelData(String[] data) {
            AlivcWheelDialogFragment.access$202(this.mDialogFragment, data);
            return this;
        }

        public Builder cancelString(String cancel) {
            this.mDialogFragment.mDialogLeft = cancel;
            return this;
        }

        public Builder sureString(String sure) {
            this.mDialogFragment.mDialogRight = sure;
            return this;
        }

        public Builder onWheelDialogListener(OnWheelDialogListener onWheelDialogListener) {
            this.mDialogFragment.mOnWheelDialogListener = onWheelDialogListener;
            return this;
        }

        public Builder isCancelableOutside(boolean outSide) {
            this.mDialogFragment.mIsCancelableOutside = outSide;
            return this;
        }

        public Builder dialogAnimationRes(int animation) {
            this.mDialogFragment.mDialogAnimationRes = animation;
            return this;
        }

        public AlivcWheelDialogFragment create() {
            return this.mDialogFragment;
        }
    }
}

